/*
 * Decompiled with CFR 0.152.
 */
package mryurihi.tbnbt.adapter.impl;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import mryurihi.tbnbt.TagType;
import mryurihi.tbnbt.adapter.AdapterRegistry;
import mryurihi.tbnbt.adapter.NBTAdapter;
import mryurihi.tbnbt.adapter.NBTParseException;
import mryurihi.tbnbt.adapter.TypeWrapper;

public class IntegerArrayAdapter
extends NBTAdapter<Integer[]> {
    @Override
    public Integer[] fromNBT(TagType id, DataInputStream payload, TypeWrapper<?> type, AdapterRegistry registry) throws NBTParseException {
        if (!id.equals((Object)TagType.INT_ARRAY)) {
            throw new NBTParseException(String.format("id %s does not match required id 11", id.getId()));
        }
        Integer[] out = new Integer[((Integer)registry.getIntAdapter().fromNBT(TagType.INT, payload, null, registry)).intValue()];
        for (int i = 0; i < out.length; ++i) {
            out[i] = (Integer)registry.getIntAdapter().fromNBT(TagType.INT, payload, null, registry);
        }
        return out;
    }

    @Override
    public void toNBT(DataOutputStream out, Object object, TypeWrapper<?> type, AdapterRegistry registry) throws NBTParseException {
        Integer[] intArr;
        if (object instanceof int[]) {
            intArr = new Integer[((int[])object).length];
            for (int i = 0; i < intArr.length; ++i) {
                intArr[i] = ((int[])object)[i];
            }
        } else {
            intArr = (Integer[])object;
        }
        registry.writeInt(out, intArr.length);
        for (Integer b : intArr) {
            registry.writeInt(out, b);
        }
    }

    @Override
    public TagType getId() {
        return TagType.INT_ARRAY;
    }
}

