/*
 * Decompiled with CFR 0.152.
 */
package mryurihi.tbnbt.adapter.impl;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.ParameterizedType;
import java.util.Collection;
import mryurihi.tbnbt.TagType;
import mryurihi.tbnbt.adapter.AdapterRegistry;
import mryurihi.tbnbt.adapter.NBTAdapter;
import mryurihi.tbnbt.adapter.NBTAdapterFactory;
import mryurihi.tbnbt.adapter.NBTParseException;
import mryurihi.tbnbt.adapter.TypeWrapper;

public class CollectionAdapterFactory
implements NBTAdapterFactory {
    @Override
    public <T> NBTAdapter<T> create(AdapterRegistry registry, TypeWrapper<T> type) {
        Class itemClass = (Class)((ParameterizedType)type.getType()).getActualTypeArguments()[0];
        return new Adapter(registry.getAdapterForObject(TypeWrapper.of(itemClass)), itemClass);
    }

    private static class Adapter<E>
    extends NBTAdapter<Collection<E>> {
        private NBTAdapter<E> itemAdapter;
        private Class<E> itemClass;

        public Adapter(NBTAdapter<E> itemAdapter, Class<E> itemClass) {
            this.itemAdapter = itemAdapter;
            this.itemClass = itemClass;
        }

        @Override
        public Collection<E> fromNBT(TagType id, DataInputStream payload, TypeWrapper<?> type, AdapterRegistry registry) throws NBTParseException {
            try {
                Constructor<?> constr = type.getClassType().getDeclaredConstructor(new Class[0]);
                constr.setAccessible(true);
                Collection out = (Collection)constr.newInstance(new Object[0]);
                TagType itemId = TagType.getTypeById(registry.fromByte(payload).byteValue());
                int length = payload.readInt();
                for (int i = 0; i < length; ++i) {
                    out.add(this.itemAdapter.fromNBT(itemId, payload, TypeWrapper.of(this.itemClass), registry));
                }
                return out;
            }
            catch (Exception e) {
                throw new NBTParseException(e);
            }
        }

        @Override
        public void toNBT(DataOutputStream out, Object object, TypeWrapper<?> type, AdapterRegistry registry) throws NBTParseException {
            try {
                Collection col = (Collection)object;
                registry.writeByte(out, (byte)this.itemAdapter.getId().getId());
                registry.writeInt(out, col.size());
                for (Object e : col) {
                    this.itemAdapter.toNBT(out, e, TypeWrapper.of(e.getClass()), registry);
                }
            }
            catch (Exception e) {
                throw new NBTParseException(e);
            }
        }

        @Override
        public TagType getId() {
            return TagType.LIST;
        }
    }
}

