/*
 * Decompiled with CFR 0.152.
 */
package mryurihi.tbnbt.adapter.impl;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import mryurihi.tbnbt.TagType;
import mryurihi.tbnbt.adapter.AdapterRegistry;
import mryurihi.tbnbt.adapter.NBTAdapter;
import mryurihi.tbnbt.adapter.NBTParseException;
import mryurihi.tbnbt.adapter.TypeWrapper;

public class ByteArrayAdapter
extends NBTAdapter<Byte[]> {
    @Override
    public Byte[] fromNBT(TagType id, DataInputStream payload, TypeWrapper<?> type, AdapterRegistry registry) throws NBTParseException {
        if (!id.equals((Object)TagType.BYTE_ARRAY)) {
            throw new NBTParseException(String.format("id %s does not match required id 7", id.getId()));
        }
        Byte[] out = new Byte[((Integer)registry.getIntAdapter().fromNBT(TagType.INT, payload, null, registry)).intValue()];
        for (int i = 0; i < out.length; ++i) {
            out[i] = registry.fromByte(payload);
        }
        return out;
    }

    @Override
    public void toNBT(DataOutputStream out, Object object, TypeWrapper<?> type, AdapterRegistry registry) throws NBTParseException {
        Byte[] byteArr;
        if (object instanceof byte[]) {
            byteArr = new Byte[((byte[])object).length];
            for (int i = 0; i < byteArr.length; ++i) {
                byteArr[i] = ((byte[])object)[i];
            }
        } else {
            byteArr = (Byte[])object;
        }
        registry.writeInt(out, byteArr.length);
        for (Byte b : byteArr) {
            registry.writeByte(out, b);
        }
    }

    @Override
    public TagType getId() {
        return TagType.BYTE_ARRAY;
    }
}

