/*
 * Decompiled with CFR 0.152.
 */
package mryurihi.tbnbt.adapter.impl;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import mryurihi.tbnbt.TagType;
import mryurihi.tbnbt.adapter.AdapterRegistry;
import mryurihi.tbnbt.adapter.NBTAdapter;
import mryurihi.tbnbt.adapter.NBTAdapterFactory;
import mryurihi.tbnbt.adapter.NBTParseException;
import mryurihi.tbnbt.adapter.TypeWrapper;

public class ArrayAdapterFactory
implements NBTAdapterFactory {
    @Override
    public <T> NBTAdapter<T> create(AdapterRegistry registry, TypeWrapper<T> type) {
        Class<?> compType = type.getClassType().getComponentType();
        return new Adapter(registry.getAdapterForObject(TypeWrapper.of(compType)), compType);
    }

    private class Adapter<T>
    extends NBTAdapter<T[]> {
        private NBTAdapter<T> contentAdapter;
        private Class<T> contentClass;

        public Adapter(NBTAdapter<T> contentAdapter, Class<T> contentClass) {
            this.contentAdapter = contentAdapter;
            this.contentClass = contentClass;
        }

        @Override
        public T[] fromNBT(TagType id, DataInputStream payload, TypeWrapper<?> type, AdapterRegistry registry) throws NBTParseException {
            try {
                TagType contentId = TagType.getTypeById(payload.readByte());
                Object[] out = new Object[registry.fromInt(payload).intValue()];
                for (int i = 0; i < out.length; ++i) {
                    out[i] = this.contentAdapter.fromNBT(contentId, payload, TypeWrapper.of(this.contentClass), registry);
                }
                return out;
            }
            catch (Exception e) {
                throw new NBTParseException(e);
            }
        }

        @Override
        public void toNBT(DataOutputStream out, Object object, TypeWrapper<?> type, AdapterRegistry registry) throws NBTParseException {
            try {
                Object[] output = (Object[])object;
                registry.writeByte(out, (byte)this.contentAdapter.getId().getId());
                registry.writeInt(out, output.length);
                for (Object o : output) {
                    this.contentAdapter.toNBT(out, o, TypeWrapper.of(this.contentClass), registry);
                }
            }
            catch (Exception e) {
                throw new NBTParseException(e);
            }
        }

        @Override
        public TagType getId() {
            return TagType.LIST;
        }
    }
}

