/*
 * Decompiled with CFR 0.152.
 */
package mryurihi.tbnbt.adapter;

import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;

public class TypeWrapper<E> {
    private Type type;
    private Class<E> classType;

    protected TypeWrapper() {
        try {
            this.type = ((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
        }
        catch (ClassCastException e) {
            throw new RuntimeException("This class is not parameterized somehow. If this appears, you have messed up badly");
        }
        this.classType = TypeWrapper.getTypeAsClassType(this.type);
    }

    private TypeWrapper(Type type) {
        this.type = type;
        this.classType = TypeWrapper.getTypeAsClassType(type);
    }

    public Class<E> getClassType() {
        return this.classType;
    }

    public Type getType() {
        return this.type;
    }

    public static <E> TypeWrapper<E> of(Class<E> cls) {
        return new TypeWrapper<E>(cls);
    }

    public static TypeWrapper<?> of(Type type) {
        return new TypeWrapper(type);
    }

    private static Class<?> getTypeAsClassType(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return (Class)((ParameterizedType)type).getRawType();
        }
        if (type instanceof GenericArrayType) {
            Type arrayType = ((GenericArrayType)type).getGenericComponentType();
            return Array.newInstance(TypeWrapper.getTypeAsClassType(arrayType), 0).getClass();
        }
        if (type instanceof TypeVariable) {
            return Object.class;
        }
        if (type instanceof WildcardType) {
            return TypeWrapper.getTypeAsClassType(((WildcardType)type).getUpperBounds()[0]);
        }
        throw new RuntimeException(String.format("%s is not an instance of any type implemented by this method", type.getTypeName()));
    }
}

