/*
 * Decompiled with CFR 0.152.
 */
package mryurihi.tbnbt.adapter;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import mryurihi.tbnbt.TagType;
import mryurihi.tbnbt.adapter.NBTAdapter;
import mryurihi.tbnbt.adapter.NBTAdapterFactory;
import mryurihi.tbnbt.adapter.NBTParseException;
import mryurihi.tbnbt.adapter.TypeWrapper;
import mryurihi.tbnbt.adapter.impl.ArrayAdapterFactory;
import mryurihi.tbnbt.adapter.impl.ByteArrayAdapter;
import mryurihi.tbnbt.adapter.impl.CollectionAdapterFactory;
import mryurihi.tbnbt.adapter.impl.IntegerArrayAdapter;
import mryurihi.tbnbt.adapter.impl.LongArrayAdapter;
import mryurihi.tbnbt.adapter.impl.MapAdapterFactory;
import mryurihi.tbnbt.adapter.impl.ObjectAdapter;
import mryurihi.tbnbt.adapter.impl.StringAdapter;
import mryurihi.tbnbt.adapter.impl.primitive.BooleanAdapter;
import mryurihi.tbnbt.adapter.impl.primitive.ByteAdapter;
import mryurihi.tbnbt.adapter.impl.primitive.DoubleAdapter;
import mryurihi.tbnbt.adapter.impl.primitive.FloatAdapter;
import mryurihi.tbnbt.adapter.impl.primitive.IntegerAdapter;
import mryurihi.tbnbt.adapter.impl.primitive.LongAdapter;
import mryurihi.tbnbt.adapter.impl.primitive.PrimitiveByteArrayAdapter;
import mryurihi.tbnbt.adapter.impl.primitive.PrimitiveIntArrayAdapter;
import mryurihi.tbnbt.adapter.impl.primitive.PrimitiveLongArrayAdapter;
import mryurihi.tbnbt.adapter.impl.primitive.ShortAdapter;

public class AdapterRegistry {
    private Map<Class<?>, NBTAdapter<?>> registry = new HashMap();
    private Map<Class<?>, NBTAdapterFactory> factory = new HashMap();

    private AdapterRegistry() {
        Class[] rClass = new Class[]{Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class, Byte[].class, byte[].class, String.class, Object.class, Integer[].class, int[].class, Long[].class, long[].class};
        NBTAdapter[] rAdapter = new NBTAdapter[]{new ByteAdapter(), new ShortAdapter(), new IntegerAdapter(), new LongAdapter(), new FloatAdapter(), new DoubleAdapter(), new ByteArrayAdapter(), new PrimitiveByteArrayAdapter(), new StringAdapter(), new ObjectAdapter(), new IntegerArrayAdapter(), new PrimitiveIntArrayAdapter(), new LongArrayAdapter(), new PrimitiveLongArrayAdapter()};
        for (int i = 0; i < rClass.length; ++i) {
            this.registry.put(rClass[i], rAdapter[i]);
        }
        this.factory.put(Collection.class, new CollectionAdapterFactory());
        this.factory.put(Object[].class, new ArrayAdapterFactory());
        this.factory.put(Map.class, new MapAdapterFactory());
    }

    public NBTAdapter<?> getAdapterForObject(TypeWrapper<?> objectTypeWrapper) {
        return this.getAdapterForObject(objectTypeWrapper, objectTypeWrapper);
    }

    private NBTAdapter<?> getAdapterForObject(TypeWrapper<?> objectTypeWrapper, TypeWrapper<?> topTypeWrapper) {
        Class<?> superClass;
        Class<?> objectType = objectTypeWrapper.getClassType();
        if (objectType.isPrimitive()) {
            if (objectType.equals(Byte.TYPE)) {
                return new ByteAdapter();
            }
            if (objectType.equals(Short.TYPE)) {
                return new ShortAdapter();
            }
            if (objectType.equals(Integer.TYPE)) {
                return new IntegerAdapter();
            }
            if (objectType.equals(Long.TYPE)) {
                return new LongAdapter();
            }
            if (objectType.equals(Float.TYPE)) {
                return new FloatAdapter();
            }
            if (objectType.equals(Double.TYPE)) {
                return new DoubleAdapter();
            }
            if (objectType.equals(Boolean.TYPE)) {
                return new BooleanAdapter();
            }
        }
        if (this.registry.containsKey(objectType)) {
            return this.registry.get(objectType);
        }
        if (this.factory.containsKey(objectType)) {
            return this.factory.get(objectType).create(this, topTypeWrapper);
        }
        if (objectType.getInterfaces().length != 0) {
            for (Type t : objectType.getGenericInterfaces()) {
                NBTAdapter<?> adapter = this.getAdapterForObject(TypeWrapper.of(t), topTypeWrapper);
                if (adapter == null) continue;
                return adapter;
            }
        }
        if ((superClass = objectType.getSuperclass()) == null) {
            return null;
        }
        NBTAdapter<?> out = this.getAdapterForObject(TypeWrapper.of(superClass), topTypeWrapper);
        return out;
    }

    public NBTAdapter<?> getByteAdapter() {
        return this.registry.get(Byte.class);
    }

    public Byte fromByte(DataInputStream payload) throws NBTParseException {
        return (Byte)this.registry.get(Byte.class).fromNBT(TagType.BYTE, payload, new TypeWrapper<Byte>(){}, this);
    }

    public void writeByte(DataOutputStream out, byte object) throws NBTParseException {
        this.registry.get(Byte.class).toNBT(out, object, new TypeWrapper<Byte>(){}, this);
    }

    public NBTAdapter<?> getShortAdapter() {
        return this.registry.get(Short.class);
    }

    public Short fromShort(DataInputStream payload) throws NBTParseException {
        return (Short)this.registry.get(Short.class).fromNBT(TagType.SHORT, payload, new TypeWrapper<Short>(){}, this);
    }

    public void writeShort(DataOutputStream out, short object) throws NBTParseException {
        this.registry.get(Short.class).toNBT(out, object, new TypeWrapper<Short>(){}, this);
    }

    public NBTAdapter<?> getIntAdapter() {
        return this.registry.get(Integer.class);
    }

    public Integer fromInt(DataInputStream payload) throws NBTParseException {
        return (Integer)this.registry.get(Integer.class).fromNBT(TagType.INT, payload, new TypeWrapper<Integer>(){}, this);
    }

    public void writeInt(DataOutputStream out, int object) throws NBTParseException {
        this.registry.get(Integer.class).toNBT(out, object, new TypeWrapper<Integer>(){}, this);
    }

    public NBTAdapter<?> getLongAdapter() {
        return this.registry.get(Long.class);
    }

    public Long fromLong(DataInputStream payload) throws NBTParseException {
        return (Long)this.registry.get(Long.class).fromNBT(TagType.LONG, payload, new TypeWrapper<Long>(){}, this);
    }

    public void writeLong(DataOutputStream out, long object) throws NBTParseException {
        this.registry.get(Long.class).toNBT(out, object, new TypeWrapper<Long>(){}, this);
    }

    public NBTAdapter<?> getFloatAdapter() {
        return this.registry.get(Float.class);
    }

    public Float fromFloat(DataInputStream payload) throws NBTParseException {
        return (Float)this.registry.get(Float.class).fromNBT(TagType.FLOAT, payload, new TypeWrapper<Float>(){}, this);
    }

    public void writeFloat(DataOutputStream out, float object) throws NBTParseException {
        this.registry.get(Float.class).toNBT(out, Float.valueOf(object), new TypeWrapper<Float>(){}, this);
    }

    public NBTAdapter<?> getDoubleAdapter() {
        return this.registry.get(Double.class);
    }

    public Double fromDouble(DataInputStream payload) throws NBTParseException {
        return (Double)this.registry.get(Double.class).fromNBT(TagType.DOUBLE, payload, new TypeWrapper<Double>(){}, this);
    }

    public void writeDouble(DataOutputStream out, double object) throws NBTParseException {
        this.registry.get(Double.class).toNBT(out, object, new TypeWrapper<Double>(){}, this);
    }

    public NBTAdapter<?> getByteArrayAdapter() {
        return this.registry.get(Byte[].class);
    }

    public Byte[] fromByteArray(DataInputStream payload) throws NBTParseException {
        return (Byte[])this.registry.get(Byte[].class).fromNBT(TagType.BYTE_ARRAY, payload, new TypeWrapper<Byte[]>(){}, this);
    }

    public void writeByteArray(DataOutputStream out, Byte[] object) throws NBTParseException {
        this.registry.get(Byte[].class).toNBT(out, object, new TypeWrapper<Byte[]>(){}, this);
    }

    public NBTAdapter<?> getStringAdapter() {
        return this.registry.get(String.class);
    }

    public String fromString(DataInputStream payload) throws NBTParseException {
        return (String)this.registry.get(String.class).fromNBT(TagType.STRING, payload, new TypeWrapper<String>(){}, this);
    }

    public void writeString(DataOutputStream out, String object) throws NBTParseException {
        this.registry.get(String.class).toNBT(out, object, new TypeWrapper<String>(){}, this);
    }

    public NBTAdapter<?> getIntArrayAdapter() {
        return this.registry.get(Long[].class);
    }

    public Integer[] fromIntArray(DataInputStream payload) throws NBTParseException {
        return (Integer[])this.registry.get(Integer[].class).fromNBT(TagType.INT_ARRAY, payload, new TypeWrapper<Integer[]>(){}, this);
    }

    public void writeIntArray(DataOutputStream out, Integer[] object) throws NBTParseException {
        this.registry.get(Integer[].class).toNBT(out, object, new TypeWrapper<Integer[]>(){}, this);
    }

    public NBTAdapter<?> getLongArrayAdapter() {
        return this.registry.get(Long[].class);
    }

    public Long[] fromLongArray(DataInputStream payload) throws NBTParseException {
        return (Long[])this.registry.get(Long[].class).fromNBT(TagType.LONG_ARRAY, payload, new TypeWrapper<Long[]>(){}, this);
    }

    public void writeLongArray(DataOutputStream out, Long[] object) throws NBTParseException {
        this.registry.get(Long[].class).toNBT(out, object, new TypeWrapper<Long[]>(){}, this);
    }

    public static class Builder {
        AdapterRegistry reg = new AdapterRegistry();

        public <B> Builder addAdapter(Class<B> type, NBTAdapter<B> adapter) {
            this.reg.registry.put(type, adapter);
            return this;
        }

        public Builder addFactory(Class<?> type, NBTAdapterFactory factory) {
            this.reg.factory.put(type, factory);
            return this;
        }

        public AdapterRegistry create() {
            return this.reg;
        }
    }
}

