/*
 * Decompiled with CFR 0.152.
 */
package com.github.mreutegg.laszip4j.laszip;

import com.github.mreutegg.laszip4j.laszip.ArithmeticDecoder;
import com.github.mreutegg.laszip4j.laszip.ByteStreamIn;
import com.github.mreutegg.laszip4j.laszip.ByteStreamInArray;
import com.github.mreutegg.laszip4j.laszip.IByteStreamInProvider;
import com.github.mreutegg.laszip4j.laszip.LAScontextRGBNIR14;
import com.github.mreutegg.laszip4j.laszip.LASreadItemCompressed;
import com.github.mreutegg.laszip4j.laszip.MutableInteger;
import com.github.mreutegg.laszip4j.laszip.MyDefs;
import com.github.mreutegg.laszip4j.laszip.PointDataRecord;
import com.github.mreutegg.laszip4j.laszip.PointDataRecordRgbNIR;

public class LASreadItemCompressed_RGBNIR14_v3
extends LASreadItemCompressed {
    private IByteStreamInProvider instreamProvider;
    private ByteStreamInArray instream_RGB;
    private ByteStreamInArray instream_NIR;
    private ArithmeticDecoder dec_RGB;
    private ArithmeticDecoder dec_NIR;
    private boolean changed_RGB;
    private boolean changed_NIR;
    private int num_bytes_RGB;
    private int num_bytes_NIR;
    private boolean requested_RGB;
    private boolean requested_NIR;
    private int current_context;
    private LAScontextRGBNIR14[] contexts = new LAScontextRGBNIR14[4];

    public LASreadItemCompressed_RGBNIR14_v3(IByteStreamInProvider instreamProvider, int decompress_selective) {
        assert (instreamProvider != null);
        this.instreamProvider = instreamProvider;
        this.instream_RGB = null;
        this.instream_NIR = null;
        this.dec_RGB = null;
        this.dec_NIR = null;
        this.num_bytes_RGB = 0;
        this.num_bytes_NIR = 0;
        this.changed_RGB = false;
        this.changed_NIR = false;
        this.requested_RGB = (decompress_selective & 0x100) != 0;
        this.requested_NIR = (decompress_selective & 0x200) != 0;
        for (int c = 0; c < this.contexts.length; ++c) {
            this.contexts[c] = new LAScontextRGBNIR14();
            this.contexts[c].m_rgb_bytes_used = null;
            this.contexts[c].m_nir_bytes_used = null;
        }
        this.current_context = 0;
    }

    @Override
    public void init(PointDataRecord seedItem, MutableInteger context) {
        byte[] bytes;
        ByteStreamIn instream = this.instreamProvider.getByteStreamIn();
        if (this.instream_RGB == null) {
            this.instream_RGB = new ByteStreamInArray();
            this.instream_NIR = new ByteStreamInArray();
            this.dec_RGB = new ArithmeticDecoder();
            this.dec_NIR = new ArithmeticDecoder();
        }
        if (this.requested_RGB) {
            if (this.num_bytes_RGB != 0) {
                bytes = new byte[this.num_bytes_RGB];
                instream.getBytes(bytes, this.num_bytes_RGB);
                this.instream_RGB.init(bytes, this.num_bytes_RGB);
                this.dec_RGB.init(this.instream_RGB);
                this.changed_RGB = true;
            } else {
                this.instream_RGB.init(null, 0L);
                this.changed_RGB = true;
            }
        } else {
            if (this.num_bytes_RGB != 0) {
                instream.skipBytes(this.num_bytes_RGB);
            }
            this.changed_RGB = false;
        }
        if (this.requested_NIR) {
            if (this.num_bytes_NIR != 0) {
                bytes = new byte[this.num_bytes_NIR];
                instream.getBytes(bytes, this.num_bytes_NIR);
                this.instream_NIR.init(bytes, this.num_bytes_NIR);
                this.dec_NIR.init(this.instream_NIR);
                this.changed_NIR = true;
            } else {
                this.instream_NIR.init(null, 0L);
                this.changed_NIR = false;
            }
        } else {
            if (this.num_bytes_NIR != 0) {
                instream.skipBytes(this.num_bytes_NIR);
            }
            this.changed_NIR = false;
        }
        for (int c = 0; c < 4; ++c) {
            this.contexts[c].unused = true;
        }
        this.current_context = context.get();
        this.createAndInitModelsAndDecompressors(this.current_context, (PointDataRecordRgbNIR)seedItem);
    }

    @Override
    public boolean chunk_sizes() {
        ByteStreamIn instream = this.instreamProvider.getByteStreamIn();
        this.num_bytes_RGB = instream.get32bitsLE();
        this.num_bytes_NIR = instream.get32bitsLE();
        return true;
    }

    @Override
    public PointDataRecord read(MutableInteger context) {
        int corr;
        PointDataRecordRgbNIR last_item = this.contexts[this.current_context].last_item;
        if (this.current_context != context.get()) {
            this.current_context = context.get();
            if (this.contexts[this.current_context].unused) {
                this.createAndInitModelsAndDecompressors(this.current_context, last_item);
                last_item = this.contexts[this.current_context].last_item;
            }
        }
        PointDataRecordRgbNIR result = new PointDataRecordRgbNIR();
        if (this.changed_RGB) {
            byte b;
            int diff = 0;
            int sym = this.dec_RGB.decodeSymbol(this.contexts[this.current_context].m_rgb_bytes_used);
            if ((sym & 1) != 0) {
                corr = this.dec_RGB.decodeSymbol(this.contexts[this.current_context].m_rgb_diff_0);
                b = MyDefs.U8_FOLD(corr + (last_item.R & 0xFF));
                result.R = (char)Byte.toUnsignedInt(b);
            } else {
                result.R = (char)(last_item.R & 0xFF);
            }
            if ((sym & 2) != 0) {
                corr = this.dec_RGB.decodeSymbol(this.contexts[this.current_context].m_rgb_diff_1);
                b = MyDefs.U8_FOLD(corr + (last_item.R >>> 8));
                result.R = (char)(result.R | (char)Byte.toUnsignedInt(b) << 8);
            } else {
                result.R = (char)(result.R | last_item.R & 0xFF00);
            }
            if ((sym & 0x40) != 0) {
                diff = (result.R & 0xFF) - (last_item.R & 0xFF);
                if ((sym & 4) != 0) {
                    corr = this.dec_RGB.decodeSymbol(this.contexts[this.current_context].m_rgb_diff_2);
                    b = MyDefs.U8_FOLD(corr + MyDefs.U8_CLAMP(diff + (last_item.G & 0xFF)));
                    result.G = (char)Byte.toUnsignedInt(b);
                } else {
                    result.G = (char)(last_item.G & 0xFF);
                }
                if ((sym & 0x10) != 0) {
                    corr = this.dec_RGB.decodeSymbol(this.contexts[this.current_context].m_rgb_diff_4);
                    diff = (diff + ((result.G & 0xFF) - (last_item.G & 0xFF))) / 2;
                    b = MyDefs.U8_FOLD(corr + MyDefs.U8_CLAMP(diff + (last_item.B & 0xFF)));
                    result.B = (char)Byte.toUnsignedInt(b);
                } else {
                    result.B = (char)(last_item.B & 0xFF);
                }
                diff = (result.R >>> 8) - (last_item.R >>> 8);
                if ((sym & 8) != 0) {
                    corr = this.dec_RGB.decodeSymbol(this.contexts[this.current_context].m_rgb_diff_3);
                    b = MyDefs.U8_FOLD(corr + MyDefs.U8_CLAMP(diff + (last_item.G >>> 8)));
                    result.G = (char)(result.G | (char)Byte.toUnsignedInt(b) << 8);
                } else {
                    result.G = (char)(result.G | last_item.G & 0xFF00);
                }
                if ((sym & 0x20) != 0) {
                    corr = this.dec_RGB.decodeSymbol(this.contexts[this.current_context].m_rgb_diff_5);
                    diff = (diff + ((result.G >>> 8) - (last_item.G >>> 8))) / 2;
                    b = MyDefs.U8_FOLD(corr + MyDefs.U8_CLAMP(diff + (last_item.B >>> 8)));
                    result.B = (char)(result.B | (char)Byte.toUnsignedInt(b) << 8);
                } else {
                    result.B = (char)(result.B | last_item.B & 0xFF00);
                }
            } else {
                result.G = result.R;
                result.B = result.R;
            }
            last_item.R = result.R;
            last_item.G = result.G;
            last_item.B = result.B;
        } else {
            result.R = last_item.R;
            result.G = last_item.G;
            result.B = last_item.B;
        }
        if (this.changed_NIR) {
            byte b;
            int sym = this.dec_NIR.decodeSymbol(this.contexts[this.current_context].m_nir_bytes_used);
            if ((sym & 1) != 0) {
                corr = this.dec_NIR.decodeSymbol(this.contexts[this.current_context].m_nir_diff_0);
                b = MyDefs.U8_FOLD(corr + (last_item.NIR & 0xFF));
                result.NIR = (char)Byte.toUnsignedInt(b);
            } else {
                result.NIR = (char)(last_item.NIR & 0xFF);
            }
            if ((sym & 2) != 0) {
                corr = this.dec_NIR.decodeSymbol(this.contexts[this.current_context].m_nir_diff_1);
                b = MyDefs.U8_FOLD(corr + (last_item.NIR >>> 8));
                result.NIR = (char)(result.NIR | (char)Byte.toUnsignedInt(b) << 8);
            } else {
                result.NIR = (char)(result.NIR | last_item.NIR & 0xFF00);
            }
            last_item.NIR = result.NIR;
        } else {
            result.NIR = last_item.NIR;
        }
        return result;
    }

    boolean createAndInitModelsAndDecompressors(int context, PointDataRecordRgbNIR seedItem) {
        assert (this.contexts[context].unused);
        if (this.requested_RGB) {
            if (this.contexts[context].m_rgb_bytes_used == null) {
                this.contexts[context].m_rgb_bytes_used = this.dec_RGB.createSymbolModel(128);
                this.contexts[context].m_rgb_diff_0 = this.dec_RGB.createSymbolModel(256);
                this.contexts[context].m_rgb_diff_1 = this.dec_RGB.createSymbolModel(256);
                this.contexts[context].m_rgb_diff_2 = this.dec_RGB.createSymbolModel(256);
                this.contexts[context].m_rgb_diff_3 = this.dec_RGB.createSymbolModel(256);
                this.contexts[context].m_rgb_diff_4 = this.dec_RGB.createSymbolModel(256);
                this.contexts[context].m_rgb_diff_5 = this.dec_RGB.createSymbolModel(256);
            }
            this.dec_RGB.initSymbolModel(this.contexts[context].m_rgb_bytes_used);
            this.dec_RGB.initSymbolModel(this.contexts[context].m_rgb_diff_0);
            this.dec_RGB.initSymbolModel(this.contexts[context].m_rgb_diff_1);
            this.dec_RGB.initSymbolModel(this.contexts[context].m_rgb_diff_2);
            this.dec_RGB.initSymbolModel(this.contexts[context].m_rgb_diff_3);
            this.dec_RGB.initSymbolModel(this.contexts[context].m_rgb_diff_4);
            this.dec_RGB.initSymbolModel(this.contexts[context].m_rgb_diff_5);
        }
        if (this.requested_NIR) {
            if (this.contexts[context].m_nir_bytes_used == null) {
                this.contexts[context].m_nir_bytes_used = this.dec_NIR.createSymbolModel(4);
                this.contexts[context].m_nir_diff_0 = this.dec_NIR.createSymbolModel(256);
                this.contexts[context].m_nir_diff_1 = this.dec_NIR.createSymbolModel(256);
            }
            this.dec_NIR.initSymbolModel(this.contexts[context].m_nir_bytes_used);
            this.dec_NIR.initSymbolModel(this.contexts[context].m_nir_diff_0);
            this.dec_NIR.initSymbolModel(this.contexts[context].m_nir_diff_1);
        }
        this.contexts[context].last_item = new PointDataRecordRgbNIR(seedItem);
        this.contexts[context].unused = false;
        return true;
    }
}

