/*
 * Decompiled with CFR 0.152.
 */
package com.github.mreutegg.laszip4j.laszip;

import com.github.mreutegg.laszip4j.laszip.ArithmeticDecoder;
import com.github.mreutegg.laszip4j.laszip.ArithmeticModel;
import com.github.mreutegg.laszip4j.laszip.LASreadItemCompressed;
import com.github.mreutegg.laszip4j.laszip.MutableInteger;
import com.github.mreutegg.laszip4j.laszip.MyDefs;
import com.github.mreutegg.laszip4j.laszip.PointDataRecord;
import com.github.mreutegg.laszip4j.laszip.PointDataRecordRGB;

public class LASreadItemCompressed_RGB12_v2
extends LASreadItemCompressed {
    private ArithmeticDecoder dec;
    private PointDataRecordRGB last_item = null;
    private ArithmeticModel m_byte_used;
    private ArithmeticModel m_rgb_diff_0;
    private ArithmeticModel m_rgb_diff_1;
    private ArithmeticModel m_rgb_diff_2;
    private ArithmeticModel m_rgb_diff_3;
    private ArithmeticModel m_rgb_diff_4;
    private ArithmeticModel m_rgb_diff_5;

    public LASreadItemCompressed_RGB12_v2(ArithmeticDecoder dec) {
        assert (dec != null);
        this.dec = dec;
        this.m_byte_used = dec.createSymbolModel(128);
        this.m_rgb_diff_0 = dec.createSymbolModel(256);
        this.m_rgb_diff_1 = dec.createSymbolModel(256);
        this.m_rgb_diff_2 = dec.createSymbolModel(256);
        this.m_rgb_diff_3 = dec.createSymbolModel(256);
        this.m_rgb_diff_4 = dec.createSymbolModel(256);
        this.m_rgb_diff_5 = dec.createSymbolModel(256);
    }

    @Override
    public void init(PointDataRecord seedItem, MutableInteger notUsed) {
        this.dec.initSymbolModel(this.m_byte_used);
        this.dec.initSymbolModel(this.m_rgb_diff_0);
        this.dec.initSymbolModel(this.m_rgb_diff_1);
        this.dec.initSymbolModel(this.m_rgb_diff_2);
        this.dec.initSymbolModel(this.m_rgb_diff_3);
        this.dec.initSymbolModel(this.m_rgb_diff_4);
        this.dec.initSymbolModel(this.m_rgb_diff_5);
        this.last_item = new PointDataRecordRGB((PointDataRecordRGB)seedItem);
    }

    @Override
    public PointDataRecord read(MutableInteger notUsed) {
        byte b;
        int corr;
        int diff = 0;
        int sym = this.dec.decodeSymbol(this.m_byte_used);
        PointDataRecordRGB result = new PointDataRecordRGB();
        if ((sym & 1) != 0) {
            corr = this.dec.decodeSymbol(this.m_rgb_diff_0);
            b = MyDefs.U8_FOLD(corr + (this.last_item.R & 0xFF));
            result.R = (char)Byte.toUnsignedInt(b);
        } else {
            result.R = (char)(this.last_item.R & 0xFF);
        }
        if ((sym & 2) != 0) {
            corr = this.dec.decodeSymbol(this.m_rgb_diff_1);
            b = MyDefs.U8_FOLD(corr + (this.last_item.R >>> 8));
            result.R = (char)(result.R | (char)Byte.toUnsignedInt(b) << 8);
        } else {
            result.R = (char)(result.R | this.last_item.R & 0xFF00);
        }
        if ((sym & 0x40) != 0) {
            diff = (result.R & 0xFF) - (this.last_item.R & 0xFF);
            if ((sym & 4) != 0) {
                corr = this.dec.decodeSymbol(this.m_rgb_diff_2);
                b = MyDefs.U8_FOLD(corr + MyDefs.U8_CLAMP(diff + (this.last_item.G & 0xFF)));
                result.G = (char)Byte.toUnsignedInt(b);
            } else {
                result.G = (char)(this.last_item.G & 0xFF);
            }
            if ((sym & 0x10) != 0) {
                corr = this.dec.decodeSymbol(this.m_rgb_diff_4);
                diff = (diff + ((result.G & 0xFF) - (this.last_item.G & 0xFF))) / 2;
                b = MyDefs.U8_FOLD(corr + MyDefs.U8_CLAMP(diff + (this.last_item.B & 0xFF)));
                result.B = (char)Byte.toUnsignedInt(b);
            } else {
                result.B = (char)(this.last_item.B & 0xFF);
            }
            diff = (result.R >>> 8) - (this.last_item.R >>> 8);
            if ((sym & 8) != 0) {
                corr = this.dec.decodeSymbol(this.m_rgb_diff_3);
                b = MyDefs.U8_FOLD(corr + MyDefs.U8_CLAMP(diff + (this.last_item.G >>> 8)));
                result.G = (char)(result.G | (char)Byte.toUnsignedInt(b) << 8);
            } else {
                result.G = (char)(result.G | this.last_item.G & 0xFF00);
            }
            if ((sym & 0x20) != 0) {
                corr = this.dec.decodeSymbol(this.m_rgb_diff_5);
                diff = (diff + ((result.G >>> 8) - (this.last_item.G >>> 8))) / 2;
                b = MyDefs.U8_FOLD(corr + MyDefs.U8_CLAMP(diff + (this.last_item.B >>> 8)));
                result.B = (char)(result.B | (char)Byte.toUnsignedInt(b) << 8);
            } else {
                result.B = (char)(result.B | this.last_item.B & 0xFF00);
            }
        } else {
            result.G = result.R;
            result.B = result.R;
        }
        this.last_item.R = result.R;
        this.last_item.G = result.G;
        this.last_item.B = result.B;
        return result;
    }

    @Override
    public boolean chunk_sizes() {
        return false;
    }
}

