/*
 * Decompiled with CFR 0.152.
 */
package com.github.mreutegg.laszip4j.laszip;

import com.github.mreutegg.laszip4j.laszip.ArithmeticDecoder;
import com.github.mreutegg.laszip4j.laszip.ArithmeticModel;
import com.github.mreutegg.laszip4j.laszip.ByteStreamIn;
import com.github.mreutegg.laszip4j.laszip.ByteStreamInArray;
import com.github.mreutegg.laszip4j.laszip.IByteStreamInProvider;
import com.github.mreutegg.laszip4j.laszip.LAScontextBYTE14;
import com.github.mreutegg.laszip4j.laszip.LASreadItemCompressed;
import com.github.mreutegg.laszip4j.laszip.MutableInteger;
import com.github.mreutegg.laszip4j.laszip.MyDefs;
import com.github.mreutegg.laszip4j.laszip.PointDataRecord;
import com.github.mreutegg.laszip4j.laszip.PointDataRecordBytes;

public class LASreadItemCompressed_BYTE14_v3
extends LASreadItemCompressed {
    private IByteStreamInProvider instreamProvider;
    private ByteStreamInArray[] instream_Bytes;
    private ArithmeticDecoder[] dec_Bytes;
    private int[] num_bytes_Bytes;
    private boolean[] changed_Bytes;
    private boolean[] requested_Bytes;
    private byte[] bytes;
    private int num_bytes_allocated;
    private int current_context;
    private LAScontextBYTE14[] contexts = new LAScontextBYTE14[4];
    private int number;

    public LASreadItemCompressed_BYTE14_v3(IByteStreamInProvider instreamProvider, int number, int decompress_selective) {
        assert (instreamProvider != null);
        this.instreamProvider = instreamProvider;
        assert (number != 0);
        this.number = number;
        this.instream_Bytes = null;
        this.dec_Bytes = null;
        this.num_bytes_Bytes = new int[number];
        this.changed_Bytes = new boolean[number];
        this.requested_Bytes = new boolean[number];
        for (int i = 0; i < number; ++i) {
            this.num_bytes_Bytes[i] = 0;
            this.changed_Bytes[i] = false;
            this.requested_Bytes[i] = i > 15 ? true : (decompress_selective & 65536 << i) != 0;
        }
        this.bytes = null;
        this.num_bytes_allocated = 0;
        for (int c = 0; c < this.contexts.length; ++c) {
            this.contexts[c] = new LAScontextBYTE14();
            this.contexts[c].m_bytes = null;
        }
        this.current_context = 0;
    }

    @Override
    public void init(PointDataRecord seedItem, MutableInteger context) {
        int i;
        ByteStreamIn instream = this.instreamProvider.getByteStreamIn();
        if (this.instream_Bytes == null) {
            this.instream_Bytes = new ByteStreamInArray[this.number];
            for (i = 0; i < this.number; ++i) {
                this.instream_Bytes[i] = new ByteStreamInArray();
            }
            this.dec_Bytes = new ArithmeticDecoder[this.number];
            for (i = 0; i < this.number; ++i) {
                this.dec_Bytes[i] = new ArithmeticDecoder();
            }
        }
        int num_bytes = 0;
        for (i = 0; i < this.number; ++i) {
            if (!this.requested_Bytes[i]) continue;
            num_bytes += this.num_bytes_Bytes[i];
        }
        if (num_bytes > this.num_bytes_allocated) {
            this.bytes = new byte[num_bytes];
            this.num_bytes_allocated = num_bytes;
        }
        num_bytes = 0;
        for (i = 0; i < this.number; ++i) {
            if (this.requested_Bytes[i]) {
                if (this.num_bytes_Bytes[i] != 0) {
                    instream.getBytes(this.bytes, this.num_bytes_Bytes[i]);
                    this.instream_Bytes[i].init(this.bytes, this.num_bytes_Bytes[i]);
                    this.dec_Bytes[i].init(this.instream_Bytes[i]);
                    num_bytes += this.num_bytes_Bytes[i];
                    this.changed_Bytes[i] = true;
                    continue;
                }
                this.dec_Bytes[i].init(null);
                this.changed_Bytes[i] = false;
                continue;
            }
            if (this.num_bytes_Bytes[i] != 0) {
                instream.skipBytes(this.num_bytes_Bytes[i]);
            }
            this.changed_Bytes[i] = false;
        }
        for (int c = 0; c < 4; ++c) {
            this.contexts[c].unused = true;
        }
        this.current_context = context.get();
        this.createAndInitModelsAndDecompressors(this.current_context, (PointDataRecordBytes)seedItem);
    }

    @Override
    public boolean chunk_sizes() {
        ByteStreamIn instream = this.instreamProvider.getByteStreamIn();
        for (int i = 0; i < this.number; ++i) {
            this.num_bytes_Bytes[i] = instream.get32bitsLE();
        }
        return true;
    }

    @Override
    public PointDataRecord read(MutableInteger context) {
        PointDataRecordBytes last_item = this.contexts[this.current_context].last_item;
        if (this.current_context != context.get()) {
            this.current_context = context.get();
            if (this.contexts[this.current_context].unused) {
                this.createAndInitModelsAndDecompressors(this.current_context, last_item);
                last_item = this.contexts[this.current_context].last_item;
            }
        }
        PointDataRecordBytes result = new PointDataRecordBytes(this.number);
        for (int i = 0; i < this.number; ++i) {
            if (this.changed_Bytes[i]) {
                int value = last_item.Bytes[i] + this.dec_Bytes[i].decodeSymbol(this.contexts[this.current_context].m_bytes[i]);
                result.Bytes[i] = last_item.Bytes[i] = MyDefs.U8_FOLD(value);
                continue;
            }
            result.Bytes[i] = last_item.Bytes[i];
        }
        return result;
    }

    private boolean createAndInitModelsAndDecompressors(int context, PointDataRecordBytes seedItem) {
        int i;
        assert (this.contexts[context].unused);
        if (this.contexts[context].m_bytes == null) {
            this.contexts[context].m_bytes = new ArithmeticModel[this.number];
            for (i = 0; i < this.number; ++i) {
                this.contexts[context].m_bytes[i] = this.dec_Bytes[i].createSymbolModel(256);
                this.dec_Bytes[i].initSymbolModel(this.contexts[context].m_bytes[i]);
            }
        }
        this.contexts[context].last_item = new PointDataRecordBytes(seedItem);
        for (i = 0; i < this.number; ++i) {
            this.dec_Bytes[i].initSymbolModel(this.contexts[context].m_bytes[i]);
        }
        this.contexts[context].unused = false;
        return true;
    }
}

