/*
 * Decompiled with CFR 0.152.
 */
package com.github.mreutegg.laszip4j.laszip;

import com.github.mreutegg.laszip4j.laszip.ArithmeticBitModel;
import com.github.mreutegg.laszip4j.laszip.ArithmeticModel;
import com.github.mreutegg.laszip4j.laszip.ByteStreamIn;
import com.github.mreutegg.laszip4j.laszip.IByteStreamInProvider;

public class ArithmeticDecoder
implements IByteStreamInProvider {
    private ByteStreamIn instream = null;
    private int u_value;
    private int u_length;

    public boolean init(ByteStreamIn instream) {
        if (instream == null) {
            return false;
        }
        this.instream = instream;
        this.u_length = -1;
        this.u_value = (instream.getByte() & 0xFF) << 24;
        this.u_value |= (instream.getByte() & 0xFF) << 16;
        this.u_value |= (instream.getByte() & 0xFF) << 8;
        this.u_value |= instream.getByte() & 0xFF;
        return true;
    }

    public void done() {
        this.instream = null;
    }

    ArithmeticBitModel createBitModel() {
        return new ArithmeticBitModel();
    }

    void initBitModel(ArithmeticBitModel m) {
        m.init();
    }

    public ArithmeticModel createSymbolModel(int n) {
        return new ArithmeticModel(n, false);
    }

    public void initSymbolModel(ArithmeticModel m) {
        this.initSymbolModel(m, null);
    }

    void initSymbolModel(ArithmeticModel m, int[] u_table) {
        m.init(u_table);
    }

    int decodeBit(ArithmeticBitModel m) {
        int u_sym;
        assert (m != null);
        int u_x = m.u_bit_0_prob * (this.u_length >>> 13);
        int n = u_sym = Integer.compareUnsigned(this.u_value, u_x) >= 0 ? 1 : 0;
        if (u_sym == 0) {
            this.u_length = u_x;
            ++m.u_bit_0_count;
        } else {
            this.u_value -= u_x;
            this.u_length -= u_x;
        }
        if (Integer.compareUnsigned(this.u_length, 0x1000000) < 0) {
            this.renorm_dec_interval();
        }
        if (--m.u_bits_until_update == 0) {
            m.update();
        }
        return u_sym;
    }

    public int decodeSymbol(ArithmeticModel m) {
        int u_x;
        int u_sym;
        int u_y = this.u_length;
        if (m.u_decoder_table != null) {
            int u_dv = Integer.divideUnsigned(this.u_value, this.u_length >>>= 15);
            int t = u_dv >>> m.u_table_shift;
            u_sym = m.u_decoder_table[t];
            int u_n = m.u_decoder_table[t + 1] + 1;
            while (Integer.compareUnsigned(u_n, u_sym + 1) > 0) {
                int u_k = u_sym + u_n >>> 1;
                if (Integer.compareUnsigned(m.u_distribution[u_k], u_dv) > 0) {
                    u_n = u_k;
                    continue;
                }
                u_sym = u_k;
            }
            u_x = m.u_distribution[u_sym] * this.u_length;
            if (u_sym != m.u_last_symbol) {
                u_y = m.u_distribution[u_sym + 1] * this.u_length;
            }
        } else {
            u_sym = 0;
            u_x = 0;
            this.u_length >>>= 15;
            int u_n = m.u_symbols;
            int u_k = u_n >>> 1;
            do {
                int u_z;
                if (Integer.compareUnsigned(u_z = this.u_length * m.u_distribution[u_k], this.u_value) > 0) {
                    u_n = u_k;
                    u_y = u_z;
                    continue;
                }
                u_sym = u_k;
                u_x = u_z;
            } while ((u_k = u_sym + u_n >>> 1) != u_sym);
        }
        this.u_value -= u_x;
        this.u_length = u_y - u_x;
        if (Integer.compareUnsigned(this.u_length, 0x1000000) < 0) {
            this.renorm_dec_interval();
        }
        int n = u_sym;
        m.u_symbol_count[n] = m.u_symbol_count[n] + 1;
        if (--m.u_symbols_until_update == 0) {
            m.update();
        }
        assert (Integer.compareUnsigned(u_sym, m.u_symbols) < 0);
        return u_sym;
    }

    int readBit() {
        int u_sym = Integer.divideUnsigned(this.u_value, this.u_length >>>= 1);
        this.u_value -= this.u_length * u_sym;
        if (Integer.compareUnsigned(this.u_length, 0x1000000) < 0) {
            this.renorm_dec_interval();
        }
        if (Integer.compareUnsigned(u_sym, 2) >= 0) {
            throw new RuntimeException("4711");
        }
        return u_sym;
    }

    int readBits(int u_bits) {
        assert (u_bits != 0 && u_bits <= 32);
        if (u_bits > 19) {
            char u_tmp = this.readShort();
            int u_tmp1 = this.readBits(u_bits -= 16) << 16;
            return u_tmp1 | u_tmp;
        }
        int u_sym = Integer.divideUnsigned(this.u_value, this.u_length >>>= u_bits);
        this.u_value -= this.u_length * u_sym;
        if (Integer.compareUnsigned(this.u_length, 0x1000000) < 0) {
            this.renorm_dec_interval();
        }
        if (Integer.compareUnsigned(u_sym, 1 << u_bits) >= 0) {
            throw new RuntimeException("4711");
        }
        return u_sym;
    }

    byte readByte() {
        int u_sym = Integer.divideUnsigned(this.u_value, this.u_length >>>= 8);
        this.u_value -= this.u_length * u_sym;
        if (Integer.compareUnsigned(this.u_length, 0x1000000) < 0) {
            this.renorm_dec_interval();
        }
        if (Integer.compareUnsigned(u_sym, 256) >= 0) {
            throw new RuntimeException("4711");
        }
        return (byte)u_sym;
    }

    char readShort() {
        int u_sym = Integer.divideUnsigned(this.u_value, this.u_length >>>= 16);
        this.u_value -= this.u_length * u_sym;
        if (Integer.compareUnsigned(this.u_length, 0x1000000) < 0) {
            this.renorm_dec_interval();
        }
        if (Integer.compareUnsigned(u_sym, 65536) >= 0) {
            throw new RuntimeException("4711");
        }
        return (char)u_sym;
    }

    public int readInt() {
        char u_lowerInt = this.readShort();
        char u_upperInt = this.readShort();
        return u_upperInt << 16 | u_lowerInt;
    }

    public float readFloat() {
        return Float.intBitsToFloat(this.readInt());
    }

    public long readInt64() {
        long u_lowerInt = this.readInt();
        long u_upperInt = this.readInt();
        return u_upperInt << 32 | u_lowerInt;
    }

    @Override
    public void setByteStreamIn(ByteStreamIn instream) {
        this.instream = instream;
    }

    @Override
    public ByteStreamIn getByteStreamIn() {
        return this.instream;
    }

    double readDouble() {
        return Double.longBitsToDouble(this.readInt64());
    }

    private void renorm_dec_interval() {
        do {
            this.u_value = this.u_value << 8 | this.instream.getByte() & 0xFF;
        } while (Integer.compareUnsigned(this.u_length <<= 8, 0x1000000) < 0);
    }
}

