/*
 * Decompiled with CFR 0.152.
 */
package com.github.mreutegg.laszip4j.laslib;

import com.github.mreutegg.laszip4j.clib.Cstdio;
import com.github.mreutegg.laszip4j.clib.Cstring;
import com.github.mreutegg.laszip4j.laslib.LASvlr_wave_packet_descr;
import com.github.mreutegg.laszip4j.laszip.ArithmeticDecoder;
import com.github.mreutegg.laszip4j.laszip.ByteStreamIn;
import com.github.mreutegg.laszip4j.laszip.ByteStreamInFile;
import com.github.mreutegg.laszip4j.laszip.IntegerCompressor;
import com.github.mreutegg.laszip4j.laszip.LASpoint;
import com.github.mreutegg.laszip4j.laszip.MyDefs;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class LASwaveform13reader {
    private static final PrintStream stderr = System.err;
    public int nbits = 0;
    public int nsamples = 0;
    public int temporal = 0;
    public float location = 0.0f;
    public float[] XYZt = new float[3];
    public double[] XYZreturn = new double[3];
    public double[] XYZsample = new double[3];
    public int s_count;
    public int sample;
    public int sampleMin;
    public int sampleMax;
    public byte[] samples;
    private boolean compressed;
    private int size;
    private LASvlr_wave_packet_descr[] wave_packet_descr;
    private RandomAccessFile file;
    private ByteStreamIn stream;
    private long start_of_waveform_data_packet_record;
    private long last_position;
    private ArithmeticDecoder dec;
    private IntegerCompressor ic8;
    private IntegerCompressor ic16;

    public LASwaveform13reader() {
        this.XYZt[2] = 0.0f;
        this.XYZt[1] = 0.0f;
        this.XYZt[0] = 0.0f;
        this.XYZreturn[2] = 0.0;
        this.XYZreturn[1] = 0.0;
        this.XYZreturn[0] = 0.0;
        this.s_count = 0;
        this.XYZsample[2] = 0.0;
        this.XYZsample[1] = 0.0;
        this.XYZsample[0] = 0.0;
        this.sample = 0;
        this.sampleMin = 0;
        this.sampleMax = 0;
        this.samples = null;
        this.size = 0;
        this.compressed = Boolean.FALSE;
        this.wave_packet_descr = null;
        this.file = null;
        this.stream = null;
        this.last_position = 0L;
        this.start_of_waveform_data_packet_record = 0L;
        this.dec = null;
        this.ic8 = null;
        this.ic16 = null;
    }

    public boolean is_compressed() {
        return this.compressed;
    }

    boolean open(String file_name, long start_of_waveform_data_packet_record, LASvlr_wave_packet_descr[] wave_packet_descr) {
        int i;
        if (file_name == null) {
            Cstdio.fprintf(stderr, "ERROR: file name pointer is zero\n", new Object[0]);
            return Boolean.FALSE;
        }
        if (wave_packet_descr == null) {
            Cstdio.fprintf(stderr, "ERROR: wave packet descriptor pointer is zero\n", new Object[0]);
            return Boolean.FALSE;
        }
        this.compressed = Boolean.FALSE;
        for (i = 0; i < 256; ++i) {
            if (wave_packet_descr[i] == null) continue;
            this.compressed = this.compressed || wave_packet_descr[i].getCompressionType() > 0;
        }
        if (start_of_waveform_data_packet_record == 0L) {
            if (!this.compressed && (LASwaveform13reader.strstr(".wdp", file_name) || LASwaveform13reader.strstr(".WDP", file_name))) {
                this.file = Cstdio.fopenRAF(file_name.toCharArray(), "rb");
            } else if (this.compressed && (LASwaveform13reader.strstr(".wdz", file_name) || LASwaveform13reader.strstr(".WDZ", file_name))) {
                this.file = Cstdio.fopenRAF(file_name.toCharArray(), "rb");
            } else {
                int len;
                char[] file_name_temp = file_name.toCharArray();
                if (file_name_temp[(len = Cstring.strlen(file_name_temp)) - 3] == 'L' || file_name_temp[len - 3] == 'W') {
                    file_name_temp[len - 3] = 87;
                    file_name_temp[len - 2] = 68;
                    file_name_temp[len - 1] = this.compressed ? 90 : 80;
                } else {
                    file_name_temp[len - 3] = 119;
                    file_name_temp[len - 2] = 100;
                    file_name_temp[len - 1] = this.compressed ? 122 : 112;
                }
                this.file = Cstdio.fopenRAF(file_name_temp, "rb");
            }
        } else {
            this.file = Cstdio.fopenRAF(file_name.toCharArray(), "rb");
        }
        if (this.file == null) {
            Cstdio.fprintf(stderr, "ERROR: cannot open waveform file '%s'\n", file_name);
            return Boolean.FALSE;
        }
        this.stream = new ByteStreamInFile(this.file);
        this.start_of_waveform_data_packet_record = start_of_waveform_data_packet_record;
        this.wave_packet_descr = wave_packet_descr;
        long position = start_of_waveform_data_packet_record + 60L;
        this.stream.seek(position);
        byte[] magic = new byte[25];
        try {
            this.stream.getBytes(magic, 24);
        }
        catch (Exception e) {
            Cstdio.fprintf(stderr, "ERROR: reading waveform descriptor cross-check\n", new Object[0]);
            return Boolean.FALSE;
        }
        if (Cstring.strncmp(MyDefs.stringFromByteArray(magic), "LAStools waveform ", 18) == 0) {
            int number;
            try {
                number = this.stream.get16bitsLE();
            }
            catch (Exception e) {
                Cstdio.fprintf(stderr, "ERROR: reading number of waveform descriptors\n", new Object[0]);
                return Boolean.FALSE;
            }
            for (i = 0; i < number; ++i) {
                char nsamples;
                char index;
                try {
                    index = this.stream.get16bitsLE();
                }
                catch (Exception e) {
                    Cstdio.fprintf(stderr, "ERROR: reading index of waveform descriptor %d\n", i);
                    return Boolean.FALSE;
                }
                if (index > '\u00ff') {
                    Cstdio.fprintf(stderr, "ERROR: cross-check - index %d of waveform descriptor %d out-of-range\n", index, i);
                    return Boolean.FALSE;
                }
                if (wave_packet_descr[index] == null) {
                    Cstdio.fprintf(stderr, "WARNING: cross-check - waveform descriptor %d with index %d unknown\n", i, index);
                    try {
                        int dummy = this.stream.get32bitsLE();
                        continue;
                    }
                    catch (Exception e) {
                        Cstdio.fprintf(stderr, "ERROR: cross-check - reading rest of waveform descriptor %d\n", i);
                        return Boolean.FALSE;
                    }
                }
                byte[] compression = new byte[1];
                try {
                    this.stream.getBytes(compression, 1);
                }
                catch (Exception e) {
                    Cstdio.fprintf(stderr, "ERROR: reading compression of waveform descriptor %d\n", i);
                    return Boolean.FALSE;
                }
                if (compression[0] != wave_packet_descr[index].getCompressionType()) {
                    Cstdio.fprintf(stderr, "ERROR: cross-check - compression %d %d of waveform descriptor %d with index %d is different\n", compression[0], wave_packet_descr[index].getCompressionType(), i, index);
                    return Boolean.FALSE;
                }
                byte[] nbits = new byte[1];
                try {
                    this.stream.getBytes(nbits, 1);
                }
                catch (Exception e) {
                    Cstdio.fprintf(stderr, "ERROR: reading nbits of waveform descriptor %d\n", i);
                    return Boolean.FALSE;
                }
                if (nbits[0] != wave_packet_descr[index].getBitsPerSample()) {
                    Cstdio.fprintf(stderr, "ERROR: cross-check - nbits %d %d of waveform descriptor %d with index %d is different\n", nbits[0], wave_packet_descr[index].getBitsPerSample(), i, index);
                    return Boolean.FALSE;
                }
                try {
                    nsamples = this.stream.get16bitsLE();
                }
                catch (Exception e) {
                    Cstdio.fprintf(stderr, "ERROR: reading nsamples of waveform descriptor %d\n", i);
                    return Boolean.FALSE;
                }
                if (nsamples == wave_packet_descr[index].getNumberOfSamples()) continue;
                Cstdio.fprintf(stderr, "ERROR: cross-check - nsamples %d %d of waveform descriptor %d with index %d is different\n", nsamples, wave_packet_descr[index].getNumberOfSamples(), i, index);
                return Boolean.FALSE;
            }
        }
        this.last_position = this.stream.tell();
        if (this.compressed) {
            if (this.dec == null) {
                this.dec = new ArithmeticDecoder();
            }
            if (this.ic8 == null) {
                this.ic8 = new IntegerCompressor(this.dec, 8);
            }
            if (this.ic16 == null) {
                this.ic16 = new IntegerCompressor(this.dec, 16);
            }
        }
        return Boolean.TRUE;
    }

    public boolean read_waveform(LASpoint point) {
        short index = point.getWavepacketDescriptorIndex();
        if (index == 0) {
            return Boolean.FALSE;
        }
        if (this.wave_packet_descr[index] == null) {
            Cstdio.fprintf(stderr, "ERROR: wavepacket is indexing non-existant descriptor %d\n", index);
            return Boolean.FALSE;
        }
        this.nbits = this.wave_packet_descr[index].getBitsPerSample();
        if (this.nbits != 8 && this.nbits != 16) {
            Cstdio.fprintf(stderr, "ERROR: waveform with %d bits per samples not supported yet\n", this.nbits);
            return Boolean.FALSE;
        }
        this.nsamples = this.wave_packet_descr[index].getNumberOfSamples();
        if (this.nsamples == 0) {
            Cstdio.fprintf(stderr, "ERROR: waveform has no samples\n", new Object[0]);
            return Boolean.FALSE;
        }
        this.temporal = this.wave_packet_descr[index].getTemporalSpacing();
        this.location = point.getWavepacketReturnPointWaveformLocation();
        this.XYZt[0] = point.getWavepacketParametricDx();
        this.XYZt[1] = point.getWavepacketParametricDy();
        this.XYZt[2] = point.getWavepacketParametricDz();
        this.XYZreturn[0] = point.get_x();
        this.XYZreturn[1] = point.get_y();
        this.XYZreturn[2] = point.get_z();
        if (this.size < this.nbits / 8 * this.nsamples) {
            this.samples = new byte[this.nbits / 8 * this.nsamples];
        }
        this.size = this.nbits / 8 * this.nsamples;
        long position = this.start_of_waveform_data_packet_record + point.getWavepacketOffsetToWaveformData();
        this.stream.seek(position);
        if (this.wave_packet_descr[index].getCompressionType() == 0) {
            try {
                this.stream.getBytes(this.samples, this.size);
            }
            catch (Exception e) {
                Cstdio.fprintf(stderr, "ERROR: cannot read %d bytes for waveform with %d samples of %d bits\n", this.size, this.nsamples, this.nbits);
                return Boolean.FALSE;
            }
        }
        if (this.nbits == 8) {
            this.stream.getBytes(this.samples, 1);
            this.dec.init(this.stream);
            this.ic8.initDecompressor();
            this.s_count = 1;
            while (this.s_count < this.nsamples) {
                this.samples[this.s_count] = (byte)this.ic8.decompress(this.samples[this.s_count - 1]);
                ++this.s_count;
            }
        } else {
            this.stream.getBytes(this.samples, 2);
            this.dec.init(this.stream);
            this.ic16.initDecompressor();
            ByteBuffer bb = ByteBuffer.wrap(this.samples).order(ByteOrder.LITTLE_ENDIAN);
            this.s_count = 1;
            while (this.s_count < this.nsamples) {
                bb.putChar(this.s_count * 2, (char)this.ic16.decompress(bb.getChar((this.s_count - 1) * 2)));
                ++this.s_count;
            }
        }
        this.dec.done();
        this.s_count = 0;
        return Boolean.TRUE;
    }

    boolean get_samples() {
        if (this.nbits == 8) {
            this.sampleMin = this.samples[0];
            this.sampleMax = this.samples[0];
            this.s_count = 1;
            while (this.s_count < this.nsamples) {
                if (this.samples[this.s_count] < this.sampleMin) {
                    this.sampleMin = this.samples[this.s_count];
                } else if (this.samples[this.s_count] > this.sampleMax) {
                    this.sampleMax = this.samples[this.s_count];
                }
                ++this.s_count;
            }
        } else {
            ByteBuffer bb = ByteBuffer.wrap(this.samples).order(ByteOrder.LITTLE_ENDIAN);
            this.sampleMin = bb.getChar(0);
            this.sampleMax = bb.getChar(0);
            this.s_count = 1;
            while (this.s_count < this.nsamples) {
                char s = bb.getChar(this.s_count * 2);
                this.sampleMin = Math.min(this.sampleMin, s);
                this.sampleMax = Math.max(this.sampleMax, s);
                ++this.s_count;
            }
        }
        this.s_count = 0;
        return this.s_count < this.nsamples;
    }

    boolean has_samples() {
        if (this.s_count < this.nsamples) {
            if (this.nbits == 8) {
                this.sample = this.samples[this.s_count];
            } else {
                ByteBuffer bb = ByteBuffer.wrap(this.samples).order(ByteOrder.LITTLE_ENDIAN);
                this.sample = bb.getChar(this.s_count * 2);
            }
            ++this.s_count;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    boolean get_samples_xyz() {
        if (this.nbits == 8) {
            this.sampleMin = this.samples[0];
            this.sampleMax = this.samples[0];
            this.s_count = 1;
            while (this.s_count < this.nsamples) {
                if (this.samples[this.s_count] < this.sampleMin) {
                    this.sampleMin = this.samples[this.s_count];
                } else if (this.samples[this.s_count] > this.sampleMax) {
                    this.sampleMax = this.samples[this.s_count];
                }
                ++this.s_count;
            }
        } else {
            ByteBuffer bb = ByteBuffer.wrap(this.samples).order(ByteOrder.LITTLE_ENDIAN);
            this.sampleMin = bb.getChar(0);
            this.sampleMax = bb.getChar(0);
            this.s_count = 1;
            while (this.s_count < this.nsamples) {
                char s = bb.getChar(this.s_count * 2);
                this.sampleMin = Math.min(this.sampleMin, s);
                this.sampleMax = Math.max(this.sampleMax, s);
                ++this.s_count;
            }
        }
        this.s_count = 0;
        return this.s_count < this.nsamples;
    }

    boolean has_samples_xyz() {
        if (this.s_count < this.nsamples) {
            float dist = this.location - (float)(this.s_count * this.temporal);
            this.XYZsample[0] = this.XYZreturn[0] + (double)(dist * this.XYZt[0]);
            this.XYZsample[1] = this.XYZreturn[1] + (double)(dist * this.XYZt[1]);
            this.XYZsample[2] = this.XYZreturn[2] + (double)(dist * this.XYZt[2]);
            if (this.nbits == 8) {
                this.sample = this.samples[this.s_count];
            } else {
                ByteBuffer bb = ByteBuffer.wrap(this.samples).order(ByteOrder.LITTLE_ENDIAN);
                this.sample = bb.getChar(this.s_count * 2);
            }
            ++this.s_count;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    void close() {
        if (this.stream != null) {
            Cstdio.fclose(this.stream);
            this.stream = null;
        }
        if (this.file != null) {
            Cstdio.fclose(this.file);
            this.file = null;
        }
    }

    private static boolean strstr(String s1, String s2) {
        return s1.contains(s2);
    }
}

