/*
 * Decompiled with CFR 0.152.
 */
package com.github.mreutegg.laszip4j.laslib;

import com.github.mreutegg.laszip4j.clib.Cstdio;
import com.github.mreutegg.laszip4j.laslib.LAScriterion;
import com.github.mreutegg.laszip4j.laszip.LASpoint;

class LAScriterionKeepGpsTime
extends LAScriterion {
    double below_gpstime;
    double above_gpstime;

    @Override
    public String name() {
        return "keep_gps_time";
    }

    @Override
    public int get_command(StringBuilder string) {
        return Cstdio.sprintf(string, "-%s %.6f %.6f ", this.name(), this.below_gpstime, this.above_gpstime);
    }

    @Override
    public int get_decompress_selective() {
        return 128;
    }

    @Override
    public boolean filter(LASpoint point) {
        return point.haveGpsTime() && (point.getGps_time() < this.below_gpstime || point.getGps_time() > this.above_gpstime);
    }

    LAScriterionKeepGpsTime(double below_gpstime, double above_gpstime) {
        this.below_gpstime = below_gpstime;
        this.above_gpstime = above_gpstime;
    }
}

