/*
 * Decompiled with CFR 0.152.
 */
package com.github.mreutegg.laszip4j.laszip;

import com.github.mreutegg.laszip4j.laszip.ArithmeticDecoder;
import com.github.mreutegg.laszip4j.laszip.ArithmeticModel;
import com.github.mreutegg.laszip4j.laszip.IntegerCompressor;
import com.github.mreutegg.laszip4j.laszip.LASreadItemCompressed;
import com.github.mreutegg.laszip4j.laszip.PointDataRecord;
import com.github.mreutegg.laszip4j.laszip.PointDataRecordGpsTime;

public class LASreadItemCompressed_GPSTIME11_v1
extends LASreadItemCompressed {
    private static final int LASZIP_GPSTIME_MULTIMAX = 512;
    private ArithmeticDecoder dec;
    private PointDataRecordGpsTime last_item = new PointDataRecordGpsTime();
    private ArithmeticModel m_gpstime_multi;
    private ArithmeticModel m_gpstime_0diff;
    private IntegerCompressor ic_gpstime;
    private int multi_extreme_counter;
    private int last_gpstime_diff;

    public LASreadItemCompressed_GPSTIME11_v1(ArithmeticDecoder dec) {
        assert (dec != null);
        this.dec = dec;
        this.m_gpstime_multi = dec.createSymbolModel(512);
        this.m_gpstime_0diff = dec.createSymbolModel(3);
        this.ic_gpstime = new IntegerCompressor(dec, 32, 6);
    }

    @Override
    public void init(PointDataRecord seedItem, int notUsed) {
        this.last_gpstime_diff = 0;
        this.multi_extreme_counter = 0;
        this.dec.initSymbolModel(this.m_gpstime_multi);
        this.dec.initSymbolModel(this.m_gpstime_0diff);
        this.ic_gpstime.initDecompressor();
        this.last_item.GPSTime = ((PointDataRecordGpsTime)seedItem).GPSTime;
    }

    @Override
    public PointDataRecordGpsTime read(int notUsed) {
        if (this.last_gpstime_diff == 0) {
            int multi = this.dec.decodeSymbol(this.m_gpstime_0diff);
            if (multi == 1) {
                this.last_gpstime_diff = this.ic_gpstime.decompress(0, 0);
                this.last_item.GPSTime += (long)this.last_gpstime_diff;
            } else if (multi == 2) {
                this.last_item.GPSTime = this.dec.readInt64();
            }
        } else {
            int multi = this.dec.decodeSymbol(this.m_gpstime_multi);
            if (multi < 510) {
                int gpstime_diff;
                if (multi == 1) {
                    this.last_gpstime_diff = gpstime_diff = this.ic_gpstime.decompress(this.last_gpstime_diff, 1);
                    this.multi_extreme_counter = 0;
                } else if (multi == 0) {
                    gpstime_diff = this.ic_gpstime.decompress(this.last_gpstime_diff / 4, 2);
                    ++this.multi_extreme_counter;
                    if (this.multi_extreme_counter > 3) {
                        this.last_gpstime_diff = gpstime_diff;
                        this.multi_extreme_counter = 0;
                    }
                } else if (multi < 10) {
                    gpstime_diff = this.ic_gpstime.decompress(multi * this.last_gpstime_diff, 3);
                } else if (multi < 50) {
                    gpstime_diff = this.ic_gpstime.decompress(multi * this.last_gpstime_diff, 4);
                } else {
                    gpstime_diff = this.ic_gpstime.decompress(multi * this.last_gpstime_diff, 5);
                    if (multi == 509) {
                        ++this.multi_extreme_counter;
                        if (this.multi_extreme_counter > 3) {
                            this.last_gpstime_diff = gpstime_diff;
                            this.multi_extreme_counter = 0;
                        }
                    }
                }
                this.last_item.GPSTime += (long)gpstime_diff;
            } else if (multi < 511) {
                this.last_item.GPSTime = this.dec.readInt64();
            }
        }
        PointDataRecordGpsTime result = new PointDataRecordGpsTime();
        result.GPSTime = this.last_item.GPSTime;
        return result;
    }

    @Override
    public boolean chunk_sizes() {
        return false;
    }
}

