/*
 * Decompiled with CFR 0.152.
 */
package com.github.mreutegg.laszip4j.laszip;

import com.github.mreutegg.laszip4j.clib.Cstdio;
import com.github.mreutegg.laszip4j.clib.Cstring;
import com.github.mreutegg.laszip4j.laszip.ByteStreamIn;
import com.github.mreutegg.laszip4j.laszip.ByteStreamOut;
import com.github.mreutegg.laszip4j.laszip.MyDefs;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;

public class LASquadtree {
    public static final int LAS_SPATIAL_QUAD_TREE = 0;
    private static final PrintStream stderr = System.err;
    public int levels = 0;
    public float cell_size = 0.0f;
    public float min_x = 0.0f;
    public float max_x = 0.0f;
    public float min_y = 0.0f;
    public float max_y = 0.0f;
    public int cells_x = 0;
    public int cells_y = 0;
    public int current_cell;
    private int sub_level = 0;
    private int sub_level_index = 0;
    private int[] level_offset = new int[24];
    private int[] coarser_indices = new int[4];
    private int adaptive_alloc;
    private int[] adaptive;
    private List<Integer> current_cells;
    private int next_cell_index;

    void get_cell_bounding_box(double x, double y, int level, float[] min, float[] max) {
        float cell_min_x = this.min_x;
        float cell_max_x = this.max_x;
        float cell_min_y = this.min_y;
        float cell_max_y = this.max_y;
        while (level != 0) {
            float cell_mid_x = (cell_min_x + cell_max_x) / 2.0f;
            float cell_mid_y = (cell_min_y + cell_max_y) / 2.0f;
            if (x < (double)cell_mid_x) {
                cell_max_x = cell_mid_x;
            } else {
                cell_min_x = cell_mid_x;
            }
            if (y < (double)cell_mid_y) {
                cell_max_y = cell_mid_y;
            } else {
                cell_min_y = cell_mid_y;
            }
            --level;
        }
        if (min != null) {
            min[0] = cell_min_x;
            min[1] = cell_min_y;
        }
        if (max != null) {
            max[0] = cell_max_x;
            max[1] = cell_max_y;
        }
    }

    void get_cell_bounding_box(double x, double y, float[] min, float[] max) {
        this.get_cell_bounding_box(x, y, this.levels, min, max);
    }

    void get_cell_bounding_box(int level_index, int level, float[] min, float[] max) {
        float cell_min_x = this.min_x;
        float cell_max_x = this.max_x;
        float cell_min_y = this.min_y;
        float cell_max_y = this.max_y;
        while (level != 0) {
            int index = level_index >>> 2 * (level - 1) & 3;
            float cell_mid_x = (cell_min_x + cell_max_x) / 2.0f;
            float cell_mid_y = (cell_min_y + cell_max_y) / 2.0f;
            if ((index & 1) != 0) {
                cell_min_x = cell_mid_x;
            } else {
                cell_max_x = cell_mid_x;
            }
            if ((index & 2) != 0) {
                cell_min_y = cell_mid_y;
            } else {
                cell_max_y = cell_mid_y;
            }
            --level;
        }
        if (min != null) {
            min[0] = cell_min_x;
            min[1] = cell_min_y;
        }
        if (max != null) {
            max[0] = cell_max_x;
            max[1] = cell_max_y;
        }
    }

    void get_cell_bounding_box(int level_index, int level, double[] min, double[] max) {
        double cell_min_x = this.min_x;
        double cell_max_x = this.max_x;
        double cell_min_y = this.min_y;
        double cell_max_y = this.max_y;
        while (level != 0) {
            int index = level_index >>> 2 * (level - 1) & 3;
            double cell_mid_x = (cell_min_x + cell_max_x) / 2.0;
            double cell_mid_y = (cell_min_y + cell_max_y) / 2.0;
            if ((index & 1) != 0) {
                cell_min_x = cell_mid_x;
            } else {
                cell_max_x = cell_mid_x;
            }
            if ((index & 2) != 0) {
                cell_min_y = cell_mid_y;
            } else {
                cell_max_y = cell_mid_y;
            }
            --level;
        }
        if (min != null) {
            min[0] = cell_min_x;
            min[1] = cell_min_y;
        }
        if (max != null) {
            max[0] = cell_max_x;
            max[1] = cell_max_y;
        }
    }

    void get_cell_bounding_boxU(int level_index, float[] min, float[] max) {
        this.get_cell_bounding_box(level_index, this.levels, min, max);
    }

    void get_cell_bounding_box(int level_index, double[] min, double[] max) {
        this.get_cell_bounding_box(level_index, this.levels, min, max);
    }

    void get_cell_bounding_boxI(int cell_index, float[] min, float[] max) {
        int level = this.get_level(cell_index);
        int level_index = this.get_level_index(cell_index, level);
        this.get_cell_bounding_box(level_index, level, min, max);
    }

    int get_level_index(double x, double y, int level) {
        float cell_min_x = this.min_x;
        float cell_max_x = this.max_x;
        float cell_min_y = this.min_y;
        float cell_max_y = this.max_y;
        int level_index = 0;
        while (level != 0) {
            level_index <<= 2;
            float cell_mid_x = (cell_min_x + cell_max_x) / 2.0f;
            float cell_mid_y = (cell_min_y + cell_max_y) / 2.0f;
            if (x < (double)cell_mid_x) {
                cell_max_x = cell_mid_x;
            } else {
                cell_min_x = cell_mid_x;
                level_index |= 1;
            }
            if (y < (double)cell_mid_y) {
                cell_max_y = cell_mid_y;
            } else {
                cell_min_y = cell_mid_y;
                level_index |= 2;
            }
            --level;
        }
        return level_index;
    }

    int get_level_index(double x, double y) {
        return this.get_level_index(x, y, this.levels);
    }

    int get_level_index(double x, double y, int level, float[] min, float[] max) {
        float cell_min_x = this.min_x;
        float cell_max_x = this.max_x;
        float cell_min_y = this.min_y;
        float cell_max_y = this.max_y;
        int level_index = 0;
        while (level != 0) {
            level_index <<= 2;
            float cell_mid_x = (cell_min_x + cell_max_x) / 2.0f;
            float cell_mid_y = (cell_min_y + cell_max_y) / 2.0f;
            if (x < (double)cell_mid_x) {
                cell_max_x = cell_mid_x;
            } else {
                cell_min_x = cell_mid_x;
                level_index |= 1;
            }
            if (y < (double)cell_mid_y) {
                cell_max_y = cell_mid_y;
            } else {
                cell_min_y = cell_mid_y;
                level_index |= 2;
            }
            --level;
        }
        if (min != null) {
            min[0] = cell_min_x;
            min[1] = cell_min_y;
        }
        if (max != null) {
            max[0] = cell_max_x;
            max[1] = cell_max_y;
        }
        return level_index;
    }

    int get_level_index(double x, double y, float[] min, float[] max) {
        return this.get_level_index(x, y, this.levels, min, max);
    }

    int get_cell_index(double x, double y, int level) {
        if (this.sub_level != 0) {
            return this.level_offset[this.sub_level + level] + (this.sub_level_index << level * 2) + this.get_level_index(x, y, level);
        }
        return this.level_offset[level] + this.get_level_index(x, y, level);
    }

    int get_cell_index(double x, double y) {
        return this.get_cell_index(x, y, this.levels);
    }

    boolean coarsen(int cell_index, int[] coarser_cell_index, int[] num_cell_indices, int[][] cell_indices) {
        if (cell_index < 0) {
            return Boolean.FALSE;
        }
        int level = this.get_level(cell_index);
        if (level == 0) {
            return Boolean.FALSE;
        }
        int level_index = this.get_level_index(cell_index, level);
        level_index >>>= 2;
        if (coarser_cell_index != null) {
            coarser_cell_index[0] = this.get_cell_index(level_index, level - 1);
        }
        if (num_cell_indices != null && cell_indices != null) {
            num_cell_indices[0] = 4;
            cell_indices[0] = this.coarser_indices;
            cell_indices[0][0] = this.get_cell_index((level_index <<= 2) + 0, level);
            cell_indices[0][1] = this.get_cell_index(level_index + 1, level);
            cell_indices[0][2] = this.get_cell_index(level_index + 2, level);
            cell_indices[0][3] = this.get_cell_index(level_index + 3, level);
        }
        return Boolean.TRUE;
    }

    int get_level_index(int cell_index, int level) {
        if (this.sub_level != 0) {
            return cell_index - (this.sub_level_index << level * 2) - this.level_offset[this.sub_level + level];
        }
        return cell_index - this.level_offset[level];
    }

    int get_level_index(int cell_index) {
        return this.get_level_index(cell_index, this.levels);
    }

    int get_level(int cell_index) {
        int level = 0;
        while (Integer.compareUnsigned(cell_index, this.level_offset[level + 1]) >= 0) {
            ++level;
        }
        return level;
    }

    int get_cell_index(int level_index, int level) {
        if (this.sub_level != 0) {
            return level_index + (this.sub_level_index << level * 2) + this.level_offset[this.sub_level + level];
        }
        return level_index + this.level_offset[level];
    }

    int get_cell_index(int level_index) {
        return this.get_cell_index(level_index, this.levels);
    }

    int get_max_level_index(int level) {
        return (1 << level) * (1 << level);
    }

    int get_max_level_index() {
        return this.get_max_level_index(this.levels);
    }

    int get_max_cell_index(int level) {
        return this.level_offset[level + 1] - 1;
    }

    int get_max_cell_index() {
        return this.get_max_cell_index(this.levels);
    }

    void raster_occupancy(Function<Integer, Boolean> does_cell_exist, int[] data, int min_x, int min_y, int level_index, int level, int stop_level) {
        block6: {
            int cell_index;
            block5: {
                int adaptive_bit;
                cell_index = this.get_cell_index(level_index, level);
                int adaptive_pos = cell_index / 32;
                if ((this.adaptive[adaptive_pos] & (adaptive_bit = 1 << cell_index % 32)) == 0) break block5;
                if (level < stop_level) {
                    int size = 1 << stop_level - ++level;
                    this.raster_occupancy(does_cell_exist, data, min_x, min_y, level_index <<= 2, level, stop_level);
                    this.raster_occupancy(does_cell_exist, data, min_x + size, min_y, level_index + 1, level, stop_level);
                    this.raster_occupancy(does_cell_exist, data, min_x, min_y + size, level_index + 2, level, stop_level);
                    this.raster_occupancy(does_cell_exist, data, min_x + size, min_y + size, level_index + 3, level, stop_level);
                    return;
                }
                int full_size = 1 << stop_level;
                int size = 1 << stop_level - level;
                int max_y = min_y + size;
                for (int pos_y = min_y; pos_y < max_y; ++pos_y) {
                    int pos = pos_y * full_size + min_x;
                    for (int pos_x = 0; pos_x < size; ++pos_x) {
                        int n = pos / 32;
                        data[n] = data[n] | 1 << pos % 32;
                        ++pos;
                    }
                }
                break block6;
            }
            if (!does_cell_exist.apply(cell_index).booleanValue()) break block6;
            int full_size = 1 << stop_level;
            int size = 1 << stop_level - level;
            int max_y = min_y + size;
            for (int pos_y = min_y; pos_y < max_y; ++pos_y) {
                int pos = pos_y * full_size + min_x;
                for (int pos_x = 0; pos_x < size; ++pos_x) {
                    int n = pos / 32;
                    data[n] = data[n] | 1 << pos % 32;
                    ++pos;
                }
            }
        }
    }

    int[] raster_occupancy(Function<Integer, Boolean> does_cell_exist, int level) {
        int size_xy = 1 << level;
        int temp_size = size_xy * size_xy / 32 + (size_xy * size_xy % 32 != 0 ? 1 : 0);
        int[] data = new int[temp_size];
        this.raster_occupancy(does_cell_exist, data, 0, 0, 0, 0, level);
        return data;
    }

    int[] raster_occupancy(Function<Integer, Boolean> does_cell_exist) {
        return this.raster_occupancy(does_cell_exist, this.levels);
    }

    boolean read(ByteStreamIn stream) {
        int type;
        byte[] signature = new byte[4];
        try {
            stream.getBytes(signature, 4);
        }
        catch (Exception e) {
            Cstdio.fprintf(stderr, "ERROR (LASquadtree): reading LASspatial signature\n", new Object[0]);
            return Boolean.FALSE;
        }
        if (Cstring.strncmp(MyDefs.stringFromByteArray(signature), "LASS", 4) != 0) {
            Cstdio.fprintf(stderr, "ERROR (LASquadtree): wrong LASspatial signature %4s instead of 'LASS'\n", MyDefs.stringFromByteArray(signature));
            return Boolean.FALSE;
        }
        try {
            type = stream.get32bitsLE();
        }
        catch (Exception e) {
            Cstdio.fprintf(stderr, "ERROR (LASquadtree): reading LASspatial type\n", new Object[0]);
            return Boolean.FALSE;
        }
        if (type != 0) {
            Cstdio.fprintf(stderr, "ERROR (LASquadtree): unknown LASspatial type %d\n", type);
            return Boolean.FALSE;
        }
        try {
            stream.getBytes(signature, 4);
        }
        catch (Exception e) {
            Cstdio.fprintf(stderr, "ERROR (LASquadtree): reading signature\n", new Object[0]);
            return Boolean.FALSE;
        }
        if (Cstring.strncmp(MyDefs.stringFromByteArray(signature), "LASQ", 4) != 0) {
            this.levels = ByteBuffer.wrap(signature).order(ByteOrder.LITTLE_ENDIAN).getInt();
        } else {
            try {
                int version = stream.get32bitsLE();
            }
            catch (Exception e) {
                Cstdio.fprintf(stderr, "ERROR (LASquadtree): reading version\n", new Object[0]);
                return Boolean.FALSE;
            }
            try {
                this.levels = stream.get32bitsLE();
            }
            catch (Exception e) {
                Cstdio.fprintf(stderr, "ERROR (LASquadtree): reading levels\n", new Object[0]);
                return Boolean.FALSE;
            }
        }
        try {
            int level_index = stream.get32bitsLE();
        }
        catch (Exception e) {
            Cstdio.fprintf(stderr, "ERROR (LASquadtree): reading level_index\n", new Object[0]);
            return Boolean.FALSE;
        }
        try {
            int implicit_levels = stream.get32bitsLE();
        }
        catch (Exception e) {
            Cstdio.fprintf(stderr, "ERROR (LASquadtree): reading implicit_levels\n", new Object[0]);
            return Boolean.FALSE;
        }
        try {
            this.min_x = Float.intBitsToFloat(stream.get32bitsLE());
        }
        catch (Exception e) {
            Cstdio.fprintf(stderr, "ERROR (LASquadtree): reading min_x\n", new Object[0]);
            return Boolean.FALSE;
        }
        try {
            this.max_x = Float.intBitsToFloat(stream.get32bitsLE());
        }
        catch (Exception e) {
            Cstdio.fprintf(stderr, "ERROR (LASquadtree): reading max_x\n", new Object[0]);
            return Boolean.FALSE;
        }
        try {
            this.min_y = Float.intBitsToFloat(stream.get32bitsLE());
        }
        catch (Exception e) {
            Cstdio.fprintf(stderr, "ERROR (LASquadtree): reading min_y\n", new Object[0]);
            return Boolean.FALSE;
        }
        try {
            this.max_y = Float.intBitsToFloat(stream.get32bitsLE());
        }
        catch (Exception e) {
            Cstdio.fprintf(stderr, "ERROR (LASquadtree): reading max_y\n", new Object[0]);
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    boolean write(ByteStreamOut stream) {
        if (!stream.putBytes(MyDefs.asByteArray("LASS"), 4)) {
            Cstdio.fprintf(stderr, "ERROR (LASquadtree): writing LASspatial signature\n", new Object[0]);
            return Boolean.FALSE;
        }
        int type = 0;
        if (!stream.put32bitsLE(type)) {
            Cstdio.fprintf(stderr, "ERROR (LASquadtree): writing LASspatial type %d\n", type);
            return Boolean.FALSE;
        }
        if (!stream.putBytes(MyDefs.asByteArray("LASQ"), 4)) {
            Cstdio.fprintf(stderr, "ERROR (LASquadtree): writing signature\n", new Object[0]);
            return Boolean.FALSE;
        }
        int version = 0;
        if (!stream.put32bitsLE(version)) {
            Cstdio.fprintf(stderr, "ERROR (LASquadtree): writing version\n", new Object[0]);
            return Boolean.FALSE;
        }
        if (!stream.put32bitsLE(this.levels)) {
            Cstdio.fprintf(stderr, "ERROR (LASquadtree): writing levels %d\n", this.levels);
            return Boolean.FALSE;
        }
        int level_index = 0;
        if (!stream.put32bitsLE(level_index)) {
            Cstdio.fprintf(stderr, "ERROR (LASquadtree): writing level_index %d\n", level_index);
            return Boolean.FALSE;
        }
        int implicit_levels = 0;
        if (!stream.put32bitsLE(implicit_levels)) {
            Cstdio.fprintf(stderr, "ERROR (LASquadtree): writing implicit_levels %d\n", implicit_levels);
            return Boolean.FALSE;
        }
        if (!stream.put32bitsLE(Float.floatToIntBits(this.min_x))) {
            Cstdio.fprintf(stderr, "ERROR (LASquadtree): writing min_x %g\n", Float.valueOf(this.min_x));
            return Boolean.FALSE;
        }
        if (!stream.put32bitsLE(Float.floatToIntBits(this.max_x))) {
            Cstdio.fprintf(stderr, "ERROR (LASquadtree): writing max_x %g\n", Float.valueOf(this.max_x));
            return Boolean.FALSE;
        }
        if (!stream.put32bitsLE(Float.floatToIntBits(this.min_y))) {
            Cstdio.fprintf(stderr, "ERROR (LASquadtree): writing min_y %g\n", Float.valueOf(this.min_y));
            return Boolean.FALSE;
        }
        if (!stream.put32bitsLE(Float.floatToIntBits(this.max_y))) {
            Cstdio.fprintf(stderr, "ERROR (LASquadtree): writing max_y %g\n", Float.valueOf(this.max_y));
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    boolean manage_cell(int cell_index) {
        return this.manage_cell(cell_index, false);
    }

    boolean manage_cell(int cell_index, boolean finalize) {
        int index;
        int adaptive_pos = cell_index / 32;
        int adaptive_bit = 1 << cell_index % 32;
        if (adaptive_pos >= this.adaptive_alloc) {
            int i;
            if (this.adaptive != null) {
                this.adaptive = MyDefs.realloc(this.adaptive, adaptive_pos * 2);
                for (i = this.adaptive_alloc; i < adaptive_pos * 2; ++i) {
                    this.adaptive[i] = 0;
                }
                this.adaptive_alloc = adaptive_pos * 2;
            } else {
                this.adaptive = new int[adaptive_pos + 1];
                for (i = this.adaptive_alloc; i <= adaptive_pos; ++i) {
                    this.adaptive[i] = 0;
                }
                this.adaptive_alloc = adaptive_pos + 1;
            }
        }
        int n = adaptive_pos;
        this.adaptive[n] = this.adaptive[n] & ~adaptive_bit;
        int level = this.get_level(cell_index);
        int level_index = this.get_level_index(cell_index, level);
        while (level != 0 && (this.adaptive[adaptive_pos = (index = this.get_cell_index(level_index >>= 2, --level)) / 32] & (adaptive_bit = 1 << index % 32)) == 0) {
            int n2 = adaptive_pos;
            this.adaptive[n2] = this.adaptive[n2] | adaptive_bit;
        }
        return Boolean.TRUE;
    }

    boolean inside(double x, double y) {
        return (double)this.min_x <= x && x < (double)this.max_x && (double)this.min_y <= y && y < (double)this.max_y;
    }

    int intersect_rectangle(double r_min_x, double r_min_y, double r_max_x, double r_max_y, int level) {
        if (this.current_cells == null) {
            this.current_cells = new ArrayList<Integer>();
        } else {
            this.current_cells.clear();
        }
        if (r_max_x <= (double)this.min_x || !(r_min_x <= (double)this.max_x) || r_max_y <= (double)this.min_y || !(r_min_y <= (double)this.max_y)) {
            return 0;
        }
        if (this.adaptive != null) {
            this.intersect_rectangle_with_cells_adaptive(r_min_x, r_min_y, r_max_x, r_max_y, this.min_x, this.max_x, this.min_y, this.max_y, 0, 0);
        } else {
            this.intersect_rectangle_with_cells(r_min_x, r_min_y, r_max_x, r_max_y, this.min_x, this.max_x, this.min_y, this.max_y, level, 0);
        }
        return this.current_cells.size();
    }

    int intersect_rectangle(double r_min_x, double r_min_y, double r_max_x, double r_max_y) {
        return this.intersect_rectangle(r_min_x, r_min_y, r_max_x, r_max_y, this.levels);
    }

    int intersect_tile(float ll_x, float ll_y, float size, int level) {
        if (this.current_cells == null) {
            this.current_cells = new ArrayList<Integer>();
        } else {
            this.current_cells.clear();
        }
        float ur_x = ll_x + size;
        float ur_y = ll_y + size;
        if (ur_x <= this.min_x || !(ll_x <= this.max_x) || ur_y <= this.min_y || !(ll_y <= this.max_y)) {
            return 0;
        }
        if (this.adaptive != null) {
            this.intersect_tile_with_cells_adaptive(ll_x, ll_y, ur_x, ur_y, this.min_x, this.max_x, this.min_y, this.max_y, 0, 0);
        } else {
            this.intersect_tile_with_cells(ll_x, ll_y, ur_x, ur_y, this.min_x, this.max_x, this.min_y, this.max_y, level, 0);
        }
        return this.current_cells.size();
    }

    int intersect_tile(float ll_x, float ll_y, float size) {
        return this.intersect_tile(ll_x, ll_y, size, this.levels);
    }

    int intersect_circle(double center_x, double center_y, double radius, int level) {
        if (this.current_cells == null) {
            this.current_cells = new ArrayList<Integer>();
        } else {
            this.current_cells.clear();
        }
        double r_min_x = center_x - radius;
        double r_min_y = center_y - radius;
        double r_max_x = center_x + radius;
        double r_max_y = center_y + radius;
        if (r_max_x <= (double)this.min_x || !(r_min_x <= (double)this.max_x) || r_max_y <= (double)this.min_y || !(r_min_y <= (double)this.max_y)) {
            return 0;
        }
        if (this.adaptive != null) {
            this.intersect_circle_with_cells_adaptive(center_x, center_y, radius, r_min_x, r_min_y, r_max_x, r_max_y, this.min_x, this.max_x, this.min_y, this.max_y, 0, 0);
        } else {
            this.intersect_circle_with_cells(center_x, center_y, radius, r_min_x, r_min_y, r_max_x, r_max_y, this.min_x, this.max_x, this.min_y, this.max_y, level, 0);
        }
        return this.current_cells.size();
    }

    int intersect_circle(double center_x, double center_y, double radius) {
        return this.intersect_circle(center_x, center_y, radius, this.levels);
    }

    void intersect_rectangle_with_cells(double r_min_x, double r_min_y, double r_max_x, double r_max_y, float cell_min_x, float cell_max_x, float cell_min_y, float cell_max_y, int level, int level_index) {
        if (level != 0) {
            --level;
            level_index <<= 2;
            float cell_mid_x = (cell_min_x + cell_max_x) / 2.0f;
            float cell_mid_y = (cell_min_y + cell_max_y) / 2.0f;
            if (r_max_x <= (double)cell_mid_x) {
                if (r_max_y <= (double)cell_mid_y) {
                    this.intersect_rectangle_with_cells(r_min_x, r_min_y, r_max_x, r_max_y, cell_min_x, cell_mid_x, cell_min_y, cell_mid_y, level, level_index);
                } else if (!(r_min_y < (double)cell_mid_y)) {
                    this.intersect_rectangle_with_cells(r_min_x, r_min_y, r_max_x, r_max_y, cell_min_x, cell_mid_x, cell_mid_y, cell_max_y, level, level_index | 2);
                } else {
                    this.intersect_rectangle_with_cells(r_min_x, r_min_y, r_max_x, r_max_y, cell_min_x, cell_mid_x, cell_min_y, cell_mid_y, level, level_index);
                    this.intersect_rectangle_with_cells(r_min_x, r_min_y, r_max_x, r_max_y, cell_min_x, cell_mid_x, cell_mid_y, cell_max_y, level, level_index | 2);
                }
            } else if (!(r_min_x < (double)cell_mid_x)) {
                if (r_max_y <= (double)cell_mid_y) {
                    this.intersect_rectangle_with_cells(r_min_x, r_min_y, r_max_x, r_max_y, cell_mid_x, cell_max_x, cell_min_y, cell_mid_y, level, level_index | 1);
                } else if (!(r_min_y < (double)cell_mid_y)) {
                    this.intersect_rectangle_with_cells(r_min_x, r_min_y, r_max_x, r_max_y, cell_mid_x, cell_max_x, cell_mid_y, cell_max_y, level, level_index | 3);
                } else {
                    this.intersect_rectangle_with_cells(r_min_x, r_min_y, r_max_x, r_max_y, cell_mid_x, cell_max_x, cell_min_y, cell_mid_y, level, level_index | 1);
                    this.intersect_rectangle_with_cells(r_min_x, r_min_y, r_max_x, r_max_y, cell_mid_x, cell_max_x, cell_mid_y, cell_max_y, level, level_index | 3);
                }
            } else if (r_max_y <= (double)cell_mid_y) {
                this.intersect_rectangle_with_cells(r_min_x, r_min_y, r_max_x, r_max_y, cell_min_x, cell_mid_x, cell_min_y, cell_mid_y, level, level_index);
                this.intersect_rectangle_with_cells(r_min_x, r_min_y, r_max_x, r_max_y, cell_mid_x, cell_max_x, cell_min_y, cell_mid_y, level, level_index | 1);
            } else if (!(r_min_y < (double)cell_mid_y)) {
                this.intersect_rectangle_with_cells(r_min_x, r_min_y, r_max_x, r_max_y, cell_min_x, cell_mid_x, cell_mid_y, cell_max_y, level, level_index | 2);
                this.intersect_rectangle_with_cells(r_min_x, r_min_y, r_max_x, r_max_y, cell_mid_x, cell_max_x, cell_mid_y, cell_max_y, level, level_index | 3);
            } else {
                this.intersect_rectangle_with_cells(r_min_x, r_min_y, r_max_x, r_max_y, cell_min_x, cell_mid_x, cell_min_y, cell_mid_y, level, level_index);
                this.intersect_rectangle_with_cells(r_min_x, r_min_y, r_max_x, r_max_y, cell_mid_x, cell_max_x, cell_min_y, cell_mid_y, level, level_index | 1);
                this.intersect_rectangle_with_cells(r_min_x, r_min_y, r_max_x, r_max_y, cell_min_x, cell_mid_x, cell_mid_y, cell_max_y, level, level_index | 2);
                this.intersect_rectangle_with_cells(r_min_x, r_min_y, r_max_x, r_max_y, cell_mid_x, cell_max_x, cell_mid_y, cell_max_y, level, level_index | 3);
            }
        } else {
            this.current_cells.add(level_index);
        }
    }

    void intersect_rectangle_with_cells_adaptive(double r_min_x, double r_min_y, double r_max_x, double r_max_y, float cell_min_x, float cell_max_x, float cell_min_y, float cell_max_y, int level, int level_index) {
        int cell_index = this.get_cell_index(level_index, level);
        int adaptive_pos = cell_index / 32;
        int adaptive_bit = 1 << cell_index % 32;
        if (level < this.levels && (this.adaptive[adaptive_pos] & adaptive_bit) != 0) {
            ++level;
            level_index <<= 2;
            float cell_mid_x = (cell_min_x + cell_max_x) / 2.0f;
            float cell_mid_y = (cell_min_y + cell_max_y) / 2.0f;
            if (r_max_x <= (double)cell_mid_x) {
                if (r_max_y <= (double)cell_mid_y) {
                    this.intersect_rectangle_with_cells_adaptive(r_min_x, r_min_y, r_max_x, r_max_y, cell_min_x, cell_mid_x, cell_min_y, cell_mid_y, level, level_index);
                } else if (!(r_min_y < (double)cell_mid_y)) {
                    this.intersect_rectangle_with_cells_adaptive(r_min_x, r_min_y, r_max_x, r_max_y, cell_min_x, cell_mid_x, cell_mid_y, cell_max_y, level, level_index | 2);
                } else {
                    this.intersect_rectangle_with_cells_adaptive(r_min_x, r_min_y, r_max_x, r_max_y, cell_min_x, cell_mid_x, cell_min_y, cell_mid_y, level, level_index);
                    this.intersect_rectangle_with_cells_adaptive(r_min_x, r_min_y, r_max_x, r_max_y, cell_min_x, cell_mid_x, cell_mid_y, cell_max_y, level, level_index | 2);
                }
            } else if (!(r_min_x < (double)cell_mid_x)) {
                if (r_max_y <= (double)cell_mid_y) {
                    this.intersect_rectangle_with_cells_adaptive(r_min_x, r_min_y, r_max_x, r_max_y, cell_mid_x, cell_max_x, cell_min_y, cell_mid_y, level, level_index | 1);
                } else if (!(r_min_y < (double)cell_mid_y)) {
                    this.intersect_rectangle_with_cells_adaptive(r_min_x, r_min_y, r_max_x, r_max_y, cell_mid_x, cell_max_x, cell_mid_y, cell_max_y, level, level_index | 3);
                } else {
                    this.intersect_rectangle_with_cells_adaptive(r_min_x, r_min_y, r_max_x, r_max_y, cell_mid_x, cell_max_x, cell_min_y, cell_mid_y, level, level_index | 1);
                    this.intersect_rectangle_with_cells_adaptive(r_min_x, r_min_y, r_max_x, r_max_y, cell_mid_x, cell_max_x, cell_mid_y, cell_max_y, level, level_index | 3);
                }
            } else if (r_max_y <= (double)cell_mid_y) {
                this.intersect_rectangle_with_cells_adaptive(r_min_x, r_min_y, r_max_x, r_max_y, cell_min_x, cell_mid_x, cell_min_y, cell_mid_y, level, level_index);
                this.intersect_rectangle_with_cells_adaptive(r_min_x, r_min_y, r_max_x, r_max_y, cell_mid_x, cell_max_x, cell_min_y, cell_mid_y, level, level_index | 1);
            } else if (!(r_min_y < (double)cell_mid_y)) {
                this.intersect_rectangle_with_cells_adaptive(r_min_x, r_min_y, r_max_x, r_max_y, cell_min_x, cell_mid_x, cell_mid_y, cell_max_y, level, level_index | 2);
                this.intersect_rectangle_with_cells_adaptive(r_min_x, r_min_y, r_max_x, r_max_y, cell_mid_x, cell_max_x, cell_mid_y, cell_max_y, level, level_index | 3);
            } else {
                this.intersect_rectangle_with_cells_adaptive(r_min_x, r_min_y, r_max_x, r_max_y, cell_min_x, cell_mid_x, cell_min_y, cell_mid_y, level, level_index);
                this.intersect_rectangle_with_cells_adaptive(r_min_x, r_min_y, r_max_x, r_max_y, cell_mid_x, cell_max_x, cell_min_y, cell_mid_y, level, level_index | 1);
                this.intersect_rectangle_with_cells_adaptive(r_min_x, r_min_y, r_max_x, r_max_y, cell_min_x, cell_mid_x, cell_mid_y, cell_max_y, level, level_index | 2);
                this.intersect_rectangle_with_cells_adaptive(r_min_x, r_min_y, r_max_x, r_max_y, cell_mid_x, cell_max_x, cell_mid_y, cell_max_y, level, level_index | 3);
            }
        } else {
            this.current_cells.add(cell_index);
        }
    }

    void intersect_tile_with_cells(float ll_x, float ll_y, float ur_x, float ur_y, float cell_min_x, float cell_max_x, float cell_min_y, float cell_max_y, int level, int level_index) {
        if (level != 0) {
            --level;
            level_index <<= 2;
            float cell_mid_x = (cell_min_x + cell_max_x) / 2.0f;
            float cell_mid_y = (cell_min_y + cell_max_y) / 2.0f;
            if (ur_x <= cell_mid_x) {
                if (ur_y <= cell_mid_y) {
                    this.intersect_tile_with_cells(ll_x, ll_y, ur_x, ur_y, cell_min_x, cell_mid_x, cell_min_y, cell_mid_y, level, level_index);
                } else if (!(ll_y < cell_mid_y)) {
                    this.intersect_tile_with_cells(ll_x, ll_y, ur_x, ur_y, cell_min_x, cell_mid_x, cell_mid_y, cell_max_y, level, level_index | 2);
                } else {
                    this.intersect_tile_with_cells(ll_x, ll_y, ur_x, ur_y, cell_min_x, cell_mid_x, cell_min_y, cell_mid_y, level, level_index);
                    this.intersect_tile_with_cells(ll_x, ll_y, ur_x, ur_y, cell_min_x, cell_mid_x, cell_mid_y, cell_max_y, level, level_index | 2);
                }
            } else if (!(ll_x < cell_mid_x)) {
                if (ur_y <= cell_mid_y) {
                    this.intersect_tile_with_cells(ll_x, ll_y, ur_x, ur_y, cell_mid_x, cell_max_x, cell_min_y, cell_mid_y, level, level_index | 1);
                } else if (!(ll_y < cell_mid_y)) {
                    this.intersect_tile_with_cells(ll_x, ll_y, ur_x, ur_y, cell_mid_x, cell_max_x, cell_mid_y, cell_max_y, level, level_index | 3);
                } else {
                    this.intersect_tile_with_cells(ll_x, ll_y, ur_x, ur_y, cell_mid_x, cell_max_x, cell_min_y, cell_mid_y, level, level_index | 1);
                    this.intersect_tile_with_cells(ll_x, ll_y, ur_x, ur_y, cell_mid_x, cell_max_x, cell_mid_y, cell_max_y, level, level_index | 3);
                }
            } else if (ur_y <= cell_mid_y) {
                this.intersect_tile_with_cells(ll_x, ll_y, ur_x, ur_y, cell_min_x, cell_mid_x, cell_min_y, cell_mid_y, level, level_index);
                this.intersect_tile_with_cells(ll_x, ll_y, ur_x, ur_y, cell_mid_x, cell_max_x, cell_min_y, cell_mid_y, level, level_index | 1);
            } else if (!(ll_y < cell_mid_y)) {
                this.intersect_tile_with_cells(ll_x, ll_y, ur_x, ur_y, cell_min_x, cell_mid_x, cell_mid_y, cell_max_y, level, level_index | 2);
                this.intersect_tile_with_cells(ll_x, ll_y, ur_x, ur_y, cell_mid_x, cell_max_x, cell_mid_y, cell_max_y, level, level_index | 3);
            } else {
                this.intersect_tile_with_cells(ll_x, ll_y, ur_x, ur_y, cell_min_x, cell_mid_x, cell_min_y, cell_mid_y, level, level_index);
                this.intersect_tile_with_cells(ll_x, ll_y, ur_x, ur_y, cell_mid_x, cell_max_x, cell_min_y, cell_mid_y, level, level_index | 1);
                this.intersect_tile_with_cells(ll_x, ll_y, ur_x, ur_y, cell_min_x, cell_mid_x, cell_mid_y, cell_max_y, level, level_index | 2);
                this.intersect_tile_with_cells(ll_x, ll_y, ur_x, ur_y, cell_mid_x, cell_max_x, cell_mid_y, cell_max_y, level, level_index | 3);
            }
        } else {
            this.current_cells.add(level_index);
        }
    }

    void intersect_tile_with_cells_adaptive(float ll_x, float ll_y, float ur_x, float ur_y, float cell_min_x, float cell_max_x, float cell_min_y, float cell_max_y, int level, int level_index) {
        int cell_index = this.get_cell_index(level_index, level);
        int adaptive_pos = cell_index / 32;
        int adaptive_bit = 1 << cell_index % 32;
        if (level < this.levels && (this.adaptive[adaptive_pos] & adaptive_bit) != 0) {
            ++level;
            level_index <<= 2;
            float cell_mid_x = (cell_min_x + cell_max_x) / 2.0f;
            float cell_mid_y = (cell_min_y + cell_max_y) / 2.0f;
            if (ur_x <= cell_mid_x) {
                if (ur_y <= cell_mid_y) {
                    this.intersect_tile_with_cells_adaptive(ll_x, ll_y, ur_x, ur_y, cell_min_x, cell_mid_x, cell_min_y, cell_mid_y, level, level_index);
                } else if (!(ll_y < cell_mid_y)) {
                    this.intersect_tile_with_cells_adaptive(ll_x, ll_y, ur_x, ur_y, cell_min_x, cell_mid_x, cell_mid_y, cell_max_y, level, level_index | 2);
                } else {
                    this.intersect_tile_with_cells_adaptive(ll_x, ll_y, ur_x, ur_y, cell_min_x, cell_mid_x, cell_min_y, cell_mid_y, level, level_index);
                    this.intersect_tile_with_cells_adaptive(ll_x, ll_y, ur_x, ur_y, cell_min_x, cell_mid_x, cell_mid_y, cell_max_y, level, level_index | 2);
                }
            } else if (!(ll_x < cell_mid_x)) {
                if (ur_y <= cell_mid_y) {
                    this.intersect_tile_with_cells_adaptive(ll_x, ll_y, ur_x, ur_y, cell_mid_x, cell_max_x, cell_min_y, cell_mid_y, level, level_index | 1);
                } else if (!(ll_y < cell_mid_y)) {
                    this.intersect_tile_with_cells_adaptive(ll_x, ll_y, ur_x, ur_y, cell_mid_x, cell_max_x, cell_mid_y, cell_max_y, level, level_index | 3);
                } else {
                    this.intersect_tile_with_cells_adaptive(ll_x, ll_y, ur_x, ur_y, cell_mid_x, cell_max_x, cell_min_y, cell_mid_y, level, level_index | 1);
                    this.intersect_tile_with_cells_adaptive(ll_x, ll_y, ur_x, ur_y, cell_mid_x, cell_max_x, cell_mid_y, cell_max_y, level, level_index | 3);
                }
            } else if (ur_y <= cell_mid_y) {
                this.intersect_tile_with_cells_adaptive(ll_x, ll_y, ur_x, ur_y, cell_min_x, cell_mid_x, cell_min_y, cell_mid_y, level, level_index);
                this.intersect_tile_with_cells_adaptive(ll_x, ll_y, ur_x, ur_y, cell_mid_x, cell_max_x, cell_min_y, cell_mid_y, level, level_index | 1);
            } else if (!(ll_y < cell_mid_y)) {
                this.intersect_tile_with_cells_adaptive(ll_x, ll_y, ur_x, ur_y, cell_min_x, cell_mid_x, cell_mid_y, cell_max_y, level, level_index | 2);
                this.intersect_tile_with_cells_adaptive(ll_x, ll_y, ur_x, ur_y, cell_mid_x, cell_max_x, cell_mid_y, cell_max_y, level, level_index | 3);
            } else {
                this.intersect_tile_with_cells_adaptive(ll_x, ll_y, ur_x, ur_y, cell_min_x, cell_mid_x, cell_min_y, cell_mid_y, level, level_index);
                this.intersect_tile_with_cells_adaptive(ll_x, ll_y, ur_x, ur_y, cell_mid_x, cell_max_x, cell_min_y, cell_mid_y, level, level_index | 1);
                this.intersect_tile_with_cells_adaptive(ll_x, ll_y, ur_x, ur_y, cell_min_x, cell_mid_x, cell_mid_y, cell_max_y, level, level_index | 2);
                this.intersect_tile_with_cells_adaptive(ll_x, ll_y, ur_x, ur_y, cell_mid_x, cell_max_x, cell_mid_y, cell_max_y, level, level_index | 3);
            }
        } else {
            this.current_cells.add(cell_index);
        }
    }

    void intersect_circle_with_cells(double center_x, double center_y, double radius, double r_min_x, double r_min_y, double r_max_x, double r_max_y, float cell_min_x, float cell_max_x, float cell_min_y, float cell_max_y, int level, int level_index) {
        if (level != 0) {
            --level;
            level_index <<= 2;
            float cell_mid_x = (cell_min_x + cell_max_x) / 2.0f;
            float cell_mid_y = (cell_min_y + cell_max_y) / 2.0f;
            if (r_max_x <= (double)cell_mid_x) {
                if (r_max_y <= (double)cell_mid_y) {
                    this.intersect_circle_with_cells(center_x, center_y, radius, r_min_x, r_min_y, r_max_x, r_max_y, cell_min_x, cell_mid_x, cell_min_y, cell_mid_y, level, level_index);
                } else if (!(r_min_y < (double)cell_mid_y)) {
                    this.intersect_circle_with_cells(center_x, center_y, radius, r_min_x, r_min_y, r_max_x, r_max_y, cell_min_x, cell_mid_x, cell_mid_y, cell_max_y, level, level_index | 2);
                } else {
                    this.intersect_circle_with_cells(center_x, center_y, radius, r_min_x, r_min_y, r_max_x, r_max_y, cell_min_x, cell_mid_x, cell_min_y, cell_mid_y, level, level_index);
                    this.intersect_circle_with_cells(center_x, center_y, radius, r_min_x, r_min_y, r_max_x, r_max_y, cell_min_x, cell_mid_x, cell_mid_y, cell_max_y, level, level_index | 2);
                }
            } else if (!(r_min_x < (double)cell_mid_x)) {
                if (r_max_y <= (double)cell_mid_y) {
                    this.intersect_circle_with_cells(center_x, center_y, radius, r_min_x, r_min_y, r_max_x, r_max_y, cell_mid_x, cell_max_x, cell_min_y, cell_mid_y, level, level_index | 1);
                } else if (!(r_min_y < (double)cell_mid_y)) {
                    this.intersect_circle_with_cells(center_x, center_y, radius, r_min_x, r_min_y, r_max_x, r_max_y, cell_mid_x, cell_max_x, cell_mid_y, cell_max_y, level, level_index | 3);
                } else {
                    this.intersect_circle_with_cells(center_x, center_y, radius, r_min_x, r_min_y, r_max_x, r_max_y, cell_mid_x, cell_max_x, cell_min_y, cell_mid_y, level, level_index | 1);
                    this.intersect_circle_with_cells(center_x, center_y, radius, r_min_x, r_min_y, r_max_x, r_max_y, cell_mid_x, cell_max_x, cell_mid_y, cell_max_y, level, level_index | 3);
                }
            } else if (r_max_y <= (double)cell_mid_y) {
                this.intersect_circle_with_cells(center_x, center_y, radius, r_min_x, r_min_y, r_max_x, r_max_y, cell_min_x, cell_mid_x, cell_min_y, cell_mid_y, level, level_index);
                this.intersect_circle_with_cells(center_x, center_y, radius, r_min_x, r_min_y, r_max_x, r_max_y, cell_mid_x, cell_max_x, cell_min_y, cell_mid_y, level, level_index | 1);
            } else if (!(r_min_y < (double)cell_mid_y)) {
                this.intersect_circle_with_cells(center_x, center_y, radius, r_min_x, r_min_y, r_max_x, r_max_y, cell_min_x, cell_mid_x, cell_mid_y, cell_max_y, level, level_index | 2);
                this.intersect_circle_with_cells(center_x, center_y, radius, r_min_x, r_min_y, r_max_x, r_max_y, cell_mid_x, cell_max_x, cell_mid_y, cell_max_y, level, level_index | 3);
            } else {
                this.intersect_circle_with_cells(center_x, center_y, radius, r_min_x, r_min_y, r_max_x, r_max_y, cell_min_x, cell_mid_x, cell_min_y, cell_mid_y, level, level_index);
                this.intersect_circle_with_cells(center_x, center_y, radius, r_min_x, r_min_y, r_max_x, r_max_y, cell_mid_x, cell_max_x, cell_min_y, cell_mid_y, level, level_index | 1);
                this.intersect_circle_with_cells(center_x, center_y, radius, r_min_x, r_min_y, r_max_x, r_max_y, cell_min_x, cell_mid_x, cell_mid_y, cell_max_y, level, level_index | 2);
                this.intersect_circle_with_cells(center_x, center_y, radius, r_min_x, r_min_y, r_max_x, r_max_y, cell_mid_x, cell_max_x, cell_mid_y, cell_max_y, level, level_index | 3);
            }
        } else if (this.intersect_circle_with_rectangle(center_x, center_y, radius, cell_min_x, cell_max_x, cell_min_y, cell_max_y)) {
            this.current_cells.add(level_index);
        }
    }

    void intersect_circle_with_cells_adaptive(double center_x, double center_y, double radius, double r_min_x, double r_min_y, double r_max_x, double r_max_y, float cell_min_x, float cell_max_x, float cell_min_y, float cell_max_y, int level, int level_index) {
        int cell_index = this.get_cell_index(level_index, level);
        int adaptive_pos = cell_index / 32;
        int adaptive_bit = 1 << cell_index % 32;
        if (level < this.levels && (this.adaptive[adaptive_pos] & adaptive_bit) != 0) {
            ++level;
            level_index <<= 2;
            float cell_mid_x = (cell_min_x + cell_max_x) / 2.0f;
            float cell_mid_y = (cell_min_y + cell_max_y) / 2.0f;
            if (r_max_x <= (double)cell_mid_x) {
                if (r_max_y <= (double)cell_mid_y) {
                    this.intersect_circle_with_cells_adaptive(center_x, center_y, radius, r_min_x, r_min_y, r_max_x, r_max_y, cell_min_x, cell_mid_x, cell_min_y, cell_mid_y, level, level_index);
                } else if (!(r_min_y < (double)cell_mid_y)) {
                    this.intersect_circle_with_cells_adaptive(center_x, center_y, radius, r_min_x, r_min_y, r_max_x, r_max_y, cell_min_x, cell_mid_x, cell_mid_y, cell_max_y, level, level_index | 2);
                } else {
                    this.intersect_circle_with_cells_adaptive(center_x, center_y, radius, r_min_x, r_min_y, r_max_x, r_max_y, cell_min_x, cell_mid_x, cell_min_y, cell_mid_y, level, level_index);
                    this.intersect_circle_with_cells_adaptive(center_x, center_y, radius, r_min_x, r_min_y, r_max_x, r_max_y, cell_min_x, cell_mid_x, cell_mid_y, cell_max_y, level, level_index | 2);
                }
            } else if (!(r_min_x < (double)cell_mid_x)) {
                if (r_max_y <= (double)cell_mid_y) {
                    this.intersect_circle_with_cells_adaptive(center_x, center_y, radius, r_min_x, r_min_y, r_max_x, r_max_y, cell_mid_x, cell_max_x, cell_min_y, cell_mid_y, level, level_index | 1);
                } else if (!(r_min_y < (double)cell_mid_y)) {
                    this.intersect_circle_with_cells_adaptive(center_x, center_y, radius, r_min_x, r_min_y, r_max_x, r_max_y, cell_mid_x, cell_max_x, cell_mid_y, cell_max_y, level, level_index | 3);
                } else {
                    this.intersect_circle_with_cells_adaptive(center_x, center_y, radius, r_min_x, r_min_y, r_max_x, r_max_y, cell_mid_x, cell_max_x, cell_min_y, cell_mid_y, level, level_index | 1);
                    this.intersect_circle_with_cells_adaptive(center_x, center_y, radius, r_min_x, r_min_y, r_max_x, r_max_y, cell_mid_x, cell_max_x, cell_mid_y, cell_max_y, level, level_index | 3);
                }
            } else if (r_max_y <= (double)cell_mid_y) {
                this.intersect_circle_with_cells_adaptive(center_x, center_y, radius, r_min_x, r_min_y, r_max_x, r_max_y, cell_min_x, cell_mid_x, cell_min_y, cell_mid_y, level, level_index);
                this.intersect_circle_with_cells_adaptive(center_x, center_y, radius, r_min_x, r_min_y, r_max_x, r_max_y, cell_mid_x, cell_max_x, cell_min_y, cell_mid_y, level, level_index | 1);
            } else if (!(r_min_y < (double)cell_mid_y)) {
                this.intersect_circle_with_cells_adaptive(center_x, center_y, radius, r_min_x, r_min_y, r_max_x, r_max_y, cell_min_x, cell_mid_x, cell_mid_y, cell_max_y, level, level_index | 2);
                this.intersect_circle_with_cells_adaptive(center_x, center_y, radius, r_min_x, r_min_y, r_max_x, r_max_y, cell_mid_x, cell_max_x, cell_mid_y, cell_max_y, level, level_index | 3);
            } else {
                this.intersect_circle_with_cells_adaptive(center_x, center_y, radius, r_min_x, r_min_y, r_max_x, r_max_y, cell_min_x, cell_mid_x, cell_min_y, cell_mid_y, level, level_index);
                this.intersect_circle_with_cells_adaptive(center_x, center_y, radius, r_min_x, r_min_y, r_max_x, r_max_y, cell_mid_x, cell_max_x, cell_min_y, cell_mid_y, level, level_index | 1);
                this.intersect_circle_with_cells_adaptive(center_x, center_y, radius, r_min_x, r_min_y, r_max_x, r_max_y, cell_min_x, cell_mid_x, cell_mid_y, cell_max_y, level, level_index | 2);
                this.intersect_circle_with_cells_adaptive(center_x, center_y, radius, r_min_x, r_min_y, r_max_x, r_max_y, cell_mid_x, cell_max_x, cell_mid_y, cell_max_y, level, level_index | 3);
            }
        } else if (this.intersect_circle_with_rectangle(center_x, center_y, radius, cell_min_x, cell_max_x, cell_min_y, cell_max_y)) {
            this.current_cells.add(cell_index);
        }
    }

    boolean intersect_circle_with_rectangle(double center_x, double center_y, double radius, float r_min_x, float r_max_x, float r_min_y, float r_max_y) {
        double radius_squared = radius * radius;
        if ((double)r_max_x < center_x) {
            double r_diff_x = center_x - (double)r_max_x;
            if ((double)r_max_y < center_y) {
                double r_diff_y = center_y - (double)r_max_y;
                return r_diff_x * r_diff_x + r_diff_y * r_diff_y < radius_squared;
            }
            if ((double)r_min_y > center_y) {
                double r_diff_y = -center_y + (double)r_min_y;
                return r_diff_x * r_diff_x + r_diff_y * r_diff_y < radius_squared;
            }
            return r_diff_x < radius;
        }
        if ((double)r_min_x > center_x) {
            double r_diff_x = -center_x + (double)r_min_x;
            if ((double)r_max_y < center_y) {
                double r_diff_y = center_y - (double)r_max_y;
                return r_diff_x * r_diff_x + r_diff_y * r_diff_y < radius_squared;
            }
            if ((double)r_min_y > center_y) {
                double r_diff_y = -center_y + (double)r_min_y;
                return r_diff_x * r_diff_x + r_diff_y * r_diff_y < radius_squared;
            }
            return r_diff_x < radius;
        }
        if ((double)r_max_y < center_y) {
            double r_diff_y = center_y - (double)r_max_y;
            return r_diff_y < radius;
        }
        if ((double)r_min_y > center_y) {
            double r_diff_y = -center_y + (double)r_min_y;
            return r_diff_y < radius;
        }
        return Boolean.TRUE;
    }

    boolean get_all_cells() {
        this.intersect_rectangle(this.min_x, this.min_y, this.max_x, this.max_y);
        return this.get_intersected_cells();
    }

    boolean get_intersected_cells() {
        this.next_cell_index = 0;
        if (this.current_cells == null) {
            return Boolean.FALSE;
        }
        if (this.current_cells.size() == 0) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    boolean has_more_cells() {
        if (this.current_cells == null) {
            return Boolean.FALSE;
        }
        if (this.next_cell_index >= this.current_cells.size()) {
            return Boolean.FALSE;
        }
        this.current_cell = this.adaptive != null ? this.current_cells.get(this.next_cell_index) : this.level_offset[this.levels] + this.current_cells.get(this.next_cell_index);
        ++this.next_cell_index;
        return Boolean.TRUE;
    }

    public boolean setup(double bb_min_x, double bb_max_x, double bb_min_y, double bb_max_y, float cell_size) {
        this.cell_size = cell_size;
        this.sub_level = 0;
        this.sub_level_index = 0;
        this.min_x = bb_min_x >= 0.0 ? cell_size * (float)((int)(bb_min_x / (double)cell_size)) : cell_size * (float)((int)(bb_min_x / (double)cell_size) - 1);
        this.max_x = bb_max_x >= 0.0 ? cell_size * (float)((int)(bb_max_x / (double)cell_size) + 1) : cell_size * (float)((int)(bb_max_x / (double)cell_size));
        this.min_y = bb_min_y >= 0.0 ? cell_size * (float)((int)(bb_min_y / (double)cell_size)) : cell_size * (float)((int)(bb_min_y / (double)cell_size) - 1);
        this.max_y = bb_max_y >= 0.0 ? cell_size * (float)((int)(bb_max_y / (double)cell_size) + 1) : cell_size * (float)((int)(bb_max_y / (double)cell_size));
        this.cells_x = MyDefs.U32_QUANTIZE((this.max_x - this.min_x) / cell_size);
        this.cells_y = MyDefs.U32_QUANTIZE((this.max_y - this.min_y) / cell_size);
        if (this.cells_x == 0 || this.cells_y == 0) {
            Cstdio.fprintf(stderr, "ERROR: cells_x %d cells_y %d\n", this.cells_x, this.cells_y);
            return Boolean.FALSE;
        }
        int c = this.cells_x > this.cells_y ? this.cells_x - 1 : this.cells_y - 1;
        this.levels = 0;
        while (c != 0) {
            c >>>= 1;
            ++this.levels;
        }
        c = (1 << this.levels) - this.cells_x;
        int c1 = c / 2;
        int c2 = c - c1;
        this.min_x -= (float)c2 * cell_size;
        this.max_x += (float)c1 * cell_size;
        c = (1 << this.levels) - this.cells_y;
        c1 = c / 2;
        c2 = c - c1;
        this.min_y -= (float)c2 * cell_size;
        this.max_y += (float)c1 * cell_size;
        return Boolean.TRUE;
    }

    boolean setup(double bb_min_x, double bb_max_x, double bb_min_y, double bb_max_y, float cell_size, float offset_x, float offset_y) {
        this.cell_size = cell_size;
        this.sub_level = 0;
        this.sub_level_index = 0;
        this.min_x = bb_min_x - (double)offset_x >= 0.0 ? cell_size * (float)((int)((bb_min_x - (double)offset_x) / (double)cell_size)) + offset_x : cell_size * (float)((int)((bb_min_x - (double)offset_x) / (double)cell_size) - 1) + offset_x;
        this.max_x = bb_max_x - (double)offset_x >= 0.0 ? cell_size * (float)((int)((bb_max_x - (double)offset_x) / (double)cell_size) + 1) + offset_x : cell_size * (float)((int)((bb_max_x - (double)offset_x) / (double)cell_size)) + offset_x;
        this.min_y = bb_min_y - (double)offset_y >= 0.0 ? cell_size * (float)((int)((bb_min_y - (double)offset_y) / (double)cell_size)) + offset_y : cell_size * (float)((int)((bb_min_y - (double)offset_y) / (double)cell_size) - 1) + offset_y;
        this.max_y = bb_max_y - (double)offset_y >= 0.0 ? cell_size * (float)((int)((bb_max_y - (double)offset_y) / (double)cell_size) + 1) + offset_y : cell_size * (float)((int)((bb_max_y - (double)offset_y) / (double)cell_size)) + offset_y;
        this.cells_x = MyDefs.U32_QUANTIZE((this.max_x - this.min_x) / cell_size);
        this.cells_y = MyDefs.U32_QUANTIZE((this.max_y - this.min_y) / cell_size);
        if (this.cells_x == 0 || this.cells_y == 0) {
            Cstdio.fprintf(stderr, "ERROR: cells_x %d cells_y %d\n", this.cells_x, this.cells_y);
            return Boolean.FALSE;
        }
        int c = this.cells_x > this.cells_y ? this.cells_x - 1 : this.cells_y - 1;
        this.levels = 0;
        while (c != 0) {
            c >>= 1;
            ++this.levels;
        }
        c = (1 << this.levels) - this.cells_x;
        int c1 = c / 2;
        int c2 = c - c1;
        this.min_x -= (float)c2 * cell_size;
        this.max_x += (float)c1 * cell_size;
        c = (1 << this.levels) - this.cells_y;
        c1 = c / 2;
        c2 = c - c1;
        this.min_y -= (float)c2 * cell_size;
        this.max_y += (float)c1 * cell_size;
        return Boolean.TRUE;
    }

    boolean tiling_setup(float min_x, float max_x, float min_y, float max_y, int levels) {
        this.min_x = min_x;
        this.max_x = max_x;
        this.min_y = min_y;
        this.max_y = max_y;
        this.levels = levels;
        this.sub_level = 0;
        this.sub_level_index = 0;
        return Boolean.TRUE;
    }

    boolean subtiling_setup(float min_x, float max_x, float min_y, float max_y, int sub_level, int sub_level_index, int levels) {
        this.min_x = min_x;
        this.max_x = max_x;
        this.min_y = min_y;
        this.max_y = max_y;
        float[] min = new float[2];
        float[] max = new float[2];
        this.get_cell_bounding_box(sub_level_index, sub_level, min, max);
        this.min_x = min[0];
        this.max_x = max[0];
        this.min_y = min[1];
        this.max_y = max[1];
        this.sub_level = sub_level;
        this.sub_level_index = sub_level_index;
        this.levels = levels;
        return Boolean.TRUE;
    }

    public LASquadtree() {
        this.level_offset[0] = 0;
        for (int l = 0; l < 23; ++l) {
            this.level_offset[l + 1] = this.level_offset[l] + (1 << l) * (1 << l);
        }
        this.current_cells = null;
        this.adaptive_alloc = 0;
        this.adaptive = null;
    }
}

