/*
 * Decompiled with CFR 0.152.
 */
package com.github.mreutegg.laszip4j.laszip;

import com.github.mreutegg.laszip4j.laszip.ClassificationFlag;
import com.github.mreutegg.laszip4j.laszip.IGpsTimeProvider;
import com.github.mreutegg.laszip4j.laszip.LASattributer;
import com.github.mreutegg.laszip4j.laszip.LASitem;
import com.github.mreutegg.laszip4j.laszip.LASquantizer;
import com.github.mreutegg.laszip4j.laszip.LasItemsFactory;
import com.github.mreutegg.laszip4j.laszip.PointDataRecord;
import com.github.mreutegg.laszip4j.laszip.PointDataRecordBytes;
import com.github.mreutegg.laszip4j.laszip.PointDataRecordGpsTime;
import com.github.mreutegg.laszip4j.laszip.PointDataRecordPoint10;
import com.github.mreutegg.laszip4j.laszip.PointDataRecordPoint14;
import com.github.mreutegg.laszip4j.laszip.PointDataRecordRGB;
import com.github.mreutegg.laszip4j.laszip.PointDataRecordRgbNIR;
import com.github.mreutegg.laszip4j.laszip.PointDataRecordWavepacket;
import com.github.mreutegg.laszip4j.laszip.PointDataRecordXYZBase;
import com.github.mreutegg.laszip4j.laszip.ScanFlag;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class LASpoint {
    public PointDataRecord[] PointRecords;
    public LASquantizer quantizer;
    public LASattributer attributer;
    public char num_items;
    public LASitem[] items;

    public LASpoint() {
    }

    public LASpoint(LASpoint other) {
        this.PointRecords = other.PointRecords;
    }

    public boolean init(LASquantizer quantizer, byte point_type, char point_size, LASattributer attributer) {
        this.items = LasItemsFactory.getItems(point_type, point_size, '\u0000');
        this.num_items = (char)this.items.length;
        return this.init(quantizer, this.num_items, this.items, attributer);
    }

    public boolean init(LASquantizer quantizer, int u_num_items, LASitem[] items, LASattributer attributer) {
        this.num_items = (char)u_num_items;
        this.items = items;
        this.PointRecords = new PointDataRecord[this.num_items];
        block9: for (int i = 0; i < this.num_items; ++i) {
            switch (items[i].type) {
                case POINT10: {
                    this.PointRecords[i] = new PointDataRecordPoint10();
                    continue block9;
                }
                case POINT14: {
                    this.PointRecords[i] = new PointDataRecordPoint14();
                    continue block9;
                }
                case GPSTIME11: {
                    this.PointRecords[i] = new PointDataRecordGpsTime();
                    continue block9;
                }
                case RGBNIR14: {
                    this.PointRecords[i] = new PointDataRecordRgbNIR();
                    continue block9;
                }
                case RGB12: 
                case RGB14: {
                    this.PointRecords[i] = new PointDataRecordRGB();
                    continue block9;
                }
                case WAVEPACKET13: 
                case WAVEPACKET14: {
                    this.PointRecords[i] = new PointDataRecordWavepacket();
                    continue block9;
                }
                case BYTE: 
                case BYTE14: {
                    this.PointRecords[i] = new PointDataRecordBytes(items[i].size);
                    continue block9;
                }
                default: {
                    return Boolean.FALSE;
                }
            }
        }
        this.quantizer = quantizer;
        this.attributer = attributer;
        return Boolean.TRUE;
    }

    public boolean inside_rectangle(double r_min_x, double r_min_y, double r_max_x, double r_max_y) {
        double xy = this.get_x();
        if (xy < r_min_x || xy >= r_max_x) {
            return Boolean.FALSE;
        }
        xy = this.get_y();
        if (xy < r_min_y || xy >= r_max_y) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public boolean inside_tile(float ll_x, float ll_y, float ur_x, float ur_y) {
        double xy = this.get_x();
        if (xy < (double)ll_x || xy >= (double)ur_x) {
            return Boolean.FALSE;
        }
        xy = this.get_y();
        if (xy < (double)ll_y || xy >= (double)ur_y) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public boolean inside_circle(double center_x, double center_y, double squared_radius) {
        double dy;
        double dx = center_x - this.get_x();
        return dx * dx + (dy = center_y - this.get_y()) * dy < squared_radius;
    }

    public boolean inside_box(double min_x, double min_y, double min_z, double max_x, double max_y, double max_z) {
        double xyz = this.get_x();
        if (xyz < min_x || xyz >= max_x) {
            return Boolean.FALSE;
        }
        xyz = this.get_y();
        if (xyz < min_y || xyz >= max_y) {
            return Boolean.FALSE;
        }
        xyz = this.get_z();
        if (xyz < min_z || xyz >= max_z) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    boolean inside_bounding_box(double min_x, double min_y, double min_z, double max_x, double max_y, double max_z) {
        double xyz = this.get_x();
        if (xyz < min_x || xyz > max_x) {
            return Boolean.FALSE;
        }
        xyz = this.get_y();
        if (xyz < min_y || xyz > max_y) {
            return Boolean.FALSE;
        }
        xyz = this.get_z();
        if (xyz < min_z || xyz > max_z) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public boolean is_first() {
        return this.get_return_number() <= 1;
    }

    public boolean is_intermediate() {
        return !this.is_first() && !this.is_last();
    }

    public boolean is_last() {
        return this.get_return_number() >= this.get_number_of_returns();
    }

    public boolean is_single() {
        return this.get_number_of_returns() <= 1;
    }

    public boolean is_first_of_many() {
        return !this.is_single() && this.is_first();
    }

    public boolean is_last_of_many() {
        return !this.is_single() && this.is_last();
    }

    public int get_X() {
        return this.getX();
    }

    public int get_Y() {
        return this.getY();
    }

    public int get_Z() {
        return this.getZ();
    }

    public int get_intensity() {
        return this.getIntensity();
    }

    public short get_return_number() {
        return this.getReturn_number();
    }

    public short get_number_of_returns() {
        return this.getNumber_of_returns();
    }

    public byte get_scan_direction_flag() {
        return this.getScan_direction_flag();
    }

    public byte get_edge_of_flight_line() {
        return this.getEdge_of_flight_line();
    }

    public short get_classification() {
        return this.getClassification();
    }

    public byte get_synthetic_flag() {
        return this.getSynthetic_flag();
    }

    public byte get_keypoint_flag() {
        return this.getKeypoint_flag();
    }

    public byte get_withheld_flag() {
        return this.getWithheld_flag();
    }

    public byte get_extended_overlap_flag() {
        return this.getOverlap_flag();
    }

    public byte get_scan_angle_rank() {
        return this.getScan_angle_rank();
    }

    public short get_user_data() {
        return this.getUser_data();
    }

    public int get_point_source_ID() {
        return this.getPoint_source_ID();
    }

    public double get_gps_time() {
        return this.getGps_time();
    }

    public char[] get_rgb() {
        return this.getRgb();
    }

    public char get_R() {
        return this.getRgb(0);
    }

    public char get_G() {
        return this.getRgb(1);
    }

    public char get_B() {
        return this.getRgb(2);
    }

    public char get_I() {
        return this.getRgb(3);
    }

    public void set_X(int X) {
        this.setX(X);
    }

    public void set_Y(int Y) {
        this.setY(Y);
    }

    public void set_Z(int Z) {
        this.setZ(Z);
    }

    public void set_intensity(char intensity) {
        this.setIntensity(intensity);
    }

    public void set_return_number(byte return_number) {
        this.setReturn_number(return_number > 7 ? (byte)7 : (byte)return_number);
    }

    public void set_number_of_returns(byte number_of_returns) {
        this.setNumber_of_returns(number_of_returns > 7 ? (byte)7 : (byte)number_of_returns);
    }

    public void set_scan_direction_flag(byte scan_direction_flag) {
        this.setScan_direction_flag(scan_direction_flag);
    }

    public void set_edge_of_flight_line(byte edge_of_flight_line) {
        this.setEdge_of_flight_line(edge_of_flight_line);
    }

    public void set_classification(byte classification) {
        this.setClassification((byte)(classification & 0x1F));
    }

    public void set_user_data(short user_data) {
        this.setUser_data(user_data);
    }

    public void set_point_source_ID(char point_source_ID) {
        this.setPoint_source_ID(point_source_ID);
    }

    public void set_gps_time(double gps_time) {
        this.setGps_time(gps_time);
    }

    public void set_RGB(char[] rgb) {
        this.setRgb(rgb);
    }

    public void set_RGBI(char[] rgb) {
        this.setRgb(rgb);
    }

    public void set_R(char R) {
        this.setRgb(0, R);
    }

    public void set_G(char G) {
        this.setRgb(1, G);
    }

    public void set_B(char B) {
        this.setRgb(2, B);
    }

    public void set_I(char I) {
        this.setRgb(3, I);
    }

    public double get_x() {
        return this.quantizer.get_x(this.getX());
    }

    public double get_y() {
        return this.quantizer.get_y(this.getY());
    }

    public double get_z() {
        return this.quantizer.get_z(this.getZ());
    }

    public void set_x(double x) {
        this.setX(this.quantizer.get_X(x));
    }

    public void set_y(double y) {
        this.setY(this.quantizer.get_Y(y));
    }

    public void set_z(double z) {
        this.setZ(this.quantizer.get_Z(z));
    }

    public boolean has_attribute(int index) {
        if (this.attributer != null && index < this.attributer.number_attributes) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public boolean get_attribute(int index, byte[] data) {
        PointDataRecord bytesRecord = this.getPointDataRecord(PointDataRecordBytes.class);
        if (this.has_attribute(index) && null != bytesRecord) {
            System.arraycopy(((PointDataRecordBytes)bytesRecord).Bytes, this.attributer.attribute_starts.get(index), data, 0, this.attributer.attribute_sizes.get(index));
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public boolean set_attribute(int index, byte[] data) {
        PointDataRecord bytesRecord = this.getPointDataRecord(PointDataRecordBytes.class);
        if (this.has_attribute(index) && null != bytesRecord) {
            System.arraycopy(data, 0, ((PointDataRecordBytes)bytesRecord).Bytes, this.attributer.attribute_starts.get(index), this.attributer.attribute_sizes.get(index));
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public byte get_attributeUByte(int start) {
        return this.getExtraBytes()[start];
    }

    public void set_attributeU(int start, byte data) {
        this.getExtraBytes()[start] = data;
    }

    public byte get_attributeByte(int start) {
        return this.getExtraBytes()[start];
    }

    public void set_attribute(int start, byte data) {
        this.getExtraBytes()[start] = data;
    }

    public char get_attributeChar(int start) {
        return ByteBuffer.wrap(this.getExtraBytes()).order(ByteOrder.LITTLE_ENDIAN).getChar(start);
    }

    public void set_attribute(int start, char data) {
        ByteBuffer.wrap(this.getExtraBytes()).order(ByteOrder.LITTLE_ENDIAN).putChar(start, data);
    }

    public short get_attributeShort(int start) {
        return ByteBuffer.wrap(this.getExtraBytes()).order(ByteOrder.LITTLE_ENDIAN).getShort(start);
    }

    public void set_attribute(int start, short data) {
        ByteBuffer.wrap(this.getExtraBytes()).order(ByteOrder.LITTLE_ENDIAN).putShort(start, data);
    }

    public int get_attributeUInt(int start) {
        return ByteBuffer.wrap(this.getExtraBytes()).order(ByteOrder.LITTLE_ENDIAN).getInt(start);
    }

    public void set_attributeU(int start, int data) {
        ByteBuffer.wrap(this.getExtraBytes()).order(ByteOrder.LITTLE_ENDIAN).putInt(start, data);
    }

    public int get_attributeInt(int start) {
        return ByteBuffer.wrap(this.getExtraBytes()).order(ByteOrder.LITTLE_ENDIAN).getInt(start);
    }

    public void set_attribute(int start, int data) {
        ByteBuffer.wrap(this.getExtraBytes()).order(ByteOrder.LITTLE_ENDIAN).putInt(start, data);
    }

    public long get_attributeULong(int start) {
        return ByteBuffer.wrap(this.getExtraBytes()).order(ByteOrder.LITTLE_ENDIAN).getLong(start);
    }

    public void set_attributeU(int start, long data) {
        ByteBuffer.wrap(this.getExtraBytes()).order(ByteOrder.LITTLE_ENDIAN).putLong(start, data);
    }

    public long get_attributeLong(int start) {
        return ByteBuffer.wrap(this.getExtraBytes()).order(ByteOrder.LITTLE_ENDIAN).getLong(start);
    }

    public void set_attribute(int start, long data) {
        ByteBuffer.wrap(this.getExtraBytes()).order(ByteOrder.LITTLE_ENDIAN).putLong(start, data);
    }

    public float get_attributeFloat(int start) {
        return ByteBuffer.wrap(this.getExtraBytes()).order(ByteOrder.LITTLE_ENDIAN).getFloat(start);
    }

    public void set_attribute(int start, float data) {
        ByteBuffer.wrap(this.getExtraBytes()).order(ByteOrder.LITTLE_ENDIAN).putFloat(start, data);
    }

    public double get_attributeDouble(int start) {
        return ByteBuffer.wrap(this.getExtraBytes()).order(ByteOrder.LITTLE_ENDIAN).getDouble(start);
    }

    public void set_attribute(int start, double data) {
        ByteBuffer.wrap(this.getExtraBytes()).order(ByteOrder.LITTLE_ENDIAN).putDouble(start, data);
    }

    public int getX() {
        return this.getPointXYZ().X;
    }

    public void setX(int x) {
        this.getPointXYZ().X = x;
    }

    public int getY() {
        return this.getPointXYZ().Y;
    }

    public void setY(int y) {
        this.getPointXYZ().Y = y;
    }

    public int getZ() {
        return this.getPointXYZ().Z;
    }

    public void setZ(int z) {
        this.getPointXYZ().Z = z;
    }

    public char getIntensity() {
        return this.getPointXYZ().Intensity;
    }

    public void setIntensity(char intensity) {
        this.getPointXYZ().Intensity = intensity;
    }

    public byte getReturn_number() {
        return this.getPointXYZ().getReturnNumber();
    }

    public void setReturn_number(byte return_number) {
        this.getPointXYZ().setReturnNumber(return_number);
    }

    public byte getNumber_of_returns() {
        return this.getPointXYZ().getNumberOfReturns();
    }

    public void setNumber_of_returns(byte number_of_returns) {
        this.getPointXYZ().setNumberOfReturns(number_of_returns);
    }

    public byte getScan_direction_flag() {
        return this.getPointXYZ().hasScanFlag(ScanFlag.ScanDirection) ? (byte)1 : 0;
    }

    public void setScan_direction_flag(byte scan_direction_flag) {
        this.getPointXYZ().setScanDirection(scan_direction_flag == 1);
    }

    public byte getEdge_of_flight_line() {
        return this.getPointXYZ().hasScanFlag(ScanFlag.EdgeOfFlightLine) ? (byte)1 : 0;
    }

    public void setEdge_of_flight_line(byte edge_of_flight_line) {
        this.getPointXYZ().setEdgeOfFlightLine(edge_of_flight_line == 1);
    }

    public short getClassification() {
        return this.getPointXYZ().Classification;
    }

    public void setClassification(short classification) {
        this.getPointXYZ().Classification = classification;
    }

    public byte getSynthetic_flag() {
        return this.getPointXYZ().hasClassificationFlag(ClassificationFlag.Synthetic) ? (byte)1 : 0;
    }

    public byte getKeypoint_flag() {
        return this.getPointXYZ().hasClassificationFlag(ClassificationFlag.KeyPoint) ? (byte)1 : 0;
    }

    public byte getWithheld_flag() {
        return this.getPointXYZ().hasClassificationFlag(ClassificationFlag.Withheld) ? (byte)1 : 0;
    }

    public void setWithheld_flag(boolean withheld) {
        this.getPointXYZ().setClassificationFlag(ClassificationFlag.Withheld, withheld);
    }

    public byte getOverlap_flag() {
        return this.getPointXYZ().hasClassificationFlag(ClassificationFlag.Overlap) ? (byte)1 : 0;
    }

    public byte getScan_angle_rank() {
        return this.getPointXYZ().getScanAngleRank();
    }

    public float getScan_angle() {
        return this.getPointXYZ().getScanAngle();
    }

    public short getUser_data() {
        return this.getPointXYZ().UserData;
    }

    public void setUser_data(short user_data) {
        this.getPointXYZ().UserData = user_data;
    }

    public char getPoint_source_ID() {
        return this.getPointXYZ().PointSourceID;
    }

    public void setPoint_source_ID(char point_source_ID) {
        this.getPointXYZ().PointSourceID = point_source_ID;
    }

    public boolean haveGpsTime() {
        return null != this.getGpsTimeProvider();
    }

    public double getGps_time() {
        return this.getGpsTimeProvider().getGpsTime();
    }

    public void setGps_time(double gps_time) {
        this.getGpsTimeProvider().setGpsTime(gps_time);
    }

    public char getRgb(int index) {
        PointDataRecordRGB rgbRecord = this.getPointRGB();
        switch (index) {
            case 0: {
                return rgbRecord.R;
            }
            case 1: {
                return rgbRecord.G;
            }
            case 2: {
                return rgbRecord.B;
            }
        }
        return '\u0000';
    }

    public char[] getRgb() {
        return this.getPointRGB().getRGB();
    }

    public void setRgb(int index, char value) {
        switch (index) {
            case 0: {
                this.getPointRGB().R = value;
                break;
            }
            case 1: {
                this.getPointRGB().G = value;
                break;
            }
            case 2: {
                this.getPointRGB().B = value;
                break;
            }
        }
    }

    public void setRgb(char[] rgb) {
        PointDataRecordRGB rgbRecord = this.getPointRGB();
        rgbRecord.R = rgb[0];
        rgbRecord.G = rgb[1];
        rgbRecord.B = rgb[2];
    }

    public boolean haveRgb() {
        return null != this.getPointRGB();
    }

    public boolean haveNIR() {
        return null != this.getPointRGBNIR();
    }

    public short getWavepacketDescriptorIndex() {
        PointDataRecordWavepacket wp = this.getWavepacket();
        return null == wp ? (short)0 : wp.DescriptorIndex;
    }

    public long getWavepacketOffsetToWaveformData() {
        return this.getWavepacket().OffsetToWaveformData;
    }

    public long getWavepacketPacketSize() {
        return this.getWavepacket().PacketSize;
    }

    public float getWavepacketReturnPointWaveformLocation() {
        return this.getWavepacket().ReturnPointWaveformLocation;
    }

    public float getWavepacketParametricDx() {
        return this.getWavepacket().ParametricDx;
    }

    public float getWavepacketParametricDy() {
        return this.getWavepacket().ParametricDy;
    }

    public float getWavepacketParametricDz() {
        return this.getWavepacket().ParametricDz;
    }

    public void setWavepacketOffsetToWaveformData(long offset) {
        this.getWavepacket().OffsetToWaveformData = offset;
    }

    public void setWavepacketPacketSize(long size) {
        this.getWavepacket().PacketSize = size;
    }

    public void setWavepacketReturnPointWaveformLocation(float val) {
        this.getWavepacket().ReturnPointWaveformLocation = val;
    }

    public void setWavepacketParametricDx(float val) {
        this.getWavepacket().ParametricDx = val;
    }

    public void setWavepacketParametricDy(float val) {
        this.getWavepacket().ParametricDy = val;
    }

    public void setWavepacketParametricDz(float val) {
        this.getWavepacket().ParametricDz = val;
    }

    public boolean haveWavepacket() {
        return null != this.getWavepacket();
    }

    public String toString() {
        String result = "";
        for (PointDataRecord r : this.PointRecords) {
            result = result + r.toString();
        }
        return result;
    }

    private PointDataRecord getPointDataRecord(Class<? extends PointDataRecord> ofThisType) {
        for (PointDataRecord r : this.PointRecords) {
            if (null == r || r.getClass() != ofThisType) continue;
            return r;
        }
        return null;
    }

    private PointDataRecordXYZBase getPointXYZ() {
        for (PointDataRecord r : this.PointRecords) {
            if (null == r || r.getClass() != PointDataRecordPoint14.class) continue;
            return (PointDataRecordXYZBase)r;
        }
        for (PointDataRecord r : this.PointRecords) {
            if (null == r || r.getClass() != PointDataRecordPoint10.class) continue;
            return (PointDataRecordXYZBase)r;
        }
        return null;
    }

    private PointDataRecordRGB getPointRGB() {
        for (PointDataRecord r : this.PointRecords) {
            if (null == r || r.getClass() != PointDataRecordRgbNIR.class) continue;
            return (PointDataRecordRGB)r;
        }
        for (PointDataRecord r : this.PointRecords) {
            if (null == r || r.getClass() != PointDataRecordRGB.class) continue;
            return (PointDataRecordRGB)r;
        }
        return null;
    }

    private PointDataRecordRgbNIR getPointRGBNIR() {
        for (PointDataRecord r : this.PointRecords) {
            if (null == r || r.getClass() != PointDataRecordRgbNIR.class) continue;
            return (PointDataRecordRgbNIR)r;
        }
        return null;
    }

    private IGpsTimeProvider getGpsTimeProvider() {
        for (PointDataRecord r : this.PointRecords) {
            if (null == r || !(r instanceof IGpsTimeProvider)) continue;
            return (IGpsTimeProvider)((Object)r);
        }
        return null;
    }

    private PointDataRecordWavepacket getWavepacket() {
        for (PointDataRecord r : this.PointRecords) {
            if (null == r || r.getClass() != PointDataRecordWavepacket.class) continue;
            return (PointDataRecordWavepacket)r;
        }
        return null;
    }

    private byte[] getExtraBytes() {
        PointDataRecord bytesRecord = this.getPointDataRecord(PointDataRecordBytes.class);
        return null == bytesRecord ? null : ((PointDataRecordBytes)bytesRecord).Bytes;
    }
}

