/*
 * Decompiled with CFR 0.152.
 */
package com.github.mreutegg.laszip4j.laszip;

import com.github.mreutegg.laszip4j.clib.Cstring;
import com.github.mreutegg.laszip4j.laszip.LASattribute;
import com.github.mreutegg.laszip4j.laszip.LASquantizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class LASattributer
extends LASquantizer {
    public int number_attributes;
    public List<LASattribute> attributes = new ArrayList<LASattribute>();
    public List<Integer> attribute_starts = new ArrayList<Integer>();
    public List<Integer> attribute_sizes = new ArrayList<Integer>();

    protected void clean_attributes() {
        if (this.number_attributes != 0) {
            this.number_attributes = 0;
            this.attributes.clear();
            this.attribute_starts.clear();
            this.attribute_sizes.clear();
        }
    }

    public boolean init_attributes(int number_attributes, LASattribute[] attributes) {
        this.clean_attributes();
        this.number_attributes = number_attributes;
        this.attributes = new ArrayList<LASattribute>(Arrays.asList(attributes));
        this.attribute_starts = new ArrayList<Integer>();
        this.attribute_sizes = new ArrayList<Integer>();
        this.attribute_starts.add(0);
        this.attribute_sizes.add(attributes[0].get_size());
        for (int i = 1; i < number_attributes; ++i) {
            this.attribute_starts.add(this.attribute_starts.get(i - 1) + this.attribute_sizes.get(i - 1));
            this.attribute_sizes.add(attributes[i].get_size());
        }
        return Boolean.TRUE;
    }

    public int add_attribute(LASattribute attribute) {
        if (attribute.get_size() != 0) {
            ++this.number_attributes;
            this.attributes.add(attribute);
            int priorStart = this.attribute_starts.size() > 1 ? this.attribute_starts.get(this.attribute_starts.size() - 2) : 0;
            int priorSize = this.attribute_sizes.size() > 1 ? this.attribute_sizes.get(this.attribute_sizes.size() - 2) : 0;
            this.attribute_starts.add(priorStart + priorSize);
            this.attribute_sizes.add(this.attributes.get(this.number_attributes - 1).get_size());
            return this.number_attributes - 1;
        }
        return -1;
    }

    short get_attributes_size() {
        return (short)(!this.attributes.isEmpty() ? this.attribute_starts.get(this.number_attributes - 1) + this.attribute_sizes.get(this.number_attributes - 1) : 0);
    }

    public int get_attribute_index(String name) {
        for (int i = 0; i < this.number_attributes; ++i) {
            if (Cstring.strcmp(this.attributes.get((int)i).name, name) != 0) continue;
            return i;
        }
        return -1;
    }

    int get_attribute_start(String name) {
        for (int i = 0; i < this.number_attributes; ++i) {
            if (Cstring.strcmp(this.attributes.get((int)i).name, name) != 0) continue;
            return this.attribute_starts.get(i);
        }
        return -1;
    }

    public int get_attribute_start(int index) {
        if (index < this.number_attributes) {
            return this.attribute_starts.get(index);
        }
        return -1;
    }

    int get_attribute_size(int index) {
        if (index < this.number_attributes) {
            return this.attribute_sizes.get(index);
        }
        return -1;
    }

    public boolean remove_attribute(int index) {
        if (index < 0 || index >= this.number_attributes) {
            return Boolean.FALSE;
        }
        ++index;
        while (index < this.number_attributes) {
            this.attributes.set(index - 1, this.attributes.get(index));
            if (index > 1) {
                this.attribute_starts.set(index - 1, this.attribute_starts.get(index - 2) + this.attribute_sizes.get(index - 2));
            } else {
                this.attribute_starts.set(index - 1, 0);
            }
            this.attribute_sizes.set(index - 1, this.attribute_sizes.get(index));
            ++index;
        }
        --this.number_attributes;
        return Boolean.TRUE;
    }

    boolean remove_attribute(String name) {
        int index = this.get_attribute_index(name);
        if (index != -1) {
            return this.remove_attribute(index);
        }
        return Boolean.FALSE;
    }
}

