/*
 * Decompiled with CFR 0.152.
 */
package com.github.mreutegg.laszip4j.laszip;

import com.github.mreutegg.laszip4j.laszip.ByteStreamOut;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class ByteStreamOutArray
extends ByteStreamOut {
    private ByteBuffer data;
    private int size;

    public ByteStreamOutArray() {
        this(1024L);
    }

    public ByteStreamOutArray(long alloc) {
        if (alloc > Integer.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        this.data = ByteBuffer.allocate((int)alloc);
        this.data.order(ByteOrder.LITTLE_ENDIAN);
        this.size = 0;
    }

    @Override
    public boolean putByte(byte b) {
        this.ensureCapacity(1);
        this.data.put(b);
        this.updateSize();
        return true;
    }

    @Override
    public boolean putBytes(byte[] bytes, int u_num_bytes) {
        this.ensureCapacity(u_num_bytes);
        this.data.put(bytes, 0, u_num_bytes);
        this.updateSize();
        return true;
    }

    @Override
    public boolean isSeekable() {
        return true;
    }

    @Override
    public long tell() {
        return this.data.position();
    }

    @Override
    public boolean seek(long position) {
        if (position > Integer.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        if (0L <= position && position <= (long)this.size) {
            this.data.position((int)position);
            return true;
        }
        return false;
    }

    @Override
    public boolean seekEnd() {
        this.data.position(this.size);
        return true;
    }

    @Override
    public boolean put16bitsLE(char bytes) {
        this.ensureCapacity(2);
        this.data.putChar(bytes);
        this.updateSize();
        return true;
    }

    @Override
    public boolean put16bitsLE(short bytes) {
        this.ensureCapacity(2);
        this.data.putShort(bytes);
        this.updateSize();
        return true;
    }

    @Override
    public boolean put32bitsLE(int bytes) {
        this.ensureCapacity(4);
        this.data.putInt(bytes);
        this.updateSize();
        return true;
    }

    @Override
    public boolean put64bitsLE(long bytes) {
        this.ensureCapacity(8);
        this.data.putLong(bytes);
        this.updateSize();
        return true;
    }

    @Override
    boolean put16bitsBE(char bytes) {
        this.ensureCapacity(2);
        this.data.order(ByteOrder.BIG_ENDIAN);
        try {
            this.data.putChar(bytes);
        }
        finally {
            this.data.order(ByteOrder.LITTLE_ENDIAN);
        }
        this.updateSize();
        return true;
    }

    @Override
    boolean put32bitsBE(int bytes) {
        this.ensureCapacity(4);
        this.data.order(ByteOrder.BIG_ENDIAN);
        try {
            this.data.putInt(bytes);
        }
        finally {
            this.data.order(ByteOrder.LITTLE_ENDIAN);
        }
        this.updateSize();
        return true;
    }

    @Override
    boolean put64bitsBE(long bytes) {
        this.ensureCapacity(8);
        this.data.order(ByteOrder.BIG_ENDIAN);
        try {
            this.data.putLong(bytes);
        }
        finally {
            this.data.order(ByteOrder.LITTLE_ENDIAN);
        }
        this.updateSize();
        return true;
    }

    @Override
    public void close() {
    }

    private void ensureCapacity(int u_num_bytes) {
        if (this.data.remaining() < u_num_bytes) {
            this.data = ByteStreamOutArray.realloc(this.data, this.data.capacity() + Math.max(u_num_bytes, 1024));
        }
    }

    private void updateSize() {
        this.size = Math.max(this.size, this.data.position());
    }

    private static ByteBuffer realloc(ByteBuffer data, int u_num_bytes) {
        byte[] array = data.array();
        if (array.length < u_num_bytes) {
            byte[] newArray = new byte[u_num_bytes];
            System.arraycopy(array, 0, newArray, 0, array.length);
            array = newArray;
        }
        ByteBuffer newBuffer = ByteBuffer.wrap(array);
        newBuffer.position(data.position());
        newBuffer.order(data.order());
        return newBuffer;
    }

    protected long getSize() {
        return this.size;
    }

    protected ByteBuffer getData() {
        return this.data;
    }

    public ByteBuffer takeData() {
        ByteBuffer d = this.data;
        this.data = ByteBuffer.allocate(0).order(d.order());
        this.size = 0;
        return d;
    }
}

