/*
 * Decompiled with CFR 0.152.
 */
package com.github.mreutegg.laszip4j.lastools;

import com.github.mreutegg.laszip4j.clib.Cstdio;
import com.github.mreutegg.laszip4j.clib.Cstdlib;
import com.github.mreutegg.laszip4j.clib.Cstring;
import com.github.mreutegg.laszip4j.laslib.LASreadOpener;
import com.github.mreutegg.laszip4j.laslib.LASreader;
import com.github.mreutegg.laszip4j.laslib.LASvlr_key_entry;
import com.github.mreutegg.laszip4j.laslib.LASwaveform13reader;
import com.github.mreutegg.laszip4j.laslib.LASwaveform13writer;
import com.github.mreutegg.laszip4j.laslib.LASwriteOpener;
import com.github.mreutegg.laszip4j.laslib.LASwriter;
import com.github.mreutegg.laszip4j.lastools.GeoProjectionConverter;
import com.github.mreutegg.laszip4j.lastools.GeoProjectionGeoKeys;
import com.github.mreutegg.laszip4j.lastools.OffsetSize;
import com.github.mreutegg.laszip4j.laszip.ByteStreamIn;
import com.github.mreutegg.laszip4j.laszip.LASindex;
import com.github.mreutegg.laszip4j.laszip.LASquadtree;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.HashMap;

public class Laszip {
    public static void main(String[] args) {
        Laszip.run(args);
        Laszip.byebye(false);
    }

    public static void run(String[] args) {
        int i;
        String[] argv = new String[args.length + 1];
        argv[0] = "laszip";
        System.arraycopy(args, 0, argv, 1, args.length);
        int argc = argv.length;
        PrintStream stderr = System.err;
        boolean dry = false;
        boolean verbose = false;
        boolean waveform = false;
        boolean waveform_with_map = false;
        boolean report_file_size = false;
        boolean check_integrity = false;
        int end_of_points = -1;
        boolean projection_was_set = false;
        boolean format_not_specified = false;
        boolean lax = false;
        boolean append = false;
        float tile_size = 100.0f;
        int threshold = 1000;
        int minimum_points = 100000;
        int maximum_intervals = -20;
        double start_time = 0.0;
        double total_start_time = 0.0;
        LASreadOpener lasreadopener = new LASreadOpener();
        GeoProjectionConverter geoprojectionconverter = new GeoProjectionConverter();
        LASwriteOpener laswriteopener = new LASwriteOpener();
        if (argc == 1) {
            System.err.println("missing argument");
            System.exit(1);
        } else {
            if (!geoprojectionconverter.parse(argc, argv)) {
                Laszip.byebye(true);
            }
            if (!lasreadopener.parse(argc, argv)) {
                Laszip.byebye(true);
            }
            if (!laswriteopener.parse(argc, argv)) {
                Laszip.byebye(true);
            }
        }
        for (i = 1; i < argc; ++i) {
            if (argv[i].isEmpty() || argv[i].charAt(0) == '\u0000') continue;
            if (Cstring.strcmp(argv[i], "-h") == 0 || Cstring.strcmp(argv[i], "-help") == 0) {
                Cstdio.fprintf(stderr, "LAStools (by martin@rapidlasso.com) version %d\n", 220310);
                Laszip.usage();
                continue;
            }
            if (Cstring.strcmp(argv[i], "-v") == 0 || Cstring.strcmp(argv[i], "-verbose") == 0) {
                verbose = Boolean.TRUE;
                continue;
            }
            if (Cstring.strcmp(argv[i], "-version") == 0) {
                Cstdio.fprintf(stderr, "LAStools (by martin@rapidlasso.com) version %d\n", 220310);
                Laszip.byebye();
                continue;
            }
            if (Cstring.strcmp(argv[i], "-gui") == 0) {
                Cstdio.fprintf(stderr, "WARNING: not compiled with GUI support. ignoring '-gui' ...\n", new Object[0]);
                continue;
            }
            if (Cstring.strcmp(argv[i], "-cores") == 0) {
                Cstdio.fprintf(stderr, "WARNING: not compiled with multi-core batching. ignoring '-cores' ...\n", new Object[0]);
                ++i;
                continue;
            }
            if (Cstring.strcmp(argv[i], "-dry") == 0) {
                dry = Boolean.TRUE;
                continue;
            }
            if (Cstring.strcmp(argv[i], "-lax") == 0) {
                lax = Boolean.TRUE;
                continue;
            }
            if (Cstring.strcmp(argv[i], "-append") == 0) {
                append = Boolean.TRUE;
                continue;
            }
            if (Cstring.strcmp(argv[i], "-eop") == 0) {
                if (i + 1 >= argc) {
                    Cstdio.fprintf(stderr, "ERROR: '%s' needs 1 argument: char\n", argv[i]);
                    Laszip.usage(true);
                }
                if ((end_of_points = Cstdlib.atoi(argv[++i])) >= 0 && end_of_points <= 255) continue;
                Cstdio.fprintf(stderr, "ERROR: end of points value needs to be between 0 and 255\n", new Object[0]);
                Laszip.usage(true);
                continue;
            }
            if (Cstring.strcmp(argv[i], "-tile_size") == 0) {
                if (i + 1 >= argc) {
                    Cstdio.fprintf(stderr, "ERROR: '%s' needs 1 argument: size\n", argv[i]);
                    Laszip.usage(true);
                }
                tile_size = (float)Cstdlib.atof(argv[++i]);
                continue;
            }
            if (Cstring.strcmp(argv[i], "-maximum") == 0) {
                if (i + 1 >= argc) {
                    Cstdio.fprintf(stderr, "ERROR: '%s' needs 1 argument: number\n", argv[i]);
                    Laszip.usage(true);
                }
                maximum_intervals = Cstdlib.atoi(argv[++i]);
                continue;
            }
            if (Cstring.strcmp(argv[i], "-minimum") == 0) {
                if (i + 1 >= argc) {
                    Cstdio.fprintf(stderr, "ERROR: '%s' needs 1 argument: number\n", argv[i]);
                    Laszip.usage(true);
                }
                minimum_points = Cstdlib.atoi(argv[++i]);
                continue;
            }
            if (Cstring.strcmp(argv[i], "-threshold") == 0) {
                if (i + 1 >= argc) {
                    Cstdio.fprintf(stderr, "ERROR: '%s' needs 1 argument: value\n", argv[i]);
                    Laszip.usage(true);
                }
                threshold = Cstdlib.atoi(argv[++i]);
                continue;
            }
            if (Cstring.strcmp(argv[i], "-size") == 0) {
                report_file_size = true;
                continue;
            }
            if (Cstring.strcmp(argv[i], "-check") == 0) {
                check_integrity = true;
                continue;
            }
            if (Cstring.strcmp(argv[i], "-waveform") == 0 || Cstring.strcmp(argv[i], "-waveforms") == 0) {
                waveform = true;
                continue;
            }
            if (Cstring.strcmp(argv[i], "-waveform_with_map") == 0 || Cstring.strcmp(argv[i], "-waveforms_with_map") == 0) {
                waveform = true;
                waveform_with_map = true;
                continue;
            }
            if (argv[i].charAt(0) != '-' && lasreadopener.get_file_name_number() == 0) {
                lasreadopener.add_file_name(argv[i]);
                argv[i] = "\u0000";
                continue;
            }
            Cstdio.fprintf(stderr, "ERROR: cannot understand argument '%s'\n", argv[i]);
            Laszip.usage(true);
        }
        if (!lasreadopener.active()) {
            Cstdio.fprintf(stderr, "ERROR: no input specified\n", new Object[0]);
            Laszip.usage(true);
        }
        if (laswriteopener.is_piped() && lax) {
            Cstdio.fprintf(stderr, "WARNING: disabling LAX generation for piped output\n", new Object[0]);
            lax = Boolean.FALSE;
            append = Boolean.FALSE;
        }
        if (lasreadopener.get_file_name() != null && laswriteopener.get_file_name() != null && Cstring.strcmp(lasreadopener.get_file_name(), laswriteopener.get_file_name()) == 0) {
            Cstdio.fprintf(stderr, "ERROR: input and output file name are identical\n", new Object[0]);
            Laszip.usage(true);
        }
        int number_of_keys = 0;
        LASvlr_key_entry[] geo_keys = null;
        int num_geo_double_params = 0;
        double[] geo_double_params = null;
        if (geoprojectionconverter.has_projection()) {
            projection_was_set = geoprojectionconverter.get_geo_keys_from_projection(number_of_keys, (GeoProjectionGeoKeys[])geo_keys, num_geo_double_params, geo_double_params);
        }
        boolean bl = format_not_specified = !laswriteopener.format_was_specified();
        if (verbose) {
            total_start_time = Laszip.taketime();
        }
        while (lasreadopener.active()) {
            LASreader lasreader;
            if (verbose) {
                start_time = Laszip.taketime();
            }
            if ((lasreader = lasreadopener.open()) == null) {
                Cstdio.fprintf(stderr, "ERROR: could not open lasreader\n", new Object[0]);
                Laszip.usage(true);
            }
            if (report_file_size) {
                long uncompressed_file_size = lasreader.npoints * (long)lasreader.header.point_data_record_length + (long)lasreader.header.offset_to_point_data;
                if (uncompressed_file_size < Integer.MAX_VALUE) {
                    Cstdio.fprintf(stderr, "uncompressed file size is %d bytes or %.2f MB for '%s'\n", uncompressed_file_size, (double)uncompressed_file_size / 1024.0 / 1024.0, lasreadopener.get_file_name());
                } else {
                    Cstdio.fprintf(stderr, "uncompressed file size is %.2f MB or %.2f GB for '%s'\n", (double)uncompressed_file_size / 1024.0 / 1024.0, (double)uncompressed_file_size / 1024.0 / 1024.0 / 1024.0, lasreadopener.get_file_name());
                }
            } else if (dry || check_integrity) {
                start_time = Laszip.taketime();
                while (lasreader.read_point()) {
                }
                if (check_integrity) {
                    if (lasreader.p_count != lasreader.npoints) {
                        Cstdio.fprintf(stderr, "FAILED integrity check for '%s' after %lld of %lld points\n", lasreadopener.get_file_name(), lasreader.p_count, lasreader.npoints);
                    } else {
                        Cstdio.fprintf(stderr, "SUCCESS for '%s'\n", lasreadopener.get_file_name());
                    }
                } else {
                    Cstdio.fprintf(stderr, "needed %g secs to read '%s'\n", Laszip.taketime() - start_time, lasreadopener.get_file_name());
                }
            } else {
                long start_of_waveform_data_packet_record = 0L;
                if (!laswriteopener.active()) {
                    if (lasreadopener.get_file_name() == null) {
                        Cstdio.fprintf(stderr, "ERROR: no output specified\n", new Object[0]);
                        Laszip.usage(true);
                    }
                    laswriteopener.set_force(Boolean.TRUE);
                    if (format_not_specified) {
                        if (lasreader.get_format() == 2) {
                            laswriteopener.set_format(1);
                        } else {
                            laswriteopener.set_format(2);
                        }
                    }
                    laswriteopener.make_file_name(lasreadopener.get_file_name(), -2);
                }
                if (projection_was_set) {
                    lasreader.header.set_geo_keys(number_of_keys, geo_keys);
                    if (geo_double_params != null) {
                        lasreader.header.set_geo_double_params(num_geo_double_params, geo_double_params);
                    } else {
                        lasreader.header.del_geo_double_params();
                    }
                    lasreader.header.del_geo_ascii_params();
                }
                LASwaveform13reader laswaveform13reader = null;
                LASwaveform13writer laswaveform13writer = null;
                if (waveform) {
                    laswaveform13reader = lasreadopener.open_waveform13(lasreader.header);
                    if (laswaveform13reader != null) {
                        byte compression_type = (byte)(laswriteopener.get_format() == 2 ? 1 : 0);
                        for (i = 0; i < 255; ++i) {
                            if (lasreader.header.vlr_wave_packet_descr[i] == null) continue;
                            lasreader.header.vlr_wave_packet_descr[i].setCompressionType(compression_type);
                        }
                        laswaveform13writer = laswriteopener.open_waveform13(lasreader.header);
                        if (laswaveform13writer == null) {
                            laswaveform13reader = null;
                            waveform = false;
                            compression_type = (byte)(laswriteopener.get_format() != 2 ? 1 : 0);
                            for (i = 0; i < 255; ++i) {
                                if (lasreader.header.vlr_wave_packet_descr[i] == null) continue;
                                lasreader.header.vlr_wave_packet_descr[i].setCompressionType(compression_type);
                            }
                        }
                    } else {
                        waveform = false;
                    }
                }
                if (lasreader.header.version_major == 1 && lasreader.header.version_minor >= 3 && (lasreader.header.global_encoding & 2) != 0) {
                    lasreader.header.global_encoding = (char)(lasreader.header.global_encoding & 0xFFFFFFFD);
                    if (lasreader.header.start_of_waveform_data_packet_record != 0L) {
                        start_of_waveform_data_packet_record = lasreader.header.start_of_waveform_data_packet_record;
                        lasreader.header.start_of_waveform_data_packet_record = 0L;
                        lasreader.header.global_encoding = (char)(lasreader.header.global_encoding | 4);
                    }
                }
                long bytes_written = 0L;
                LASwriter laswriter = laswriteopener.open(lasreader.header);
                if (laswriter == null) {
                    Cstdio.fprintf(stderr, "ERROR: could not open laswriter\n", new Object[0]);
                    Laszip.usage(true);
                }
                if (waveform) {
                    byte compression_type = (byte)(laswaveform13reader.is_compressed() ? 1 : 0);
                    for (i = 0; i < 255; ++i) {
                        if (lasreader.header.vlr_wave_packet_descr[i] == null) continue;
                        lasreader.header.vlr_wave_packet_descr[i].setCompressionType(compression_type);
                    }
                    long u_last_offset = 0L;
                    long u_last_size = 60L;
                    long u_new_offset = 0L;
                    long u_new_size = 0L;
                    int u_waves_written = 0;
                    int u_waves_referenced = 0;
                    HashMap<Long, OffsetSize> offset_size_map = new HashMap<Long, OffsetSize>();
                    LASindex lasindex = new LASindex();
                    if (lax) {
                        LASquadtree lasquadtree = new LASquadtree();
                        lasquadtree.setup(lasreader.header.min_x, lasreader.header.max_x, lasreader.header.min_y, lasreader.header.max_y, tile_size);
                        lasindex.prepare(lasquadtree, threshold);
                    }
                    while (lasreader.read_point()) {
                        if (lasreader.point.getWavepacketDescriptorIndex() != 0) {
                            ++u_waves_referenced;
                            if (lasreader.point.getWavepacketOffsetToWaveformData() == u_last_offset) {
                                lasreader.point.setWavepacketOffsetToWaveformData(u_new_offset);
                                lasreader.point.setWavepacketPacketSize(u_new_size);
                            } else if (lasreader.point.getWavepacketOffsetToWaveformData() > u_last_offset) {
                                if (lasreader.point.getWavepacketOffsetToWaveformData() > u_last_offset + u_last_size && !waveform_with_map) {
                                    Cstdio.fprintf(stderr, "WARNING: gap in waveform offsets.\n", new Object[0]);
                                    Cstdio.fprintf(stderr, "WARNING: last offset plus size was %lld but new offset is %lld (for point %lld)\n", u_last_offset + u_last_size, lasreader.point.getWavepacketOffsetToWaveformData(), lasreader.p_count);
                                }
                                ++u_waves_written;
                                u_last_offset = lasreader.point.getWavepacketOffsetToWaveformData();
                                u_last_size = lasreader.point.getWavepacketPacketSize();
                                laswaveform13reader.read_waveform(lasreader.point);
                                laswaveform13writer.write_waveform(lasreader.point, laswaveform13reader.samples);
                                u_new_offset = lasreader.point.getWavepacketOffsetToWaveformData();
                                u_new_size = lasreader.point.getWavepacketPacketSize();
                                if (waveform_with_map) {
                                    offset_size_map.put(u_last_offset, new OffsetSize((int)u_new_offset, (int)u_new_size));
                                }
                            } else if (waveform_with_map) {
                                OffsetSize map_element = (OffsetSize)offset_size_map.get(lasreader.point.getWavepacketOffsetToWaveformData());
                                if (map_element == null) {
                                    ++u_waves_written;
                                    u_last_offset = lasreader.point.getWavepacketOffsetToWaveformData();
                                    u_last_size = lasreader.point.getWavepacketPacketSize();
                                    laswaveform13reader.read_waveform(lasreader.point);
                                    laswaveform13writer.write_waveform(lasreader.point, laswaveform13reader.samples);
                                    u_new_offset = lasreader.point.getWavepacketOffsetToWaveformData();
                                    u_new_size = lasreader.point.getWavepacketPacketSize();
                                    offset_size_map.put(u_last_offset, new OffsetSize((int)u_new_offset, (int)u_new_size));
                                } else {
                                    lasreader.point.setWavepacketOffsetToWaveformData(map_element.offset);
                                    lasreader.point.setWavepacketPacketSize(map_element.size);
                                }
                            } else {
                                Cstdio.fprintf(stderr, "ERROR: waveform offsets not in monotonically increasing order.\n", new Object[0]);
                                Cstdio.fprintf(stderr, "ERROR: last offset was %lld but new offset is %lld (for point %lld)\n", u_last_offset, lasreader.point.getWavepacketOffsetToWaveformData(), lasreader.p_count);
                                Cstdio.fprintf(stderr, "ERROR: use option '-waveforms_with_map' to compress.\n", new Object[0]);
                                Laszip.byebye(true);
                            }
                        }
                        if (null != laswriter) {
                            laswriter.write_point(lasreader.point);
                        }
                        if (lax) {
                            lasindex.add(lasreader.point.get_x(), lasreader.point.get_y(), (int)laswriter.p_count);
                        }
                        if (lasreadopener.is_header_populated()) continue;
                        laswriter.update_inventory(lasreader.point);
                    }
                    if (null != laswriter) {
                        if (verbose && laswriter.p_count % 1000000L == 0L) {
                            Cstdio.fprintf(stderr, "written %d referenced %d of %d points\n", u_waves_written, u_waves_referenced, laswriter.p_count);
                        }
                        if (!lasreadopener.is_header_populated()) {
                            laswriter.update_header(lasreader.header, Boolean.TRUE);
                        }
                        bytes_written = laswriter.close();
                    }
                    if (lax) {
                        lasindex.complete(minimum_points, maximum_intervals);
                        if (append) {
                            lasindex.append(laswriteopener.get_file_name());
                        } else {
                            lasindex.write(laswriteopener.get_file_name());
                        }
                    }
                } else if (lasreadopener.is_header_populated()) {
                    if (lax) {
                        LASquadtree lasquadtree = new LASquadtree();
                        lasquadtree.setup(lasreader.header.min_x, lasreader.header.max_x, lasreader.header.min_y, lasreader.header.max_y, tile_size);
                        LASindex lasindex = new LASindex();
                        lasindex.prepare(lasquadtree, threshold);
                        while (lasreader.read_point()) {
                            lasindex.add(lasreader.point.get_x(), lasreader.point.get_y(), (int)laswriter.p_count);
                            laswriter.write_point(lasreader.point);
                        }
                        bytes_written = laswriter.close();
                        lasindex.complete(minimum_points, maximum_intervals);
                        if (append) {
                            lasindex.append(laswriteopener.get_file_name());
                        } else {
                            lasindex.write(laswriteopener.get_file_name());
                        }
                    } else {
                        if (end_of_points > -1) {
                            if (verbose) {
                                Cstdio.fprintf(stderr, "writing with end_of_points value %d\n", end_of_points);
                            }
                            while (lasreader.read_point()) {
                                if (null == laswriter) continue;
                                laswriter.write_point(lasreader.point);
                                laswriter.update_inventory(lasreader.point);
                            }
                            if (null != laswriter) {
                                laswriter.update_header(lasreader.header, Boolean.TRUE);
                            }
                        } else {
                            while (lasreader.read_point()) {
                                if (null == laswriter) continue;
                                laswriter.write_point(lasreader.point);
                            }
                        }
                        if (null != laswriter) {
                            bytes_written = laswriter.close();
                        }
                    }
                } else {
                    if (lax && lasreader.header.min_x < lasreader.header.max_x && lasreader.header.min_y < lasreader.header.max_y) {
                        LASquadtree lasquadtree = new LASquadtree();
                        lasquadtree.setup(lasreader.header.min_x, lasreader.header.max_x, lasreader.header.min_y, lasreader.header.max_y, tile_size);
                        LASindex lasindex = new LASindex();
                        lasindex.prepare(lasquadtree, threshold);
                        while (lasreader.read_point()) {
                            lasindex.add(lasreader.point.get_x(), lasreader.point.get_y(), (int)laswriter.p_count);
                            laswriter.write_point(lasreader.point);
                            laswriter.update_inventory(lasreader.point);
                        }
                        bytes_written = laswriter.close();
                        lasindex.complete(minimum_points, maximum_intervals);
                        if (append) {
                            lasindex.append(laswriteopener.get_file_name());
                        } else {
                            lasindex.write(laswriteopener.get_file_name());
                        }
                    } else if (end_of_points > -1) {
                        if (verbose) {
                            Cstdio.fprintf(stderr, "writing with end_of_points value %d\n", end_of_points);
                        }
                        while (lasreader.read_point()) {
                            if (null == laswriter) continue;
                            laswriter.write_point(lasreader.point);
                            laswriter.update_inventory(lasreader.point);
                        }
                    } else {
                        while (lasreader.read_point()) {
                            if (null == laswriter) continue;
                            laswriter.write_point(lasreader.point);
                            laswriter.update_inventory(lasreader.point);
                        }
                    }
                    if (null != laswriter) {
                        laswriter.update_header(lasreader.header, Boolean.TRUE);
                        bytes_written = laswriter.close();
                    }
                }
                if (verbose) {
                    Cstdio.fprintf(stderr, "%g secs to write %lld bytes for '%s' with %lld points of type %d\n", Laszip.taketime() - start_time, bytes_written, laswriteopener.get_file_name(), lasreader.p_count, lasreader.header.point_data_format);
                }
                if (start_of_waveform_data_packet_record != 0L && !waveform) {
                    char[] wave_form_file_name;
                    lasreader.close(Boolean.FALSE);
                    ByteStreamIn stream = lasreader.get_stream();
                    stream.seek(start_of_waveform_data_packet_record);
                    if (laswriteopener.get_file_name() != null) {
                        int len;
                        wave_form_file_name = laswriteopener.get_file_name().toCharArray();
                        if (wave_form_file_name[(len = wave_form_file_name.length) - 3] == 'L') {
                            wave_form_file_name[len - 3] = 87;
                            wave_form_file_name[len - 2] = 68;
                            wave_form_file_name[len - 1] = 80;
                        } else {
                            wave_form_file_name[len - 3] = 119;
                            wave_form_file_name[len - 2] = 100;
                            wave_form_file_name[len - 1] = 112;
                        }
                    } else {
                        wave_form_file_name = "wave_form.wdp".toCharArray();
                    }
                    OutputStream file = Cstdio.fopen(wave_form_file_name, "wb");
                    if (file != null) {
                        if (verbose) {
                            Cstdio.fprintf(stderr, "writing waveforms to '%s'\n", new String(wave_form_file_name));
                        }
                        try {
                            while (true) {
                                byte b = stream.getByte();
                                Cstdio.fputc(b, file);
                            }
                        }
                        catch (Exception e) {
                            Cstdio.fclose(file);
                        }
                    }
                }
                laswriteopener.set_file_name(null);
                if (format_not_specified) {
                    laswriteopener.set_format(0);
                }
            }
            lasreader.close();
        }
        if (verbose && lasreadopener.get_file_name_number() > 1) {
            Cstdio.fprintf(stderr, "needed %g sec for %d files\n", Laszip.taketime() - total_start_time, lasreadopener.get_file_name_number());
        }
    }

    private static double taketime() {
        return System.currentTimeMillis() / 1000L;
    }

    private static void usage() {
        Laszip.usage(false);
    }

    private static void usage(boolean error) {
        PrintStream stderr = System.err;
        Cstdio.fprintf(stderr, "usage:\n", new Object[0]);
        Cstdio.fprintf(stderr, "laszip *.las\n", new Object[0]);
        Cstdio.fprintf(stderr, "laszip *.laz\n", new Object[0]);
        Cstdio.fprintf(stderr, "laszip *.txt -iparse xyztiarn\n", new Object[0]);
        Cstdio.fprintf(stderr, "laszip lidar.las\n", new Object[0]);
        Cstdio.fprintf(stderr, "laszip lidar.laz -v\n", new Object[0]);
        Cstdio.fprintf(stderr, "laszip -i lidar.las -o lidar_zipped.laz\n", new Object[0]);
        Cstdio.fprintf(stderr, "laszip -i lidar.laz -o lidar_unzipped.las\n", new Object[0]);
        Cstdio.fprintf(stderr, "laszip -i lidar.las -stdout -olaz > lidar.laz\n", new Object[0]);
        Cstdio.fprintf(stderr, "laszip -stdin -o lidar.laz < lidar.las\n", new Object[0]);
        Cstdio.fprintf(stderr, "laszip -h\n", new Object[0]);
        Laszip.byebye(error);
    }

    private static void byebye() {
        Laszip.byebye(false);
    }

    private static void byebye(boolean error) {
        System.exit(error ? 1 : 0);
    }
}

