/*
 * Decompiled with CFR 0.152.
 */
package com.github.mreutegg.laszip4j.laslib;

import com.github.mreutegg.laszip4j.laslib.LASfilter;
import com.github.mreutegg.laszip4j.laslib.LASheader;
import com.github.mreutegg.laszip4j.laslib.LAStransform;
import com.github.mreutegg.laszip4j.laszip.ByteStreamIn;
import com.github.mreutegg.laszip4j.laszip.LASindex;
import com.github.mreutegg.laszip4j.laszip.LASpoint;
import java.io.Closeable;
import java.util.concurrent.Callable;

public abstract class LASreader
implements Closeable {
    public LASheader header = new LASheader();
    public LASpoint point = new LASpoint();
    public long npoints = 0L;
    public long p_count = 0L;
    protected LASindex index = null;
    protected LASfilter filter = null;
    protected LAStransform transform = null;
    protected int inside = 0;
    protected float t_ll_x = 0.0f;
    protected float t_ll_y = 0.0f;
    protected float t_size = 0.0f;
    protected float t_ur_x = 0.0f;
    protected float t_ur_y = 0.0f;
    protected double c_center_x = 0.0;
    protected double c_center_y = 0.0;
    protected double c_radius = 0.0;
    protected double c_radius_squared = 0.0;
    protected double r_min_x = 0.0;
    protected double r_min_y = 0.0;
    protected double r_max_x = 0.0;
    protected double r_max_y = 0.0;
    protected double orig_min_x = 0.0;
    protected double orig_min_y = 0.0;
    protected double orig_max_x = 0.0;
    protected double orig_max_y = 0.0;
    private Callable<Boolean> read_simple = this::read_point_default;
    private Callable<Boolean> read_complex = null;

    LASreader() {
    }

    public void set_index(LASindex index) {
        this.index = index;
    }

    public void set_filter(LASfilter filter) {
        this.filter = filter;
        this.read_simple = filter != null && this.transform != null ? this::read_point_filtered_and_transformed : (filter != null ? this::read_point_filtered : (this.transform != null ? this::read_point_transformed : this::read_point_default));
        this.read_complex = this::read_point_default;
    }

    public void set_transform(LAStransform transform) {
        this.transform = transform;
        this.read_simple = this.filter != null && transform != null ? this::read_point_filtered_and_transformed : (this.filter != null ? this::read_point_filtered : (transform != null ? this::read_point_transformed : this::read_point_default));
        this.read_complex = this::read_point_default;
    }

    public boolean inside_none() {
        if (this.filter != null || this.transform != null) {
            this.read_complex = this::read_point_default;
        } else {
            this.read_simple = this::read_point_default;
        }
        if (this.inside != 0) {
            this.header.min_x = this.orig_min_x;
            this.header.min_y = this.orig_min_y;
            this.header.max_x = this.orig_max_x;
            this.header.max_y = this.orig_max_y;
            this.inside = 0;
        }
        return Boolean.TRUE;
    }

    public boolean inside_tile(float ll_x, float ll_y, float size) {
        this.inside = 1;
        this.t_ll_x = ll_x;
        this.t_ll_y = ll_y;
        this.t_size = size;
        this.t_ur_x = ll_x + size;
        this.t_ur_y = ll_y + size;
        this.orig_min_x = this.header.min_x;
        this.orig_min_y = this.header.min_y;
        this.orig_max_x = this.header.max_x;
        this.orig_max_y = this.header.max_y;
        this.header.min_x = ll_x;
        this.header.min_y = ll_y;
        this.header.max_x = ll_x + size;
        this.header.max_y = ll_y + size;
        this.header.max_x -= this.header.x_scale_factor;
        this.header.max_y -= this.header.y_scale_factor;
        if (this.orig_min_x > this.header.max_x || this.orig_min_y > this.header.max_y || this.orig_max_x < this.header.min_x || this.orig_max_y < this.header.min_y) {
            if (this.filter != null || this.transform != null) {
                this.read_complex = this::read_point_none;
            } else {
                this.read_simple = this::read_point_none;
            }
        } else if (this.filter != null || this.transform != null) {
            if (this.index != null) {
                this.index.intersect_tile(ll_x, ll_y, size);
                this.read_complex = this::read_point_inside_tile_indexed;
            } else {
                this.read_complex = this::read_point_inside_tile;
            }
        } else if (this.index != null) {
            this.index.intersect_tile(ll_x, ll_y, size);
            this.read_simple = this::read_point_inside_tile_indexed;
        } else {
            this.read_simple = this::read_point_inside_tile;
        }
        return Boolean.TRUE;
    }

    public boolean inside_circle(double center_x, double center_y, double radius) {
        this.inside = 2;
        this.c_center_x = center_x;
        this.c_center_y = center_y;
        this.c_radius = radius;
        this.c_radius_squared = radius * radius;
        this.orig_min_x = this.header.min_x;
        this.orig_min_y = this.header.min_y;
        this.orig_max_x = this.header.max_x;
        this.orig_max_y = this.header.max_y;
        this.header.min_x = center_x - radius;
        this.header.min_y = center_y - radius;
        this.header.max_x = center_x + radius;
        this.header.max_y = center_y + radius;
        if (this.orig_min_x > this.header.max_x || this.orig_min_y > this.header.max_y || this.orig_max_x < this.header.min_x || this.orig_max_y < this.header.min_y) {
            if (this.filter != null || this.transform != null) {
                this.read_complex = this::read_point_none;
            } else {
                this.read_simple = this::read_point_none;
            }
        } else if (this.filter != null || this.transform != null) {
            if (this.index != null) {
                this.index.intersect_circle(center_x, center_y, radius);
                this.read_complex = this::read_point_inside_circle_indexed;
            } else {
                this.read_complex = this::read_point_inside_circle;
            }
        } else if (this.index != null) {
            this.index.intersect_circle(center_x, center_y, radius);
            this.read_simple = this::read_point_inside_circle_indexed;
        } else {
            this.read_simple = this::read_point_inside_circle;
        }
        return Boolean.TRUE;
    }

    public boolean inside_rectangle(double min_x, double min_y, double max_x, double max_y) {
        this.inside = 3;
        this.r_min_x = min_x;
        this.r_min_y = min_y;
        this.r_max_x = max_x;
        this.r_max_y = max_y;
        this.orig_min_x = this.header.min_x;
        this.orig_min_y = this.header.min_y;
        this.orig_max_x = this.header.max_x;
        this.orig_max_y = this.header.max_y;
        this.header.min_x = min_x;
        this.header.min_y = min_y;
        this.header.max_x = max_x;
        this.header.max_y = max_y;
        if (this.orig_min_x > max_x || this.orig_min_y > max_y || this.orig_max_x < min_x || this.orig_max_y < min_y) {
            if (this.filter != null || this.transform != null) {
                this.read_complex = this::read_point_none;
            } else {
                this.read_simple = this::read_point_none;
            }
        } else if (this.filter != null || this.transform != null) {
            if (this.index != null) {
                this.index.intersect_rectangle(min_x, min_y, max_x, max_y);
                this.read_complex = this::read_point_inside_rectangle_indexed;
            } else {
                this.read_complex = this::read_point_inside_rectangle;
            }
        } else if (this.index != null) {
            this.index.intersect_rectangle(min_x, min_y, max_x, max_y);
            this.read_simple = this::read_point_inside_rectangle_indexed;
        } else {
            this.read_simple = this::read_point_inside_rectangle;
        }
        return Boolean.TRUE;
    }

    public boolean read_point_inside_tile() {
        while (this.read_point_default()) {
            if (!this.point.inside_tile(this.t_ll_x, this.t_ll_y, this.t_ur_x, this.t_ur_y)) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public boolean read_point_inside_tile_indexed() {
        while (this.index.seek_next(this)) {
            if (!this.read_point_default() || !this.point.inside_tile(this.t_ll_x, this.t_ll_y, this.t_ur_x, this.t_ur_y)) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public boolean read_point_inside_circle() {
        while (this.read_point_default()) {
            if (!this.point.inside_circle(this.c_center_x, this.c_center_y, this.c_radius_squared)) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public boolean read_point_inside_circle_indexed() {
        while (this.index.seek_next(this)) {
            if (!this.read_point_default() || !this.point.inside_circle(this.c_center_x, this.c_center_y, this.c_radius_squared)) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public boolean read_point_inside_rectangle() {
        while (this.read_point_default()) {
            if (!this.point.inside_rectangle(this.r_min_x, this.r_min_y, this.r_max_x, this.r_max_y)) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public boolean read_point_inside_rectangle_indexed() {
        while (this.index.seek_next(this)) {
            if (!this.read_point_default() || !this.point.inside_rectangle(this.r_min_x, this.r_min_y, this.r_max_x, this.r_max_y)) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public boolean read_point_none() {
        return Boolean.FALSE;
    }

    public boolean read_point_filtered() {
        while (this.read_complex()) {
            if (this.filter.filter(this.point)) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public boolean read_point_transformed() {
        if (this.read_complex()) {
            this.transform.transform(this.point);
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public boolean read_point_filtered_and_transformed() {
        if (this.read_point_filtered()) {
            this.transform.transform(this.point);
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public abstract int get_format();

    public boolean has_layers() {
        return Boolean.FALSE;
    }

    public LASindex get_index() {
        return this.index;
    }

    public LASfilter get_filter() {
        return this.filter;
    }

    public LAStransform get_transform() {
        return this.transform;
    }

    public int get_inside() {
        return this.inside;
    }

    public float get_t_ll_x() {
        return this.t_ll_x;
    }

    public float get_t_ll_y() {
        return this.t_ll_y;
    }

    public float get_t_size() {
        return this.t_size;
    }

    public double get_c_center_x() {
        return this.c_center_x;
    }

    public double get_c_center_y() {
        return this.c_center_y;
    }

    public double get_c_radius() {
        return this.c_radius;
    }

    public double get_r_min_x() {
        return this.r_min_x;
    }

    public double get_r_min_y() {
        return this.r_min_y;
    }

    public double get_r_max_x() {
        return this.r_max_x;
    }

    public double get_r_max_y() {
        return this.r_max_y;
    }

    public abstract boolean seek(long var1);

    public boolean read_point() {
        try {
            return this.read_simple.call();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public double get_min_x() {
        return this.header.min_x;
    }

    public double get_min_y() {
        return this.header.min_y;
    }

    public double get_min_z() {
        return this.header.min_z;
    }

    public double get_max_x() {
        return this.header.max_x;
    }

    public double get_max_y() {
        return this.header.max_y;
    }

    public double get_max_z() {
        return this.header.max_z;
    }

    public double get_x() {
        return this.get_x(this.point.get_X());
    }

    public double get_y() {
        return this.get_y(this.point.get_Y());
    }

    public double get_z() {
        return this.get_z(this.point.get_Z());
    }

    public double get_x(int x) {
        return this.header.get_x(x);
    }

    public double get_y(int y) {
        return this.header.get_y(y);
    }

    public double get_z(int z) {
        return this.header.get_z(z);
    }

    public int get_X(double x) {
        return this.header.get_X(x);
    }

    public int get_Y(double y) {
        return this.header.get_Y(y);
    }

    public int get_Z(double z) {
        return this.header.get_Z(z);
    }

    public abstract ByteStreamIn get_stream();

    @Override
    public void close() {
        this.close(true);
    }

    public abstract void close(boolean var1);

    protected abstract boolean read_point_default();

    private boolean read_complex() {
        try {
            return this.read_complex.call();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private boolean read_simple() {
        try {
            return this.read_simple.call();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean reopen(String file_name) {
        return false;
    }
}

