/*
 * Decompiled with CFR 0.152.
 */
package com.github.mreutegg.laszip4j.laslib;

import com.github.mreutegg.laszip4j.clib.Cstdio;
import com.github.mreutegg.laszip4j.laslib.LAScriterion;
import com.github.mreutegg.laszip4j.laszip.LASpoint;

class LAScriterionKeepz
extends LAScriterion {
    double below_z;
    double above_z;

    @Override
    public String name() {
        return "keep_z";
    }

    @Override
    public int get_command(StringBuilder string) {
        return Cstdio.sprintf(string, "-%s %g %g ", this.name(), this.below_z, this.above_z);
    }

    @Override
    public int get_decompress_selective() {
        return 1;
    }

    @Override
    public boolean filter(LASpoint point) {
        double z = point.get_z();
        return z < this.below_z || z >= this.above_z;
    }

    LAScriterionKeepz(double below_z, double above_z) {
        this.below_z = below_z;
        this.above_z = above_z;
    }
}

