/*
 * Decompiled with CFR 0.152.
 */
package com.github.mreutegg.laszip4j.laslib;

import com.github.mreutegg.laszip4j.clib.Cstdio;
import com.github.mreutegg.laszip4j.laslib.LAScriterion;
import com.github.mreutegg.laszip4j.laszip.LASpoint;

class LAScriterionKeepTile
extends LAScriterion {
    private float ll_x;
    private float ll_y;
    private float ur_x;
    private float ur_y;
    private float tile_size;

    @Override
    public String name() {
        return "keep_tile";
    }

    @Override
    public int get_command(StringBuilder string) {
        return Cstdio.sprintf(string, "-%s %g %g %g ", this.name(), Float.valueOf(this.ll_x), Float.valueOf(this.ll_y), Float.valueOf(this.tile_size));
    }

    @Override
    public boolean filter(LASpoint point) {
        return !point.inside_tile(this.ll_x, this.ll_y, this.ur_x, this.ur_y);
    }

    public LAScriterionKeepTile(float ll_x, float ll_y, float tile_size) {
        this.ll_x = ll_x;
        this.ll_y = ll_y;
        this.ur_x = ll_x + tile_size;
        this.ur_y = ll_y + tile_size;
        this.tile_size = tile_size;
    }
}

