/*
 * Decompiled with CFR 0.152.
 */
package com.github.mreutegg.laszip4j;

import com.github.mreutegg.laszip4j.CloseablePointIterable;
import com.github.mreutegg.laszip4j.LASHeader;
import com.github.mreutegg.laszip4j.LASPoint;
import com.github.mreutegg.laszip4j.LASPointModifier;
import com.github.mreutegg.laszip4j.LASPointTransformer;
import com.github.mreutegg.laszip4j.laslib.LASreadOpener;
import com.github.mreutegg.laszip4j.laslib.LASreader;
import com.github.mreutegg.laszip4j.laslib.LASreaderLAS;
import com.github.mreutegg.laszip4j.laslib.LAStransform;
import com.github.mreutegg.laszip4j.laszip.LASpoint;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;

public final class LASReader {
    private final File file;
    private final InputStream is;
    private Constraint constraint = new None();
    private LASPointTransformer transform = LASPointTransformer.NONE;

    public LASReader(File file) {
        this(Objects.requireNonNull(file), null);
    }

    private LASReader(File file, InputStream is) {
        this.file = file;
        this.is = is;
    }

    public LASReader insideTile(float ll_x, float ll_y, float size) {
        this.constraint = reader -> reader.inside_tile(ll_x, ll_y, size);
        return this;
    }

    public LASReader insideCircle(double center_x, double center_y, double radius) {
        this.constraint = reader -> reader.inside_circle(center_x, center_y, radius);
        return this;
    }

    public LASReader insideRectangle(double min_x, double min_y, double max_x, double max_y) {
        this.constraint = reader -> reader.inside_rectangle(min_x, min_y, max_x, max_y);
        return this;
    }

    public LASReader transform(LASPointTransformer transformer) {
        this.transform = Objects.requireNonNull(transformer);
        return this;
    }

    public Iterable<LASPoint> getPoints() {
        return () -> new LASPointIterator();
    }

    public CloseablePointIterable getCloseablePoints() {
        return new CloseablePointIterable(){
            private final List<LASPointIterator> openIterators = new ArrayList<LASPointIterator>();

            @Override
            public void close() {
                for (LASPointIterator it : this.openIterators) {
                    it.close();
                }
            }

            @Override
            public Iterator<LASPoint> iterator() {
                LASPointIterator it = new LASPointIterator();
                this.openIterators.add(it);
                return it;
            }
        };
    }

    public static Iterable<LASPoint> getPoints(InputStream is) {
        return new LASReader(null, new BufferedInputStream(Objects.requireNonNull(is))).getPoints();
    }

    public LASHeader getHeader() {
        try (LASreader r = this.openReader();){
            LASHeader lASHeader = new LASHeader(r.header);
            return lASHeader;
        }
    }

    public static LASHeader getHeader(InputStream is) {
        try (LASreader r = new LASReader(null, new BufferedInputStream(Objects.requireNonNull(is))).openReader();){
            LASHeader lASHeader = new LASHeader(r.header);
            return lASHeader;
        }
    }

    LASreader openReader() {
        LASreader reader;
        if (this.file != null) {
            if (!this.file.exists() || !this.file.isFile()) {
                throw new UncheckedIOException(new FileNotFoundException(this.file.getAbsolutePath()));
            }
            reader = new LASreadOpener().open(this.file.getAbsolutePath());
        } else {
            LASreaderLAS lasReader = new LASreaderLAS();
            if (lasReader.open(this.is, -1)) {
                reader = lasReader;
            } else {
                throw new IllegalStateException("Cannot open las reader from stream");
            }
        }
        this.constraint.apply(reader);
        if (this.transform != LASPointTransformer.NONE) {
            reader.set_transform(new CustomLAStransform(this.transform));
        }
        return reader;
    }

    private static final class PointModifier
    implements LASPointModifier {
        private final LASpoint point;

        public PointModifier(LASpoint point) {
            this.point = point;
        }

        @Override
        public void setClassification(short classification) {
            this.point.setClassification(classification);
        }

        @Override
        public void setWithheld(boolean withheld) {
            this.point.setWithheld_flag(withheld);
        }
    }

    private static final class CustomLAStransform
    extends LAStransform {
        private final LASPointTransformer transformer;

        private CustomLAStransform(LASPointTransformer transformer) {
            this.transformer = transformer;
        }

        @Override
        public void transform(LASpoint point) {
            this.transformer.transform(new LASPoint(point), new PointModifier(point));
        }
    }

    private final class None
    implements Constraint {
        private None() {
        }

        @Override
        public boolean apply(LASreader reader) {
            return reader.inside_none();
        }
    }

    private static interface Constraint {
        public boolean apply(LASreader var1);
    }

    private class LASPointIterator
    implements Iterator<LASPoint>,
    AutoCloseable {
        private final LASPoint end = new LASPoint(new LASpoint());
        private final LASreader r = LASReader.this.openReader();
        private LASPoint next = null;

        private LASPointIterator() {
        }

        @Override
        public boolean hasNext() {
            if (this.next == this.end) {
                return false;
            }
            if (this.next != null) {
                return true;
            }
            this.next = this.readNext();
            return this.next != this.end;
        }

        @Override
        public LASPoint next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            LASPoint p = this.next;
            this.next = null;
            return p;
        }

        @Override
        public void close() {
            this.r.close();
        }

        private LASPoint readNext() {
            LASPoint p;
            LASPoint lASPoint = p = this.r.read_point() ? new LASPoint(this.r.point) : null;
            if (p == null) {
                this.r.close();
                p = this.end;
            }
            return p;
        }
    }
}

