/*
 * Decompiled with CFR 0.152.
 */
package com.github.mreutegg.laszip4j;

import java.util.HashMap;
import java.util.Map;

public final class LASExtraBytesType {
    private static final Map<Integer, LASExtraBytesType> TYPES = new HashMap<Integer, LASExtraBytesType>();
    private final int dataType;
    private final Class<?> clazz;
    private final int cardinality;
    private final boolean unsigned;

    private LASExtraBytesType(int dataType, Class<?> clazz, int cardinality, boolean unsigned) {
        this.dataType = dataType;
        this.clazz = clazz;
        this.cardinality = cardinality;
        this.unsigned = unsigned;
    }

    private static void create(int dataType, Class<?> clazz, int cardinality, boolean unsigned) {
        LASExtraBytesType t = new LASExtraBytesType(dataType, clazz, cardinality, unsigned);
        TYPES.put(dataType, t);
    }

    static LASExtraBytesType fromOrdinal(int ordinal) {
        LASExtraBytesType t = TYPES.get(ordinal);
        if (t == null) {
            throw new IllegalArgumentException("Invalid data type: " + ordinal);
        }
        return t;
    }

    int getDataType() {
        return this.dataType;
    }

    public int getCardinality() {
        return this.cardinality;
    }

    public boolean isUnsigned() {
        return this.unsigned;
    }

    Class<?> getClazz() {
        return this.clazz;
    }

    static {
        LASExtraBytesType.create(1, Byte.class, 1, true);
        LASExtraBytesType.create(2, Byte.class, 1, false);
        LASExtraBytesType.create(3, Short.class, 1, true);
        LASExtraBytesType.create(4, Short.class, 1, false);
        LASExtraBytesType.create(5, Integer.class, 1, true);
        LASExtraBytesType.create(6, Integer.class, 1, false);
        LASExtraBytesType.create(7, Long.class, 1, true);
        LASExtraBytesType.create(8, Long.class, 1, false);
        LASExtraBytesType.create(9, Float.class, 1, false);
        LASExtraBytesType.create(10, Double.class, 1, false);
        LASExtraBytesType.create(11, Byte.class, 2, true);
        LASExtraBytesType.create(12, Byte.class, 2, false);
        LASExtraBytesType.create(13, Short.class, 2, true);
        LASExtraBytesType.create(14, Short.class, 2, false);
        LASExtraBytesType.create(15, Integer.class, 2, true);
        LASExtraBytesType.create(16, Integer.class, 2, false);
        LASExtraBytesType.create(17, Long.class, 2, true);
        LASExtraBytesType.create(18, Long.class, 2, false);
        LASExtraBytesType.create(19, Float.class, 2, false);
        LASExtraBytesType.create(20, Double.class, 2, false);
        LASExtraBytesType.create(21, Byte.class, 3, true);
        LASExtraBytesType.create(22, Byte.class, 3, false);
        LASExtraBytesType.create(23, Short.class, 3, true);
        LASExtraBytesType.create(24, Short.class, 3, false);
        LASExtraBytesType.create(25, Integer.class, 3, true);
        LASExtraBytesType.create(26, Integer.class, 3, false);
        LASExtraBytesType.create(27, Long.class, 3, true);
        LASExtraBytesType.create(28, Long.class, 3, false);
        LASExtraBytesType.create(29, Float.class, 3, false);
        LASExtraBytesType.create(30, Double.class, 3, false);
    }
}

