/*
 * Decompiled with CFR 0.152.
 */
package com.github.mreutegg.laszip4j;

import com.github.mreutegg.laszip4j.LASExtraBytesType;
import com.github.mreutegg.laszip4j.laszip.LASattribute;
import com.github.mreutegg.laszip4j.laszip.MyDefs;
import java.util.Objects;

public final class LASExtraBytesDescription {
    private final LASattribute attribute;
    private final int offset;

    LASExtraBytesDescription(LASattribute attribute, int offset) {
        this.attribute = Objects.requireNonNull(attribute);
        this.offset = offset;
    }

    int getOffset() {
        return this.offset;
    }

    int getTypeSize() {
        return this.attribute.get_size();
    }

    public LASExtraBytesType getType() {
        return LASExtraBytesType.fromOrdinal(this.attribute.data_type);
    }

    public String getName() {
        return MyDefs.stringFromByteArray(this.attribute.name);
    }

    public String getDescription() {
        return MyDefs.stringFromByteArray(this.attribute.description);
    }

    public boolean hasNoDataValue() {
        return this.attribute.has_no_data();
    }

    public boolean hasMinValue() {
        return this.attribute.has_min();
    }

    public boolean hasMaxValue() {
        return this.attribute.has_max();
    }

    public boolean hasScaleValue() {
        return this.attribute.has_scale();
    }

    public boolean hasOffsetValue() {
        return this.attribute.has_offset();
    }

    public double getScale(int i) {
        if (i < 0 || i >= this.attribute.scale.length) {
            throw new IllegalStateException("" + i);
        }
        return this.attribute.scale[i];
    }

    public double getOffset(int i) {
        if (i < 0 || i >= this.attribute.offset.length) {
            throw new IllegalStateException("" + i);
        }
        return this.attribute.offset[i];
    }
}

