/*
 * Decompiled with CFR 0.152.
 */
package com.github.mreutegg.laszip4j.laszip;

import com.github.mreutegg.laszip4j.clib.Cstdio;
import com.github.mreutegg.laszip4j.laszip.LASitem;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class LASzip {
    private static final PrintStream stderr = System.err;
    public static final int LASZIP_VERSION_MAJOR = 3;
    public static final int LASZIP_VERSION_MINOR = 4;
    public static final int LASZIP_VERSION_REVISION = 3;
    public static final int LASZIP_VERSION_BUILD_DATE = 191111;
    public static final char LASZIP_COMPRESSOR_NONE = '\u0000';
    public static final char LASZIP_COMPRESSOR_POINTWISE = '\u0001';
    public static final char LASZIP_COMPRESSOR_POINTWISE_CHUNKED = '\u0002';
    public static final char LASZIP_COMPRESSOR_LAYERED_CHUNKED = '\u0003';
    public static final char LASZIP_COMPRESSOR_TOTAL_NUMBER_OF = '\u0004';
    public static final char LASZIP_COMPRESSOR_CHUNKED = '\u0002';
    public static final char LASZIP_COMPRESSOR_NOT_CHUNKED = '\u0001';
    public static final char LASZIP_COMPRESSOR_DEFAULT = '\u0002';
    public static final int LASZIP_CODER_ARITHMETIC = 0;
    public static final int LASZIP_CODER_TOTAL_NUMBER_OF = 1;
    public static final int LASZIP_CHUNK_SIZE_DEFAULT = 50000;
    public static final int LASZIP_DECOMPRESS_SELECTIVE_ALL = -1;
    public static final int LASZIP_DECOMPRESS_SELECTIVE_CHANNEL_RETURNS_XY = 0;
    public static final int LASZIP_DECOMPRESS_SELECTIVE_Z = 1;
    public static final int LASZIP_DECOMPRESS_SELECTIVE_CLASSIFICATION = 2;
    public static final int LASZIP_DECOMPRESS_SELECTIVE_FLAGS = 4;
    public static final int LASZIP_DECOMPRESS_SELECTIVE_INTENSITY = 8;
    public static final int LASZIP_DECOMPRESS_SELECTIVE_SCAN_ANGLE = 16;
    public static final int LASZIP_DECOMPRESS_SELECTIVE_USER_DATA = 32;
    public static final int LASZIP_DECOMPRESS_SELECTIVE_POINT_SOURCE = 64;
    public static final int LASZIP_DECOMPRESS_SELECTIVE_GPS_TIME = 128;
    public static final int LASZIP_DECOMPRESS_SELECTIVE_RGB = 256;
    public static final int LASZIP_DECOMPRESS_SELECTIVE_NIR = 512;
    public static final int LASZIP_DECOMPRESS_SELECTIVE_WAVEPACKET = 1024;
    public static final int LASZIP_DECOMPRESS_SELECTIVE_BYTE0 = 65536;
    public static final int LASZIP_DECOMPRESS_SELECTIVE_BYTE1 = 131072;
    public static final int LASZIP_DECOMPRESS_SELECTIVE_BYTE2 = 262144;
    public static final int LASZIP_DECOMPRESS_SELECTIVE_BYTE3 = 524288;
    public static final int LASZIP_DECOMPRESS_SELECTIVE_BYTE4 = 0x100000;
    public static final int LASZIP_DECOMPRESS_SELECTIVE_BYTE5 = 0x200000;
    public static final int LASZIP_DECOMPRESS_SELECTIVE_BYTE6 = 0x400000;
    public static final int LASZIP_DECOMPRESS_SELECTIVE_BYTE7 = 0x800000;
    public static final int LASZIP_DECOMPRESS_SELECTIVE_EXTRA_BYTES = -65536;
    byte[] bytes = null;
    public char compressor = (char)2;
    public char coder = '\u0000';
    public byte version_major = (byte)3;
    public byte version_minor = (byte)4;
    public char version_revision = (char)3;
    public int options = 0;
    public int chunk_size = 50000;
    public long number_of_special_evlrs = -1L;
    public long offset_to_special_evlrs = -1L;
    public char num_items = '\u0000';
    public LASitem[] items = null;
    private String error_string = null;

    boolean unpack(byte[] bytes, int num) {
        int i;
        if (num < 34) {
            return this.return_error("too few bytes to unpack");
        }
        if ((num - 34) % 6 != 0) {
            return this.return_error("wrong number bytes to unpack");
        }
        if ((num - 34) / 6 == 0) {
            return this.return_error("zero items to unpack");
        }
        this.num_items = (char)((num - 34) / 6);
        this.items = new LASitem[this.num_items];
        int b = 0;
        ByteBuffer buffer = ByteBuffer.wrap(bytes).order(ByteOrder.LITTLE_ENDIAN);
        this.compressor = buffer.getChar(b);
        this.coder = buffer.getChar(b += 2);
        this.version_major = buffer.get(b += 2);
        this.version_minor = buffer.get(++b);
        this.version_revision = buffer.getChar(++b);
        this.options = buffer.getInt(b += 2);
        this.chunk_size = buffer.getInt(b += 4);
        this.number_of_special_evlrs = buffer.getLong(b += 4);
        this.offset_to_special_evlrs = buffer.getLong(b += 8);
        this.num_items = buffer.getChar(b += 8);
        b += 2;
        for (i = 0; i < this.num_items; ++i) {
            this.items[i].type = LASitem.Type.fromOrdinal(buffer.getChar(b));
            this.items[i].size = buffer.getChar(b += 2);
            this.items[i].version = buffer.getChar(b += 2);
            b += 2;
        }
        assert (num == b);
        for (i = 0; i < this.num_items; ++i) {
            if (this.check_item(this.items[i])) continue;
            return false;
        }
        return true;
    }

    boolean pack(byte[][] bytes, int[] num) {
        if (!this.check()) {
            return false;
        }
        num[0] = 34 + 6 * this.num_items;
        bytes[0] = new byte[num[0]];
        this.bytes = bytes[0];
        int b = 0;
        ByteBuffer buffer = ByteBuffer.wrap(bytes[0]).order(ByteOrder.LITTLE_ENDIAN);
        buffer.putChar(b, this.compressor);
        buffer.putChar(b += 2, this.coder);
        buffer.put(b += 2, this.version_major);
        buffer.put(++b, this.version_minor);
        buffer.putChar(++b, this.version_revision);
        buffer.putInt(b += 2, this.options);
        buffer.putInt(b += 4, this.chunk_size);
        buffer.putLong(b += 4, this.number_of_special_evlrs);
        buffer.putLong(b += 8, this.offset_to_special_evlrs);
        buffer.putChar(b += 8, this.num_items);
        b += 2;
        for (int i = 0; i < this.num_items; ++i) {
            buffer.putChar(b, (char)this.items[i].type.ordinal());
            buffer.putChar(b += 2, this.items[i].size);
            buffer.putChar(b += 2, this.items[i].version);
            b += 2;
        }
        assert (num[0] == b);
        return true;
    }

    public String get_error() {
        return this.error_string;
    }

    boolean return_error(String error) {
        this.error_string = String.format("%s (LASzip v%d.%dr%d)", error, 3, 4, 3);
        return false;
    }

    boolean check_compressor(char compressor) {
        if (compressor < '\u0004') {
            return true;
        }
        String error = String.format("compressor %d not supported", compressor);
        return this.return_error(error);
    }

    boolean check_coder(char coder) {
        if (coder < '\u0001') {
            return true;
        }
        String error = String.format("coder %d not supported", coder);
        return this.return_error(error);
    }

    boolean check_item(LASitem item) {
        switch (item.type) {
            case POINT10: {
                if (item.size != '\u0014') {
                    return this.return_error("POINT10 has size != 20");
                }
                if (item.version <= '\u0002') break;
                return this.return_error("POINT10 has version > 2");
            }
            case GPSTIME11: {
                if (item.size != '\b') {
                    return this.return_error("GPSTIME11 has size != 8");
                }
                if (item.version <= '\u0002') break;
                return this.return_error("GPSTIME11 has version > 2");
            }
            case RGB12: {
                if (item.size != '\u0006') {
                    return this.return_error("RGB12 has size != 6");
                }
                if (item.version <= '\u0002') break;
                return this.return_error("RGB12 has version > 2");
            }
            case WAVEPACKET13: {
                if (item.size != '\u001d') {
                    return this.return_error("WAVEPACKET13 has size != 29");
                }
                if (item.version <= '\u0001') break;
                return this.return_error("WAVEPACKET13 has version > 1");
            }
            case BYTE: {
                if (item.size < '\u0001') {
                    return this.return_error("BYTE has size < 1");
                }
                if (item.version <= '\u0002') break;
                return this.return_error("BYTE has version > 2");
            }
            case POINT14: {
                if (item.size != '\u001e') {
                    return this.return_error("POINT14 has size != 30");
                }
                if (item.version == '\u0000' || item.version == '\u0002' || item.version == '\u0003' || item.version == '\u0004') break;
                return this.return_error("POINT14 has version != 0 and != 2 and != 3 and != 4");
            }
            case RGB14: {
                if (item.size != '\u0006') {
                    return this.return_error("RGB14 has size != 6");
                }
                if (item.version == '\u0000' || item.version == '\u0002' || item.version == '\u0003' || item.version == '\u0004') break;
                return this.return_error("RGB14 has version != 0 and != 2 and != 3 and != 4");
            }
            case BYTE14: {
                if (item.size < '\u0001') {
                    return this.return_error("BYTE14 has size < 1");
                }
                if (item.version == '\u0000' || item.version == '\u0002' || item.version == '\u0003' || item.version == '\u0004') break;
                return this.return_error("BYTE14 has version != 0 and != 2 and != 3 and != 4");
            }
            case RGBNIR14: {
                if (item.size != '\b') {
                    return this.return_error("RGBNIR14 has size != 8");
                }
                if (item.version == '\u0000' || item.version == '\u0002' || item.version == '\u0003' || item.version == '\u0004') break;
                return this.return_error("RGBNIR14 has version != 0 and != 2 and != 3 and != 4");
            }
            case WAVEPACKET14: {
                if (item.size != '\u001d') {
                    return this.return_error("WAVEPACKET14 has size != 29");
                }
                if (item.version == '\u0000' || item.version == '\u0003' || item.version == '\u0004') break;
                return this.return_error("WAVEPACKET14 has version != 0 and != 3 and != 4");
            }
            default: {
                String error = String.format("item unknown (%d,%d,%d)", item.type.ordinal(), (int)item.size, (int)item.version);
                return this.return_error(error);
            }
        }
        return true;
    }

    boolean check_items(char num_items, LASitem[] items) {
        if (num_items == 0) {
            return this.return_error("number of items cannot be zero");
        }
        if (items == null) {
            return this.return_error("items pointer cannot be NULL");
        }
        for (int i = 0; i < num_items; ++i) {
            if (this.check_item(items[i])) continue;
            return false;
        }
        return true;
    }

    public boolean check() {
        if (!this.check_compressor(this.compressor)) {
            return false;
        }
        if (!this.check_coder(this.coder)) {
            return false;
        }
        return this.check_items(this.num_items, this.items);
    }

    boolean request_compatibility_mode(char requested_compatibility_mode) {
        if (this.num_items != '\u0000') {
            return this.return_error("request compatibility mode before calling setup()");
        }
        if (requested_compatibility_mode > '\u0001') {
            return this.return_error("compatibility mode larger than 1 not supported");
        }
        this.options = requested_compatibility_mode != '\u0000' ? (this.options |= 1) : (this.options &= 0xFFFFFFFE);
        return true;
    }

    boolean setup(byte u_point_type, char point_size, char compressor) {
        if (!this.check_compressor(compressor)) {
            return false;
        }
        this.num_items = '\u0000';
        this.items = null;
        char[] _num_items = new char[1];
        LASitem[][] _items = new LASitem[1][];
        if (!this.setup(_num_items, _items, u_point_type, point_size, compressor)) {
            return false;
        }
        this.num_items = _num_items[0];
        this.items = _items[0];
        this.compressor = compressor;
        if (this.compressor == '\u0002' && this.chunk_size == 0) {
            this.chunk_size = 50000;
        }
        return true;
    }

    public boolean setup(char num_items, LASitem[] items, char compressor) {
        if (!this.check_compressor(compressor)) {
            return false;
        }
        if (!this.check_items(num_items, items)) {
            return false;
        }
        this.compressor = compressor;
        if (this.compressor == '\u0002' && this.chunk_size == 0) {
            this.chunk_size = 50000;
        }
        this.num_items = '\u0000';
        this.num_items = num_items;
        this.items = new LASitem[num_items];
        for (int i = 0; i < this.items.length; ++i) {
            this.items[i] = items[i];
        }
        return true;
    }

    boolean setup(char[] num_items, LASitem[][] items, byte u_point_type, char point_size, char compressor) {
        int i;
        boolean compatible = Boolean.FALSE;
        boolean have_point14 = Boolean.FALSE;
        boolean have_gps_time = Boolean.FALSE;
        boolean have_rgb = Boolean.FALSE;
        boolean have_nir = Boolean.FALSE;
        boolean have_wavepacket = Boolean.FALSE;
        int extra_bytes_number = 0;
        if ((this.options & 1) != 0) {
            compatible = Boolean.TRUE;
        }
        switch (u_point_type) {
            case 0: {
                extra_bytes_number = point_size - 20;
                break;
            }
            case 1: {
                have_gps_time = Boolean.TRUE;
                extra_bytes_number = point_size - 28;
                break;
            }
            case 2: {
                have_rgb = Boolean.TRUE;
                extra_bytes_number = point_size - 26;
                break;
            }
            case 3: {
                have_gps_time = Boolean.TRUE;
                have_rgb = Boolean.TRUE;
                extra_bytes_number = point_size - 34;
                break;
            }
            case 4: {
                have_gps_time = Boolean.TRUE;
                have_wavepacket = Boolean.TRUE;
                extra_bytes_number = point_size - 57;
                break;
            }
            case 5: {
                have_gps_time = Boolean.TRUE;
                have_rgb = Boolean.TRUE;
                have_wavepacket = Boolean.TRUE;
                extra_bytes_number = point_size - 63;
                break;
            }
            case 6: {
                have_point14 = Boolean.TRUE;
                extra_bytes_number = point_size - 30;
                break;
            }
            case 7: {
                have_point14 = Boolean.TRUE;
                have_rgb = Boolean.TRUE;
                extra_bytes_number = point_size - 36;
                break;
            }
            case 8: {
                have_point14 = Boolean.TRUE;
                have_rgb = Boolean.TRUE;
                have_nir = Boolean.TRUE;
                extra_bytes_number = point_size - 38;
                break;
            }
            case 9: {
                have_point14 = Boolean.TRUE;
                have_wavepacket = Boolean.TRUE;
                extra_bytes_number = point_size - 59;
                break;
            }
            case 10: {
                have_point14 = Boolean.TRUE;
                have_rgb = Boolean.TRUE;
                have_nir = Boolean.TRUE;
                have_wavepacket = Boolean.TRUE;
                extra_bytes_number = point_size - 67;
                break;
            }
            default: {
                String error = String.format("point type %d unknown", u_point_type);
                return this.return_error(error);
            }
        }
        if (extra_bytes_number < 0) {
            Cstdio.fprintf(stderr, "WARNING: point size %d too small by %d bytes for point type %d. assuming point_size of %d\n", Character.valueOf(point_size), -extra_bytes_number, u_point_type, point_size - extra_bytes_number);
            extra_bytes_number = 0;
        }
        if (have_point14 && compatible) {
            extra_bytes_number += 5;
            have_gps_time = Boolean.TRUE;
            have_point14 = Boolean.FALSE;
            if (have_nir) {
                extra_bytes_number += 2;
                have_nir = Boolean.FALSE;
            }
        }
        num_items[0] = (char)(1 + LASzip.asInt(have_gps_time) + LASzip.asInt(have_rgb) + LASzip.asInt(have_wavepacket) + LASzip.asInt(extra_bytes_number != 0));
        items[0] = new LASitem[num_items[0]];
        for (i = 0; i < items[0].length; ++i) {
            items[0][i] = new LASitem();
        }
        i = 1;
        if (have_point14) {
            items[0][0].type = LASitem.Type.POINT14;
            items[0][0].size = (char)30;
            items[0][0].version = '\u0000';
        } else {
            items[0][0].type = LASitem.Type.POINT10;
            items[0][0].size = (char)20;
            items[0][0].version = '\u0000';
        }
        if (have_gps_time) {
            items[0][i].type = LASitem.Type.GPSTIME11;
            items[0][i].size = (char)8;
            items[0][i].version = '\u0000';
            ++i;
        }
        if (have_rgb) {
            if (have_point14) {
                if (have_nir) {
                    items[0][i].type = LASitem.Type.RGBNIR14;
                    items[0][i].size = (char)8;
                    items[0][i].version = '\u0000';
                } else {
                    items[0][i].type = LASitem.Type.RGB14;
                    items[0][i].size = (char)6;
                    items[0][i].version = '\u0000';
                }
            } else {
                items[0][i].type = LASitem.Type.RGB12;
                items[0][i].size = (char)6;
                items[0][i].version = '\u0000';
            }
            ++i;
        }
        if (have_wavepacket) {
            if (have_point14) {
                items[0][i].type = LASitem.Type.WAVEPACKET14;
                items[0][i].size = (char)29;
                items[0][i].version = '\u0000';
            } else {
                items[0][i].type = LASitem.Type.WAVEPACKET13;
                items[0][i].size = (char)29;
                items[0][i].version = '\u0000';
            }
            ++i;
        }
        if (extra_bytes_number != 0) {
            if (have_point14) {
                items[0][i].type = LASitem.Type.BYTE14;
                items[0][i].size = (char)extra_bytes_number;
                items[0][i].version = '\u0000';
            } else {
                items[0][i].type = LASitem.Type.BYTE;
                items[0][i].size = (char)extra_bytes_number;
                items[0][i].version = '\u0000';
            }
            ++i;
        }
        if (compressor != '\u0000') {
            this.request_version('\u0002');
        }
        assert (i == num_items[0]);
        return true;
    }

    public boolean set_chunk_size(int u_chunk_size) {
        if (this.num_items == '\u0000') {
            return this.return_error("call setup() before setting chunk size");
        }
        if (this.compressor == '\u0002') {
            this.chunk_size = u_chunk_size;
            return true;
        }
        return false;
    }

    public boolean request_version(char requested_version) {
        if (this.num_items == '\u0000') {
            return this.return_error("call setup() before requesting version");
        }
        if (this.compressor == '\u0000') {
            if (requested_version > '\u0000') {
                return this.return_error("without compression version is always 0");
            }
        } else {
            if (requested_version < '\u0001') {
                return this.return_error("with compression version is at least 1");
            }
            if (requested_version > '\u0004') {
                return this.return_error("version larger than 4 not supported");
            }
        }
        block4: for (char i = '\u0000'; i < this.num_items; i = (char)(i + '\u0001')) {
            switch (this.items[i].type) {
                case POINT10: 
                case GPSTIME11: 
                case RGB12: 
                case BYTE: 
                case POINT14: 
                case RGB14: 
                case BYTE14: 
                case WAVEPACKET14: {
                    this.items[i].version = requested_version;
                    continue block4;
                }
                case WAVEPACKET13: {
                    this.items[i].version = '\u0001';
                    continue block4;
                }
                default: {
                    return this.return_error("item type not supported");
                }
            }
        }
        return true;
    }

    public boolean is_standard(byte[] point_type, char[] record_length) {
        return this.is_standard(this.num_items, this.items, point_type, record_length);
    }

    boolean is_standard(char num_items, LASitem[] items, byte[] point_type, char[] record_length) {
        if (items == null) {
            return this.return_error("LASitem array is zero");
        }
        if (point_type != null) {
            point_type[0] = 127;
        }
        if (record_length != null) {
            record_length[0] = '\u0000';
            for (char i = '\u0000'; i < num_items; i = (char)(i + '\u0001')) {
                record_length[0] = (char)(record_length[0] + items[i].size);
            }
        }
        if (num_items < '\u0001') {
            return this.return_error("less than one LASitem entries");
        }
        if (num_items > '\u0005') {
            return this.return_error("more than five LASitem entries");
        }
        if (items[0].is_type(LASitem.Type.POINT10)) {
            if (num_items == '\u0001') {
                if (point_type != null) {
                    point_type[0] = 0;
                }
                if (record_length != null) assert (record_length[0] == '\u0014');
                return true;
            }
            if (items[1].is_type(LASitem.Type.GPSTIME11)) {
                if (num_items == '\u0002') {
                    if (point_type != null) {
                        point_type[0] = 1;
                    }
                    if (record_length != null) assert (record_length[0] == '\u001c');
                    return true;
                }
                if (items[2].is_type(LASitem.Type.RGB12)) {
                    if (num_items == '\u0003') {
                        if (point_type != null) {
                            point_type[0] = 3;
                        }
                        if (record_length != null) assert (record_length[0] == '\"');
                        return true;
                    }
                    if (items[3].is_type(LASitem.Type.WAVEPACKET13)) {
                        if (num_items == '\u0004') {
                            if (point_type != null) {
                                point_type[0] = 5;
                            }
                            if (record_length != null) assert (record_length[0] == '?');
                            return true;
                        }
                        if (items[4].is_type(LASitem.Type.BYTE) && num_items == '\u0005') {
                            if (point_type != null) {
                                point_type[0] = 5;
                            }
                            if (record_length != null) assert (record_length[0] == 63 + items[4].size);
                            return true;
                        }
                    } else if (items[3].is_type(LASitem.Type.BYTE) && num_items == '\u0004') {
                        if (point_type != null) {
                            point_type[0] = 3;
                        }
                        if (record_length != null) assert (record_length[0] == 34 + items[3].size);
                        return true;
                    }
                } else if (items[2].is_type(LASitem.Type.WAVEPACKET13)) {
                    if (num_items == '\u0003') {
                        if (point_type != null) {
                            point_type[0] = 4;
                        }
                        if (record_length != null) assert (record_length[0] == '9');
                        return true;
                    }
                    if (items[3].is_type(LASitem.Type.BYTE) && num_items == '\u0004') {
                        if (point_type != null) {
                            point_type[0] = 4;
                        }
                        if (record_length != null) assert (record_length[0] == 57 + items[3].size);
                        return true;
                    }
                } else if (items[2].is_type(LASitem.Type.BYTE) && num_items == '\u0003') {
                    if (point_type != null) {
                        point_type[0] = 1;
                    }
                    if (record_length != null) assert (record_length[0] == 28 + items[2].size);
                    return true;
                }
            } else if (items[1].is_type(LASitem.Type.RGB12)) {
                if (num_items == '\u0002') {
                    if (point_type != null) {
                        point_type[0] = 2;
                    }
                    if (record_length != null) assert (record_length[0] == '\u001a');
                    return true;
                }
                if (items[2].is_type(LASitem.Type.BYTE) && num_items == '\u0003') {
                    if (point_type != null) {
                        point_type[0] = 2;
                    }
                    if (record_length != null) assert (record_length[0] == 26 + items[2].size);
                    return true;
                }
            } else if (items[1].is_type(LASitem.Type.BYTE) && num_items == '\u0002') {
                if (point_type != null) {
                    point_type[0] = 0;
                }
                if (record_length != null) assert (record_length[0] == 20 + items[1].size);
                return true;
            }
        } else if (items[0].is_type(LASitem.Type.POINT14)) {
            if (num_items == '\u0001') {
                if (point_type != null) {
                    point_type[0] = 6;
                }
                if (record_length != null) assert (record_length[0] == '\u001e');
                return true;
            }
            if (items[1].is_type(LASitem.Type.RGB14)) {
                if (num_items == '\u0002') {
                    if (point_type != null) {
                        point_type[0] = 7;
                    }
                    if (record_length != null) assert (record_length[0] == '$');
                    return true;
                }
                if ((items[2].is_type(LASitem.Type.BYTE) || items[2].is_type(LASitem.Type.BYTE14)) && num_items == '\u0003') {
                    if (point_type != null) {
                        point_type[0] = 7;
                    }
                    if (record_length != null) assert (record_length[0] == 36 + items[2].size);
                    return true;
                }
            } else if (items[1].is_type(LASitem.Type.RGBNIR14)) {
                if (num_items == '\u0002') {
                    if (point_type != null) {
                        point_type[0] = 8;
                    }
                    if (record_length != null) assert (record_length[0] == '&');
                    return true;
                }
                if (items[2].is_type(LASitem.Type.WAVEPACKET13) || items[2].is_type(LASitem.Type.WAVEPACKET14)) {
                    if (num_items == '\u0003') {
                        if (point_type != null) {
                            point_type[0] = 10;
                        }
                        if (record_length != null) assert (record_length[0] == 'C');
                        return true;
                    }
                    if ((items[3].is_type(LASitem.Type.BYTE) || items[3].is_type(LASitem.Type.BYTE14)) && num_items == '\u0004') {
                        if (point_type != null) {
                            point_type[0] = 10;
                        }
                        if (record_length != null) assert (record_length[0] == 67 + items[3].size);
                        return true;
                    }
                } else if ((items[2].is_type(LASitem.Type.BYTE) || items[2].is_type(LASitem.Type.BYTE14)) && num_items == '\u0003') {
                    if (point_type != null) {
                        point_type[0] = 8;
                    }
                    if (record_length != null) assert (record_length[0] == 38 + items[2].size);
                    return true;
                }
            } else if (items[1].is_type(LASitem.Type.WAVEPACKET13) || items[1].is_type(LASitem.Type.WAVEPACKET14)) {
                if (num_items == '\u0002') {
                    if (point_type != null) {
                        point_type[0] = 9;
                    }
                    if (record_length != null) assert (record_length[0] == ';');
                    return true;
                }
                if ((items[2].is_type(LASitem.Type.BYTE) || items[2].is_type(LASitem.Type.BYTE14)) && num_items == '\u0003') {
                    if (point_type != null) {
                        point_type[0] = 9;
                    }
                    if (record_length != null) assert (record_length[0] == 59 + items[2].size);
                    return true;
                }
            } else if ((items[1].is_type(LASitem.Type.BYTE) || items[1].is_type(LASitem.Type.BYTE14)) && num_items == '\u0002') {
                if (point_type != null) {
                    point_type[0] = 6;
                }
                if (record_length != null) assert (record_length[0] == 30 + items[1].size);
                return true;
            }
        } else {
            this.return_error("first LASitem is neither POINT10 nor POINT14");
        }
        return this.return_error("LASitem array does not match LAS specification 1.4");
    }

    private static int asInt(boolean b) {
        return b ? 1 : 0;
    }
}

