/*
 * Decompiled with CFR 0.152.
 */
package com.github.mreutegg.laszip4j.laszip;

import com.github.mreutegg.laszip4j.laszip.ArithmeticDecoder;
import com.github.mreutegg.laszip4j.laszip.ArithmeticModel;
import com.github.mreutegg.laszip4j.laszip.IntegerCompressor;
import com.github.mreutegg.laszip4j.laszip.LASreadItemCompressed;
import com.github.mreutegg.laszip4j.laszip.PointDataRecord;
import com.github.mreutegg.laszip4j.laszip.PointDataRecordRGB;

public class LASreadItemCompressed_RGB12_v1
extends LASreadItemCompressed {
    private ArithmeticDecoder dec;
    private PointDataRecordRGB last_item;
    private ArithmeticModel m_byte_used;
    private IntegerCompressor ic_rgb;

    public LASreadItemCompressed_RGB12_v1(ArithmeticDecoder dec) {
        assert (dec != null);
        this.dec = dec;
        this.m_byte_used = dec.createSymbolModel(64);
        this.ic_rgb = new IntegerCompressor(dec, 8, 6);
        this.last_item = null;
    }

    @Override
    public void init(PointDataRecord seedItem, int notUsed) {
        this.dec.initSymbolModel(this.m_byte_used);
        this.ic_rgb.initDecompressor();
        this.last_item = new PointDataRecordRGB((PointDataRecordRGB)seedItem);
    }

    @Override
    public PointDataRecord read(int notUsed) {
        PointDataRecordRGB result = new PointDataRecordRGB();
        int sym = this.dec.decodeSymbol(this.m_byte_used);
        result.R = (sym & 1) != 0 ? (char)this.ic_rgb.decompress(this.last_item.R & 0xFF, 0) : (char)(this.last_item.R & 0xFF);
        result.R = (sym & 2) != 0 ? (char)(result.R | (char)this.ic_rgb.decompress(this.last_item.R >> 8, 1) << 8) : (char)(result.R | this.last_item.R & 0xFF00);
        result.G = (sym & 4) != 0 ? (char)this.ic_rgb.decompress(this.last_item.G & 0xFF, 2) : (char)(this.last_item.G & 0xFF);
        result.G = (sym & 8) != 0 ? (char)(result.G | (char)this.ic_rgb.decompress(this.last_item.G >> 8, 3) << 8) : (char)(result.G | this.last_item.G & 0xFF00);
        result.B = (sym & 0x10) != 0 ? (char)this.ic_rgb.decompress(this.last_item.B & 0xFF, 4) : (char)(this.last_item.B & 0xFF);
        result.B = (sym & 0x20) != 0 ? (char)(result.B | (char)this.ic_rgb.decompress(this.last_item.B >> 8, 5) << 8) : (char)(result.B | this.last_item.B & 0xFF00);
        this.last_item.R = result.R;
        this.last_item.G = result.G;
        this.last_item.B = result.B;
        return result;
    }

    @Override
    public boolean chunk_sizes() {
        return false;
    }
}

