/*
 * Decompiled with CFR 0.152.
 */
package com.github.mreutegg.laszip4j.laszip;

import com.github.mreutegg.laszip4j.laszip.ArithmeticDecoder;
import com.github.mreutegg.laszip4j.laszip.ByteStreamIn;
import com.github.mreutegg.laszip4j.laszip.ByteStreamInArray;
import com.github.mreutegg.laszip4j.laszip.Common_v3;
import com.github.mreutegg.laszip4j.laszip.IByteStreamInProvider;
import com.github.mreutegg.laszip4j.laszip.IntegerCompressor;
import com.github.mreutegg.laszip4j.laszip.LAScontextPOINT14;
import com.github.mreutegg.laszip4j.laszip.LASreadItemCompressed;
import com.github.mreutegg.laszip4j.laszip.MyDefs;
import com.github.mreutegg.laszip4j.laszip.PointDataRecord;
import com.github.mreutegg.laszip4j.laszip.PointDataRecordPoint14;
import com.github.mreutegg.laszip4j.laszip.ScanFlag;

public class LASreadItemCompressed_POINT14_v3
extends LASreadItemCompressed {
    private IByteStreamInProvider instreamProvider;
    private ByteStreamInArray instream_channel_returns_XY;
    private ByteStreamInArray instream_Z;
    private ByteStreamInArray instream_classification;
    private ByteStreamInArray instream_flags;
    private ByteStreamInArray instream_intensity;
    private ByteStreamInArray instream_scan_angle;
    private ByteStreamInArray instream_user_data;
    private ByteStreamInArray instream_point_source;
    private ByteStreamInArray instream_gps_time;
    private ArithmeticDecoder dec_channel_returns_XY;
    private ArithmeticDecoder dec_Z;
    private ArithmeticDecoder dec_classification;
    private ArithmeticDecoder dec_flags;
    private ArithmeticDecoder dec_intensity;
    private ArithmeticDecoder dec_scan_angle;
    private ArithmeticDecoder dec_user_data;
    private ArithmeticDecoder dec_point_source;
    private ArithmeticDecoder dec_gps_time;
    private boolean changed_Z;
    private boolean changed_classification;
    private boolean changed_flags;
    private boolean changed_intensity;
    private boolean changed_scan_angle;
    private boolean changed_user_data;
    private boolean changed_point_source;
    private boolean changed_gps_time;
    private boolean requested_Z;
    private boolean requested_classification;
    private boolean requested_flags;
    private boolean requested_intensity;
    private boolean requested_scan_angle;
    private boolean requested_user_data;
    private boolean requested_point_source;
    private boolean requested_gps_time;
    private int num_bytes_channel_returns_XY;
    private int num_bytes_Z;
    private int num_bytes_classification;
    private int num_bytes_flags;
    private int num_bytes_intensity;
    private int num_bytes_scan_angle;
    private int num_bytes_user_data;
    private int num_bytes_point_source;
    private int num_bytes_gps_time;
    private int current_context;
    private LAScontextPOINT14[] contexts = new LAScontextPOINT14[4];
    public static final int LASZIP_GPSTIME_MULTI = 500;
    public static final int LASZIP_GPSTIME_MULTI_MINUS = -10;
    public static final int LASZIP_GPSTIME_MULTI_CODE_FULL = 511;
    public static final int LASZIP_GPSTIME_MULTI_TOTAL = 515;

    public LASreadItemCompressed_POINT14_v3(IByteStreamInProvider instreamProvider, int decompress_selective) {
        assert (instreamProvider != null);
        this.instreamProvider = instreamProvider;
        this.instream_channel_returns_XY = null;
        this.instream_Z = null;
        this.instream_classification = null;
        this.instream_flags = null;
        this.instream_intensity = null;
        this.instream_scan_angle = null;
        this.instream_user_data = null;
        this.instream_point_source = null;
        this.instream_gps_time = null;
        this.dec_channel_returns_XY = null;
        this.dec_Z = null;
        this.dec_classification = null;
        this.dec_flags = null;
        this.dec_intensity = null;
        this.dec_scan_angle = null;
        this.dec_user_data = null;
        this.dec_point_source = null;
        this.dec_gps_time = null;
        for (int i = 0; i < this.contexts.length; ++i) {
            this.contexts[i] = new LAScontextPOINT14();
            this.contexts[i].initialized = false;
        }
        this.current_context = 0;
        this.num_bytes_channel_returns_XY = 0;
        this.num_bytes_Z = 0;
        this.num_bytes_classification = 0;
        this.num_bytes_flags = 0;
        this.num_bytes_intensity = 0;
        this.num_bytes_scan_angle = 0;
        this.num_bytes_user_data = 0;
        this.num_bytes_point_source = 0;
        this.num_bytes_gps_time = 0;
        this.changed_Z = false;
        this.changed_classification = false;
        this.changed_flags = false;
        this.changed_intensity = false;
        this.changed_scan_angle = false;
        this.changed_user_data = false;
        this.changed_point_source = false;
        this.changed_gps_time = false;
        this.requested_Z = (decompress_selective & 1) != 0;
        this.requested_classification = (decompress_selective & 2) != 0;
        this.requested_flags = (decompress_selective & 4) != 0;
        this.requested_intensity = (decompress_selective & 8) != 0;
        this.requested_scan_angle = (decompress_selective & 0x10) != 0;
        this.requested_user_data = (decompress_selective & 0x20) != 0;
        this.requested_point_source = (decompress_selective & 0x40) != 0;
        this.requested_gps_time = (decompress_selective & 0x80) != 0;
    }

    @Override
    public void init(PointDataRecord seedItem, int notUsed) {
        ByteStreamIn instream = this.instreamProvider.getByteStreamIn();
        if (null == this.instream_channel_returns_XY) {
            this.instream_channel_returns_XY = new ByteStreamInArray();
            this.instream_Z = new ByteStreamInArray();
            this.instream_classification = new ByteStreamInArray();
            this.instream_flags = new ByteStreamInArray();
            this.instream_intensity = new ByteStreamInArray();
            this.instream_scan_angle = new ByteStreamInArray();
            this.instream_user_data = new ByteStreamInArray();
            this.instream_point_source = new ByteStreamInArray();
            this.instream_gps_time = new ByteStreamInArray();
            this.dec_channel_returns_XY = new ArithmeticDecoder();
            this.dec_Z = new ArithmeticDecoder();
            this.dec_classification = new ArithmeticDecoder();
            this.dec_flags = new ArithmeticDecoder();
            this.dec_intensity = new ArithmeticDecoder();
            this.dec_scan_angle = new ArithmeticDecoder();
            this.dec_user_data = new ArithmeticDecoder();
            this.dec_point_source = new ArithmeticDecoder();
            this.dec_gps_time = new ArithmeticDecoder();
        }
        byte[] bytes = new byte[this.num_bytes_channel_returns_XY];
        instream.getBytes(bytes, this.num_bytes_channel_returns_XY);
        this.instream_channel_returns_XY.init(bytes, this.num_bytes_channel_returns_XY);
        this.dec_channel_returns_XY.init(this.instream_channel_returns_XY);
        if (this.requested_Z) {
            if (this.num_bytes_Z > 0) {
                bytes = new byte[this.num_bytes_Z];
                instream.getBytes(bytes, this.num_bytes_Z);
                this.instream_Z.init(bytes, this.num_bytes_Z);
                this.dec_Z.init(this.instream_Z);
                this.changed_Z = true;
            } else {
                this.instream_Z.init(null, 0L);
                this.changed_Z = false;
            }
        } else {
            if (this.num_bytes_Z > 0) {
                instream.skipBytes(this.num_bytes_Z);
            }
            this.changed_Z = false;
        }
        if (this.requested_classification) {
            if (this.num_bytes_classification > 0) {
                bytes = new byte[this.num_bytes_classification];
                instream.getBytes(bytes, this.num_bytes_classification);
                this.instream_classification.init(bytes, this.num_bytes_classification);
                this.dec_classification.init(this.instream_classification);
                this.changed_classification = true;
            } else {
                this.instream_classification.init(null, 0L);
                this.changed_classification = false;
            }
        } else {
            if (this.num_bytes_classification > 0) {
                instream.skipBytes(this.num_bytes_classification);
            }
            this.changed_classification = false;
        }
        if (this.requested_flags) {
            if (this.num_bytes_flags > 0) {
                bytes = new byte[this.num_bytes_flags];
                instream.getBytes(bytes, this.num_bytes_flags);
                this.instream_flags.init(bytes, this.num_bytes_flags);
                this.dec_flags.init(this.instream_flags);
                this.changed_flags = true;
            } else {
                this.instream_flags.init(null, 0L);
                this.changed_flags = false;
            }
        } else {
            if (this.num_bytes_flags > 0) {
                instream.skipBytes(this.num_bytes_flags);
            }
            this.changed_flags = false;
        }
        if (this.requested_intensity) {
            if (this.num_bytes_intensity > 0) {
                bytes = new byte[this.num_bytes_intensity];
                instream.getBytes(bytes, this.num_bytes_intensity);
                this.instream_intensity.init(bytes, this.num_bytes_intensity);
                this.dec_intensity.init(this.instream_intensity);
                this.changed_intensity = true;
            } else {
                this.instream_intensity.init(null, 0L);
                this.changed_intensity = false;
            }
        } else {
            if (this.num_bytes_intensity > 0) {
                instream.skipBytes(this.num_bytes_intensity);
            }
            this.changed_intensity = false;
        }
        if (this.requested_scan_angle) {
            if (this.num_bytes_scan_angle > 0) {
                bytes = new byte[this.num_bytes_scan_angle];
                instream.getBytes(bytes, this.num_bytes_scan_angle);
                this.instream_scan_angle.init(bytes, this.num_bytes_scan_angle);
                this.dec_scan_angle.init(this.instream_scan_angle);
                this.changed_scan_angle = true;
            } else {
                this.instream_scan_angle.init(null, 0L);
                this.changed_scan_angle = false;
            }
        } else {
            if (this.num_bytes_scan_angle > 0) {
                instream.skipBytes(this.num_bytes_scan_angle);
            }
            this.changed_scan_angle = false;
        }
        if (this.requested_user_data) {
            if (this.num_bytes_user_data > 0) {
                bytes = new byte[this.num_bytes_user_data];
                instream.getBytes(bytes, this.num_bytes_user_data);
                this.instream_user_data.init(bytes, this.num_bytes_user_data);
                this.dec_user_data.init(this.instream_user_data);
                this.changed_user_data = true;
            } else {
                this.instream_user_data.init(null, 0L);
                this.changed_user_data = false;
            }
        } else {
            if (this.num_bytes_user_data > 0) {
                instream.skipBytes(this.num_bytes_user_data);
            }
            this.changed_user_data = false;
        }
        if (this.requested_point_source) {
            if (this.num_bytes_point_source > 0) {
                bytes = new byte[this.num_bytes_point_source];
                instream.getBytes(bytes, this.num_bytes_point_source);
                this.instream_point_source.init(bytes, this.num_bytes_point_source);
                this.dec_point_source.init(this.instream_point_source);
                this.changed_point_source = true;
            } else {
                this.instream_point_source.init(null, 0L);
                this.changed_point_source = false;
            }
        } else {
            if (this.num_bytes_point_source > 0) {
                instream.skipBytes(this.num_bytes_point_source);
            }
            this.changed_point_source = false;
        }
        if (this.requested_gps_time) {
            if (this.num_bytes_gps_time > 0) {
                bytes = new byte[this.num_bytes_gps_time];
                instream.getBytes(bytes, this.num_bytes_gps_time);
                this.instream_gps_time.init(bytes, this.num_bytes_gps_time);
                this.dec_gps_time.init(this.instream_gps_time);
                this.changed_gps_time = true;
            } else {
                this.instream_gps_time.init(null, 0L);
                this.changed_gps_time = false;
            }
        } else {
            if (this.num_bytes_gps_time > 0) {
                instream.skipBytes(this.num_bytes_gps_time);
            }
            this.changed_gps_time = false;
        }
        for (int c = 0; c < 4; ++c) {
            this.contexts[c].unused = true;
        }
        this.current_context = ((PointDataRecordPoint14)seedItem).getScannerChannel();
        this.createAndInitModelsAndDecompressors(this.current_context, (PointDataRecordPoint14)seedItem);
    }

    @Override
    public PointDataRecord read(int context) {
        int r;
        int n;
        PointDataRecordPoint14 last_item = this.contexts[this.current_context].last_item;
        int lpr = last_item.getReturnNumber() == 1 ? 1 : 0;
        byte nrgp = last_item.getNumberOfReturns();
        lpr += last_item.getReturnNumber() >= nrgp ? 2 : 0;
        int changed_values = this.dec_channel_returns_XY.decodeSymbol(this.contexts[this.current_context].m_changed_values[lpr += last_item.gps_time_change ? 4 : 0]);
        if ((changed_values & 0x40) != 0) {
            int diff = this.dec_channel_returns_XY.decodeSymbol(this.contexts[this.current_context].m_scanner_channel);
            int scanner_channel = (this.current_context + diff + 1) % 4;
            if (this.contexts[scanner_channel].unused) {
                this.createAndInitModelsAndDecompressors(scanner_channel, this.contexts[this.current_context].last_item);
            }
            this.current_context = scanner_channel;
            last_item = this.contexts[this.current_context].last_item;
            last_item.setScannerChannel((byte)scanner_channel);
        }
        boolean point_source_change = (changed_values & 0x20) != 0;
        boolean gps_time_change = (changed_values & 0x10) != 0;
        boolean scan_angle_change = (changed_values & 8) != 0;
        int last_n = last_item.getNumberOfReturns();
        int last_r = last_item.getReturnNumber();
        if ((changed_values & 4) != 0) {
            if (this.contexts[this.current_context].m_number_of_returns[last_n] == null) {
                this.contexts[this.current_context].m_number_of_returns[last_n] = this.dec_channel_returns_XY.createSymbolModel(16);
                this.dec_channel_returns_XY.initSymbolModel(this.contexts[this.current_context].m_number_of_returns[last_n]);
            }
            n = this.dec_channel_returns_XY.decodeSymbol(this.contexts[this.current_context].m_number_of_returns[last_n]);
            last_item.setNumberOfReturns((byte)n);
        } else {
            n = last_n;
        }
        if ((changed_values & 3) == 0) {
            r = last_r;
        } else if ((changed_values & 3) == 1) {
            r = (last_r + 1) % 16;
            last_item.setReturnNumber((byte)r);
        } else if ((changed_values & 3) == 2) {
            r = (last_r + 15) % 16;
            last_item.setReturnNumber((byte)r);
        } else {
            if (gps_time_change) {
                if (this.contexts[this.current_context].m_return_number[last_r] == null) {
                    this.contexts[this.current_context].m_return_number[last_r] = this.dec_channel_returns_XY.createSymbolModel(16);
                    this.dec_channel_returns_XY.initSymbolModel(this.contexts[this.current_context].m_return_number[last_r]);
                }
                r = this.dec_channel_returns_XY.decodeSymbol(this.contexts[this.current_context].m_return_number[last_r]);
            } else {
                int sym = this.dec_channel_returns_XY.decodeSymbol(this.contexts[this.current_context].m_return_number_gps_same);
                r = (last_r + (sym + 2)) % 16;
            }
            last_item.setReturnNumber((byte)r);
        }
        byte m = Common_v3.number_return_map_6ctx[n][r];
        byte l = Common_v3.number_return_level_8ctx[n][r];
        int cpr = r == 1 ? 2 : 0;
        cpr += r >= n ? 1 : 0;
        int median = this.contexts[this.current_context].last_X_diff_median5[m << 1 | (gps_time_change ? 1 : 0)].get();
        int diff = this.contexts[this.current_context].ic_dX.decompress(median, n == 1 ? 1 : 0);
        last_item.X += diff;
        this.contexts[this.current_context].last_X_diff_median5[m << 1 | (gps_time_change ? 1 : 0)].add(diff);
        median = this.contexts[this.current_context].last_Y_diff_median5[m << 1 | (gps_time_change ? 1 : 0)].get();
        int k_bits = this.contexts[this.current_context].ic_dX.getK();
        diff = this.contexts[this.current_context].ic_dY.decompress(median, (n == 1 ? 1 : 0) + (k_bits < 20 ? MyDefs.U32_ZERO_BIT_0(k_bits) : 20));
        last_item.Y += diff;
        this.contexts[this.current_context].last_Y_diff_median5[m << 1 | (gps_time_change ? 1 : 0)].add(diff);
        if (this.changed_Z) {
            k_bits = (this.contexts[this.current_context].ic_dX.getK() + this.contexts[this.current_context].ic_dY.getK()) / 2;
            last_item.Z = this.contexts[this.current_context].ic_Z.decompress((int)this.contexts[this.current_context].last_Z[l], (n == 1 ? 1 : 0) + (k_bits < 18 ? MyDefs.U32_ZERO_BIT_0(k_bits) : 18));
            this.contexts[this.current_context].last_Z[l] = last_item.Z;
        }
        if (this.changed_classification) {
            short last_classification = last_item.Classification;
            int ccc = ((last_classification & 0x1F) << 1) + (cpr == 3 ? 1 : 0);
            if (this.contexts[this.current_context].m_classification[ccc] == null) {
                this.contexts[this.current_context].m_classification[ccc] = this.dec_classification.createSymbolModel(256);
                this.dec_classification.initSymbolModel(this.contexts[this.current_context].m_classification[ccc]);
            }
            last_item.Classification = (short)this.dec_classification.decodeSymbol(this.contexts[this.current_context].m_classification[ccc]);
        }
        if (this.changed_flags) {
            int flags;
            int last_flags = (last_item.hasScanFlag(ScanFlag.EdgeOfFlightLine) ? 1 : 0) << 5 | (last_item.hasScanFlag(ScanFlag.ScanDirection) ? 1 : 0) << 4 | last_item.getClassificationFlags();
            if (this.contexts[this.current_context].m_flags[last_flags] == null) {
                this.contexts[this.current_context].m_flags[last_flags] = this.dec_flags.createSymbolModel(64);
                this.dec_flags.initSymbolModel(this.contexts[this.current_context].m_flags[last_flags]);
            }
            last_item.setScanDirection(((flags = this.dec_flags.decodeSymbol(this.contexts[this.current_context].m_flags[last_flags])) >>> 4 & 1) == 1);
            last_item.setEdgeOfFlightLine((flags >>> 5 & 1) == 1);
            last_item.setClassificationFlags((byte)(flags & 0xF));
        }
        if (this.changed_intensity) {
            int intensity = this.contexts[this.current_context].ic_intensity.decompress(this.contexts[this.current_context].last_intensity[cpr << 1 | (gps_time_change ? 1 : 0)], cpr);
            this.contexts[this.current_context].last_intensity[cpr << 1 | (gps_time_change ? 1 : 0)] = (char)intensity;
            last_item.Intensity = (char)intensity;
        }
        if (this.changed_scan_angle && scan_angle_change) {
            last_item.ScanAngle = (short)this.contexts[this.current_context].ic_scan_angle.decompress(last_item.ScanAngle, gps_time_change ? 1 : 0);
        }
        if (this.changed_user_data) {
            if (this.contexts[this.current_context].m_user_data[last_item.UserData / 4] == null) {
                this.contexts[this.current_context].m_user_data[last_item.UserData / 4] = this.dec_user_data.createSymbolModel(256);
                this.dec_user_data.initSymbolModel(this.contexts[this.current_context].m_user_data[last_item.UserData / 4]);
            }
            last_item.UserData = (short)this.dec_user_data.decodeSymbol(this.contexts[this.current_context].m_user_data[last_item.UserData / 4]);
        }
        if (this.changed_point_source && point_source_change) {
            last_item.PointSourceID = (char)this.contexts[this.current_context].ic_point_source_ID.decompress(last_item.PointSourceID);
        }
        if (this.changed_gps_time && gps_time_change) {
            this.read_gps_time();
            last_item.GPSTime = this.contexts[this.current_context].last_gpstime[this.contexts[this.current_context].last];
        }
        PointDataRecordPoint14 result = new PointDataRecordPoint14(last_item);
        result.CompressionContext = this.current_context;
        last_item.gps_time_change = gps_time_change;
        return result;
    }

    @Override
    public boolean chunk_sizes() {
        ByteStreamIn instream = this.instreamProvider.getByteStreamIn();
        this.num_bytes_channel_returns_XY = instream.get32bitsLE();
        this.num_bytes_Z = instream.get32bitsLE();
        this.num_bytes_classification = instream.get32bitsLE();
        this.num_bytes_flags = instream.get32bitsLE();
        this.num_bytes_intensity = instream.get32bitsLE();
        this.num_bytes_scan_angle = instream.get32bitsLE();
        this.num_bytes_user_data = instream.get32bitsLE();
        this.num_bytes_point_source = instream.get32bitsLE();
        this.num_bytes_gps_time = instream.get32bitsLE();
        return true;
    }

    private boolean createAndInitModelsAndDecompressors(int context, PointDataRecordPoint14 seedItem) {
        int i;
        assert (this.contexts[context].unused);
        if (!this.contexts[context].initialized) {
            this.contexts[context].m_changed_values[0] = this.dec_channel_returns_XY.createSymbolModel(128);
            this.contexts[context].m_changed_values[1] = this.dec_channel_returns_XY.createSymbolModel(128);
            this.contexts[context].m_changed_values[2] = this.dec_channel_returns_XY.createSymbolModel(128);
            this.contexts[context].m_changed_values[3] = this.dec_channel_returns_XY.createSymbolModel(128);
            this.contexts[context].m_changed_values[4] = this.dec_channel_returns_XY.createSymbolModel(128);
            this.contexts[context].m_changed_values[5] = this.dec_channel_returns_XY.createSymbolModel(128);
            this.contexts[context].m_changed_values[6] = this.dec_channel_returns_XY.createSymbolModel(128);
            this.contexts[context].m_changed_values[7] = this.dec_channel_returns_XY.createSymbolModel(128);
            this.contexts[context].m_scanner_channel = this.dec_channel_returns_XY.createSymbolModel(3);
            for (i = 0; i < 16; ++i) {
                this.contexts[context].m_number_of_returns[i] = null;
                this.contexts[context].m_return_number[i] = null;
            }
            this.contexts[context].m_return_number_gps_same = this.dec_channel_returns_XY.createSymbolModel(13);
            this.contexts[context].ic_dX = new IntegerCompressor(this.dec_channel_returns_XY, 32, 2);
            this.contexts[context].ic_dY = new IntegerCompressor(this.dec_channel_returns_XY, 32, 22);
            this.contexts[context].ic_Z = new IntegerCompressor(this.dec_Z, 32, 20);
            for (i = 0; i < 64; ++i) {
                this.contexts[context].m_classification[i] = null;
                this.contexts[context].m_flags[i] = null;
                this.contexts[context].m_user_data[i] = null;
            }
            this.contexts[context].ic_intensity = new IntegerCompressor(this.dec_intensity, 16, 4);
            this.contexts[context].ic_scan_angle = new IntegerCompressor(this.dec_scan_angle, 16, 2);
            this.contexts[context].ic_point_source_ID = new IntegerCompressor(this.dec_point_source, 16);
            this.contexts[context].m_gpstime_multi = this.dec_gps_time.createSymbolModel(515);
            this.contexts[context].m_gpstime_0diff = this.dec_gps_time.createSymbolModel(5);
            this.contexts[context].ic_gpstime = new IntegerCompressor(this.dec_gps_time, 32, 9);
            this.contexts[context].initialized = true;
        }
        this.dec_channel_returns_XY.initSymbolModel(this.contexts[context].m_changed_values[0]);
        this.dec_channel_returns_XY.initSymbolModel(this.contexts[context].m_changed_values[1]);
        this.dec_channel_returns_XY.initSymbolModel(this.contexts[context].m_changed_values[2]);
        this.dec_channel_returns_XY.initSymbolModel(this.contexts[context].m_changed_values[3]);
        this.dec_channel_returns_XY.initSymbolModel(this.contexts[context].m_changed_values[4]);
        this.dec_channel_returns_XY.initSymbolModel(this.contexts[context].m_changed_values[5]);
        this.dec_channel_returns_XY.initSymbolModel(this.contexts[context].m_changed_values[6]);
        this.dec_channel_returns_XY.initSymbolModel(this.contexts[context].m_changed_values[7]);
        this.dec_channel_returns_XY.initSymbolModel(this.contexts[context].m_scanner_channel);
        for (i = 0; i < 16; ++i) {
            if (null != this.contexts[context].m_number_of_returns[i]) {
                this.dec_channel_returns_XY.initSymbolModel(this.contexts[context].m_number_of_returns[i]);
            }
            if (null == this.contexts[context].m_return_number[i]) continue;
            this.dec_channel_returns_XY.initSymbolModel(this.contexts[context].m_return_number[i]);
        }
        this.dec_channel_returns_XY.initSymbolModel(this.contexts[context].m_return_number_gps_same);
        this.contexts[context].ic_dX.initDecompressor();
        this.contexts[context].ic_dY.initDecompressor();
        for (i = 0; i < 12; ++i) {
            this.contexts[context].last_X_diff_median5[i].init();
            this.contexts[context].last_Y_diff_median5[i].init();
        }
        this.contexts[context].ic_Z.initDecompressor();
        for (i = 0; i < 8; ++i) {
            this.contexts[context].last_Z[i] = seedItem.Z;
        }
        for (i = 0; i < 64; ++i) {
            if (null != this.contexts[context].m_classification[i]) {
                this.dec_classification.initSymbolModel(this.contexts[context].m_classification[i]);
            }
            if (null != this.contexts[context].m_flags[i]) {
                this.dec_flags.initSymbolModel(this.contexts[context].m_flags[i]);
            }
            if (null == this.contexts[context].m_user_data[i]) continue;
            this.dec_user_data.initSymbolModel(this.contexts[context].m_user_data[i]);
        }
        this.contexts[context].ic_intensity.initDecompressor();
        for (i = 0; i < 8; ++i) {
            this.contexts[context].last_intensity[i] = seedItem.Intensity;
        }
        this.contexts[context].ic_scan_angle.initDecompressor();
        this.contexts[context].ic_point_source_ID.initDecompressor();
        this.dec_gps_time.initSymbolModel(this.contexts[context].m_gpstime_multi);
        this.dec_gps_time.initSymbolModel(this.contexts[context].m_gpstime_0diff);
        this.contexts[context].ic_gpstime.initDecompressor();
        this.contexts[context].last = 0;
        this.contexts[context].next = 0;
        this.contexts[context].last_gpstime_diff[0] = 0;
        this.contexts[context].last_gpstime_diff[1] = 0;
        this.contexts[context].last_gpstime_diff[2] = 0;
        this.contexts[context].last_gpstime_diff[3] = 0;
        this.contexts[context].multi_extreme_counter[0] = 0;
        this.contexts[context].multi_extreme_counter[1] = 0;
        this.contexts[context].multi_extreme_counter[2] = 0;
        this.contexts[context].multi_extreme_counter[3] = 0;
        this.contexts[context].last_gpstime[0] = seedItem.GPSTime;
        this.contexts[context].last_gpstime[1] = 0L;
        this.contexts[context].last_gpstime[2] = 0L;
        this.contexts[context].last_gpstime[3] = 0L;
        this.contexts[context].last_item = new PointDataRecordPoint14(seedItem);
        this.contexts[context].last_item.gps_time_change = false;
        this.contexts[context].unused = false;
        return true;
    }

    void read_gps_time() {
        if (this.contexts[this.current_context].last_gpstime_diff[this.contexts[this.current_context].last] == 0) {
            int multi = this.dec_gps_time.decodeSymbol(this.contexts[this.current_context].m_gpstime_0diff);
            if (multi == 0) {
                this.contexts[this.current_context].last_gpstime_diff[this.contexts[this.current_context].last] = this.contexts[this.current_context].ic_gpstime.decompress(0, 0);
                int n = this.contexts[this.current_context].last;
                this.contexts[this.current_context].last_gpstime[n] = this.contexts[this.current_context].last_gpstime[n] + (long)this.contexts[this.current_context].last_gpstime_diff[this.contexts[this.current_context].last];
                this.contexts[this.current_context].multi_extreme_counter[this.contexts[this.current_context].last] = 0;
            } else if (multi == 1) {
                this.contexts[this.current_context].next = this.contexts[this.current_context].next + 1 & 3;
                this.contexts[this.current_context].last_gpstime[this.contexts[this.current_context].next] = this.contexts[this.current_context].ic_gpstime.decompress((int)(this.contexts[this.current_context].last_gpstime[this.contexts[this.current_context].last] >>> 32), 8);
                this.contexts[this.current_context].last_gpstime[this.contexts[this.current_context].next] = this.contexts[this.current_context].last_gpstime[this.contexts[this.current_context].next] << 32;
                int n = this.contexts[this.current_context].next;
                this.contexts[this.current_context].last_gpstime[n] = this.contexts[this.current_context].last_gpstime[n] | Integer.toUnsignedLong(this.dec_gps_time.readInt());
                this.contexts[this.current_context].last = this.contexts[this.current_context].next;
                this.contexts[this.current_context].last_gpstime_diff[this.contexts[this.current_context].last] = 0;
                this.contexts[this.current_context].multi_extreme_counter[this.contexts[this.current_context].last] = 0;
            } else {
                this.contexts[this.current_context].last = this.contexts[this.current_context].last + multi - 1 & 3;
                this.read_gps_time();
            }
        } else {
            int multi = this.dec_gps_time.decodeSymbol(this.contexts[this.current_context].m_gpstime_multi);
            if (multi == 1) {
                int n = this.contexts[this.current_context].last;
                this.contexts[this.current_context].last_gpstime[n] = this.contexts[this.current_context].last_gpstime[n] + (long)this.contexts[this.current_context].ic_gpstime.decompress(this.contexts[this.current_context].last_gpstime_diff[this.contexts[this.current_context].last], 1);
                this.contexts[this.current_context].multi_extreme_counter[this.contexts[this.current_context].last] = 0;
            } else if (multi < 511) {
                int gpstime_diff;
                if (multi == 0) {
                    gpstime_diff = this.contexts[this.current_context].ic_gpstime.decompress(0, 7);
                    int n = this.contexts[this.current_context].last;
                    this.contexts[this.current_context].multi_extreme_counter[n] = this.contexts[this.current_context].multi_extreme_counter[n] + 1;
                    if (this.contexts[this.current_context].multi_extreme_counter[this.contexts[this.current_context].last] > 3) {
                        this.contexts[this.current_context].last_gpstime_diff[this.contexts[this.current_context].last] = gpstime_diff;
                        this.contexts[this.current_context].multi_extreme_counter[this.contexts[this.current_context].last] = 0;
                    }
                } else if (multi < 500) {
                    gpstime_diff = multi < 10 ? this.contexts[this.current_context].ic_gpstime.decompress(multi * this.contexts[this.current_context].last_gpstime_diff[this.contexts[this.current_context].last], 2) : this.contexts[this.current_context].ic_gpstime.decompress(multi * this.contexts[this.current_context].last_gpstime_diff[this.contexts[this.current_context].last], 3);
                } else if (multi == 500) {
                    gpstime_diff = this.contexts[this.current_context].ic_gpstime.decompress(500 * this.contexts[this.current_context].last_gpstime_diff[this.contexts[this.current_context].last], 4);
                    int n = this.contexts[this.current_context].last;
                    this.contexts[this.current_context].multi_extreme_counter[n] = this.contexts[this.current_context].multi_extreme_counter[n] + 1;
                    if (this.contexts[this.current_context].multi_extreme_counter[this.contexts[this.current_context].last] > 3) {
                        this.contexts[this.current_context].last_gpstime_diff[this.contexts[this.current_context].last] = gpstime_diff;
                        this.contexts[this.current_context].multi_extreme_counter[this.contexts[this.current_context].last] = 0;
                    }
                } else if ((multi = 500 - multi) > -10) {
                    gpstime_diff = this.contexts[this.current_context].ic_gpstime.decompress(multi * this.contexts[this.current_context].last_gpstime_diff[this.contexts[this.current_context].last], 5);
                } else {
                    gpstime_diff = this.contexts[this.current_context].ic_gpstime.decompress(-10 * this.contexts[this.current_context].last_gpstime_diff[this.contexts[this.current_context].last], 6);
                    int n = this.contexts[this.current_context].last;
                    this.contexts[this.current_context].multi_extreme_counter[n] = this.contexts[this.current_context].multi_extreme_counter[n] + 1;
                    if (this.contexts[this.current_context].multi_extreme_counter[this.contexts[this.current_context].last] > 3) {
                        this.contexts[this.current_context].last_gpstime_diff[this.contexts[this.current_context].last] = gpstime_diff;
                        this.contexts[this.current_context].multi_extreme_counter[this.contexts[this.current_context].last] = 0;
                    }
                }
                int n = this.contexts[this.current_context].last;
                this.contexts[this.current_context].last_gpstime[n] = this.contexts[this.current_context].last_gpstime[n] + (long)gpstime_diff;
            } else if (multi == 511) {
                this.contexts[this.current_context].next = this.contexts[this.current_context].next + 1 & 3;
                this.contexts[this.current_context].last_gpstime[this.contexts[this.current_context].next] = this.contexts[this.current_context].ic_gpstime.decompress((int)(this.contexts[this.current_context].last_gpstime[this.contexts[this.current_context].last] >>> 32), 8);
                this.contexts[this.current_context].last_gpstime[this.contexts[this.current_context].next] = this.contexts[this.current_context].last_gpstime[this.contexts[this.current_context].next] << 32;
                int n = this.contexts[this.current_context].next;
                this.contexts[this.current_context].last_gpstime[n] = this.contexts[this.current_context].last_gpstime[n] | Integer.toUnsignedLong(this.dec_gps_time.readInt());
                this.contexts[this.current_context].last = this.contexts[this.current_context].next;
                this.contexts[this.current_context].last_gpstime_diff[this.contexts[this.current_context].last] = 0;
                this.contexts[this.current_context].multi_extreme_counter[this.contexts[this.current_context].last] = 0;
            } else if (multi >= 511) {
                this.contexts[this.current_context].last = this.contexts[this.current_context].last + multi - 511 & 3;
                this.read_gps_time();
            }
        }
    }
}

