/*
 * Decompiled with CFR 0.152.
 */
package com.github.mreutegg.laszip4j.laszip;

import com.github.mreutegg.laszip4j.laszip.ArithmeticDecoder;
import com.github.mreutegg.laszip4j.laszip.IntegerCompressor;
import com.github.mreutegg.laszip4j.laszip.LASreadItemCompressed;
import com.github.mreutegg.laszip4j.laszip.PointDataRecord;
import com.github.mreutegg.laszip4j.laszip.PointDataRecordBytes;

public class LASreadItemCompressed_BYTE_v1
extends LASreadItemCompressed {
    private int number;
    private PointDataRecordBytes last_item;
    private IntegerCompressor ic_byte;

    public LASreadItemCompressed_BYTE_v1(ArithmeticDecoder dec, int number) {
        assert (dec != null);
        assert (number != 0);
        this.number = number;
        this.ic_byte = new IntegerCompressor(dec, 8, number);
    }

    @Override
    public void init(PointDataRecord seedItem, int notUsed) {
        this.ic_byte.initDecompressor();
        this.last_item = new PointDataRecordBytes((PointDataRecordBytes)seedItem);
    }

    @Override
    public PointDataRecord read(int notUsed) {
        PointDataRecordBytes result = new PointDataRecordBytes(this.number);
        for (int i = 0; i < this.number; ++i) {
            result.Bytes[i] = (byte)this.ic_byte.decompress(this.last_item.Bytes[i], i);
        }
        return result;
    }

    @Override
    public boolean chunk_sizes() {
        return false;
    }
}

