/*
 * Decompiled with CFR 0.152.
 */
package com.github.mreutegg.laszip4j.laszip;

import java.io.Closeable;

public abstract class ByteStreamOut
implements Closeable {
    private long u_bit_buffer = 0L;
    private int u_num_buffer = 0;

    protected final boolean putBits(int u_bits, int u_num_bits) {
        long u_new_bits = Integer.toUnsignedLong(u_bits);
        this.u_bit_buffer |= u_new_bits << this.u_num_buffer;
        this.u_num_buffer += u_num_bits;
        if (Integer.compareUnsigned(this.u_num_buffer, 32) >= 0) {
            int u_output_bits = (int)this.u_bit_buffer;
            this.u_bit_buffer >>>= 32;
            this.u_num_buffer -= 32;
            return this.put32bitsLE(u_output_bits);
        }
        return true;
    }

    protected final boolean flushBits() {
        if (Integer.compareUnsigned(this.u_num_buffer, 0) > 0) {
            int u_num_zero_bits = 32 - this.u_num_buffer;
            int u_output_bits = (int)(this.u_bit_buffer >>> u_num_zero_bits);
            this.u_bit_buffer = 0L;
            this.u_num_buffer = 0;
            return this.put32bitsLE(u_output_bits);
        }
        return true;
    }

    public abstract boolean putByte(byte var1);

    public abstract boolean putBytes(byte[] var1, int var2);

    public abstract boolean put16bitsLE(char var1);

    public abstract boolean put16bitsLE(short var1);

    public abstract boolean put32bitsLE(int var1);

    public abstract boolean put64bitsLE(long var1);

    abstract boolean put16bitsBE(char var1);

    abstract boolean put32bitsBE(int var1);

    abstract boolean put64bitsBE(long var1);

    public abstract boolean isSeekable();

    public abstract long tell();

    public abstract boolean seek(long var1);

    public abstract boolean seekEnd();

    protected ByteStreamOut() {
    }
}

