/*
 * Decompiled with CFR 0.152.
 */
package com.github.mreutegg.laszip4j.laslib;

import com.github.mreutegg.laszip4j.clib.Cstdio;
import com.github.mreutegg.laszip4j.laslib.LAScriterion;
import com.github.mreutegg.laszip4j.laszip.LASpoint;

class LAScriterionKeepRGB
extends LAScriterion {
    private int below_RGB;
    private int above_RGB;
    private int channel;

    @Override
    public String name() {
        return "keep_RGB";
    }

    @Override
    public int get_command(StringBuilder string) {
        return Cstdio.sprintf(string, "-%s_%s %d %d ", this.name(), this.channel == 0 ? "red" : (this.channel == 1 ? "green" : (this.channel == 2 ? "blue" : "nir")), this.below_RGB, this.above_RGB);
    }

    @Override
    public int get_decompress_selective() {
        return 256;
    }

    @Override
    public boolean filter(LASpoint point) {
        return point.getRgb(this.channel) < this.below_RGB || this.above_RGB < point.getRgb(this.channel);
    }

    LAScriterionKeepRGB(int below_RGB, int above_RGB, int channel) {
        if (above_RGB < below_RGB) {
            this.below_RGB = above_RGB;
            this.above_RGB = below_RGB;
        } else {
            this.below_RGB = below_RGB;
            this.above_RGB = above_RGB;
        }
        this.channel = channel;
    }
}

