/*
 * Decompiled with CFR 0.152.
 */
package com.github.mreutegg.laszip4j.laszip;

import com.github.mreutegg.laszip4j.laszip.ClassificationFlag;
import com.github.mreutegg.laszip4j.laszip.IGpsTimeProvider;
import com.github.mreutegg.laszip4j.laszip.MyDefs;
import com.github.mreutegg.laszip4j.laszip.PointDataRecordXYZBase;
import com.github.mreutegg.laszip4j.laszip.ScanFlag;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

class PointDataRecordPoint14
extends PointDataRecordXYZBase
implements IGpsTimeProvider {
    public byte ReturnFlags = 0;
    public byte ScanFlags = 0;
    public short ScanAngle = 0;
    public long GPSTime = 0L;
    public boolean gps_time_change = false;

    public PointDataRecordPoint14() {
    }

    public PointDataRecordPoint14(PointDataRecordPoint14 other) {
        this.X = other.X;
        this.Y = other.Y;
        this.Z = other.Z;
        this.Intensity = other.Intensity;
        this.ReturnFlags = other.ReturnFlags;
        this.ScanFlags = other.ScanFlags;
        this.Classification = other.Classification;
        this.UserData = other.UserData;
        this.ScanAngle = other.ScanAngle;
        this.PointSourceID = other.PointSourceID;
        this.GPSTime = other.GPSTime;
    }

    @Override
    public byte getReturnNumber() {
        return (byte)(this.ReturnFlags & 0xF);
    }

    @Override
    void setReturnNumber(byte numba) {
        this.ReturnFlags = (byte)(this.ReturnFlags & 0xFFFFFFF0);
        this.ReturnFlags = (byte)(this.ReturnFlags | numba & 0xF);
    }

    @Override
    byte getNumberOfReturns() {
        return (byte)(this.ReturnFlags >>> 4 & 0xF);
    }

    @Override
    void setNumberOfReturns(byte numberOfReturns) {
        this.ReturnFlags = (byte)(this.ReturnFlags & 0xFFFFFF0F);
        this.ReturnFlags = (byte)(this.ReturnFlags | numberOfReturns << 4 & 0xF0);
    }

    byte getClassificationFlags() {
        return (byte)(this.ScanFlags & 0xF);
    }

    void setClassificationFlags(byte flags) {
        this.ScanFlags = (byte)(this.ScanFlags & 0xFFFFFFF0);
        this.ScanFlags = (byte)(this.ScanFlags | flags & 0xF);
    }

    byte getScannerChannel() {
        return (byte)(this.ScanFlags >>> 4 & 3);
    }

    void setScannerChannel(byte channel) {
        this.ScanFlags = (byte)(this.ScanFlags & 0xFFFFFFCF);
        this.ScanFlags = (byte)(this.ScanFlags | channel << 4 & 0x30);
    }

    @Override
    void setScanDirection(boolean isPositive) {
        this.ScanFlags = (byte)(this.ScanFlags & 0xFFFFFFBF);
        this.ScanFlags = (byte)(this.ScanFlags | (isPositive ? 1 : 0) << 6 & 0x40);
    }

    @Override
    void setEdgeOfFlightLine(boolean isAtEndOfScan) {
        this.ScanFlags = (byte)(this.ScanFlags & 0xFFFFFF7F);
        this.ScanFlags = (byte)(this.ScanFlags | (isAtEndOfScan ? 1 : 0) << 7 & 0x80);
    }

    @Override
    public byte getScanAngleRank() {
        return (byte)MyDefs.I8_CLAMP(MyDefs.I16_QUANTIZE(0.006f * (float)this.ScanAngle));
    }

    @Override
    public float getScanAngle() {
        return this.ScanAngle;
    }

    @Override
    public boolean hasClassificationFlag(ClassificationFlag flag) {
        switch (flag) {
            case Synthetic: {
                return (this.ScanFlags & 1) == 1;
            }
            case KeyPoint: {
                return (this.ScanFlags & 2) == 2;
            }
            case Withheld: {
                return (this.ScanFlags & 4) == 4;
            }
            case Overlap: {
                return (this.ScanFlags & 8) == 8;
            }
        }
        return false;
    }

    @Override
    public boolean hasScanFlag(ScanFlag flag) {
        switch (flag) {
            case ScanDirection: {
                return (this.ScanFlags & 0x40) == 64;
            }
            case EdgeOfFlightLine: {
                return (this.ScanFlags & 0x80) == 128;
            }
        }
        return false;
    }

    public String toString() {
        return String.format("Point14(%d): %.14g %d %d %d %d %d %d %d\n", this.CompressionContext, this.getGpsTime(), this.X, this.Y, this.Z, (int)this.Intensity, this.getReturnNumber(), this.getNumberOfReturns(), this.UserData);
    }

    @Override
    public double getGpsTime() {
        ByteBuffer buf = ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN);
        buf.putLong(this.GPSTime);
        return buf.getDouble(0);
    }

    @Override
    public void setGpsTime(double val) {
        ByteBuffer buf = ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN);
        buf.putDouble(val);
        this.GPSTime = buf.getLong(0);
    }
}

