/*
 * Decompiled with CFR 0.152.
 */
package com.github.mreutegg.laszip4j.laszip;

import com.github.mreutegg.laszip4j.laszip.ClassificationFlag;
import com.github.mreutegg.laszip4j.laszip.MyDefs;
import com.github.mreutegg.laszip4j.laszip.PointDataRecordXYZBase;
import com.github.mreutegg.laszip4j.laszip.ScanFlag;

class PointDataRecordPoint10
extends PointDataRecordXYZBase {
    public byte Flags = 0;
    public byte ScanAngleRank = 0;

    public PointDataRecordPoint10() {
    }

    public PointDataRecordPoint10(PointDataRecordPoint10 other) {
        this.X = other.X;
        this.Y = other.Y;
        this.Z = other.Z;
        this.Intensity = other.Intensity;
        this.Flags = other.Flags;
        this.Classification = other.Classification;
        this.ScanAngleRank = other.ScanAngleRank;
        this.UserData = other.UserData;
        this.PointSourceID = other.PointSourceID;
    }

    @Override
    public void setReturnNumber(byte returnNumber) {
        this.Flags = (byte)(this.Flags & 0xFFFFFFF8);
        this.Flags = (byte)(this.Flags | returnNumber & 7);
    }

    @Override
    public byte getReturnNumber() {
        return (byte)(this.Flags & 7);
    }

    @Override
    public void setNumberOfReturns(byte numberOfReturns) {
        this.Flags = (byte)(this.Flags & 0xFFFFFFC7);
        this.Flags = (byte)(this.Flags | numberOfReturns << 3 & 0x38);
    }

    @Override
    public byte getNumberOfReturns() {
        return (byte)(this.Flags >>> 3 & 7);
    }

    @Override
    public void setScanDirection(boolean isPositive) {
        this.Flags = (byte)(this.Flags & 0xFFFFFFBF);
        this.Flags = (byte)(this.Flags | (isPositive ? 1 : 0) << 6);
    }

    @Override
    public void setEdgeOfFlightLine(boolean isAtEndOfScan) {
        this.Flags = (byte)(this.Flags & 0xFFFFFF7F);
        this.Flags = (byte)(this.Flags | (isAtEndOfScan ? 1 : 0) << 7);
    }

    @Override
    public byte getScanAngleRank() {
        return this.ScanAngleRank;
    }

    @Override
    public float getScanAngle() {
        return MyDefs.I16_QUANTIZE((float)this.ScanAngleRank / 0.006f);
    }

    public String toString() {
        return String.format("Point10: %d %d %d %d %d %d %d %d %d ", this.X, this.Y, this.Z, (int)this.Intensity, this.Classification, this.ScanAngleRank, this.UserData, this.Flags, (int)this.PointSourceID);
    }

    @Override
    public boolean hasClassificationFlag(ClassificationFlag flag) {
        switch (flag) {
            case Synthetic: {
                return (this.Classification & 0x20) == 32;
            }
            case KeyPoint: {
                return (this.Classification & 0x40) == 64;
            }
            case Withheld: {
                return (this.Classification & 0x80) == 128;
            }
            case Overlap: {
                return false;
            }
        }
        return false;
    }

    @Override
    public boolean hasScanFlag(ScanFlag flag) {
        switch (flag) {
            case ScanDirection: {
                return (this.Flags & 0x40) == 64;
            }
            case EdgeOfFlightLine: {
                return (this.Flags & 0x80) == 128;
            }
        }
        return false;
    }
}

