/*
 * Decompiled with CFR 0.152.
 */
package com.github.mreutegg.laszip4j.laszip;

import com.github.mreutegg.laszip4j.laszip.LASattribute;
import java.nio.charset.StandardCharsets;

public interface MyDefs {
    public static final char U16_MAX = '\uffff';
    public static final int U32_MAX = -1;
    public static final int I32_MIN = Integer.MIN_VALUE;
    public static final byte U8_MIN = 0;
    public static final byte I8_MIN = -128;
    public static final byte U8_MAX = -1;
    public static final byte I8_MAX = 127;
    public static final byte U8_MAX_MINUS_ONE = -2;
    public static final char U8_MAX_PLUS_ONE = '\u0100';

    public static byte U8_FOLD(int n) {
        return (byte)(n < 0 ? n + 256 : (n > Byte.toUnsignedInt((byte)-1) ? n - 256 : n));
    }

    public static int U8_CLAMP(int n) {
        return (byte)(n <= 0 ? 0 : (byte)(n >= Byte.toUnsignedInt((byte)-1) ? -1 : (byte)n));
    }

    public static int I8_CLAMP(int n) {
        return (byte)(n <= -128 ? -128 : (byte)(n >= 127 ? 127 : (byte)n));
    }

    public static short I16_QUANTIZE(float n) {
        return n >= 0.0f ? (short)(n + 0.5f) : (short)(n - 0.5f);
    }

    public static int I32_QUANTIZE(double n) {
        return n >= 0.0 ? (int)(n + 0.5) : (int)(n - 0.5);
    }

    public static int U32_QUANTIZE(double n) {
        return n >= 0.0 ? (int)(n + 0.5) : 0;
    }

    public static int I32_FLOOR(double value) {
        return (int)Math.floor(value);
    }

    public static long I64_FLOOR(double value) {
        return (long)Math.floor(value);
    }

    public static int U32_ZERO_BIT_0(int n) {
        return n & 0xFFFFFFFE;
    }

    public static boolean IS_LITTLE_ENDIAN() {
        return false;
    }

    public static int sizeof(Class<LASattribute> attributeClass) {
        return LASattribute.getMemory();
    }

    public static byte[] asByteArray(char[] chars) {
        return MyDefs.asByteArray(new String(chars));
    }

    public static byte[] asByteArray(String s) {
        return s.getBytes(StandardCharsets.US_ASCII);
    }

    public static String stringFromByteArray(byte[] bytes) {
        int idx = -1;
        for (int i = 0; i < bytes.length; ++i) {
            if (bytes[i] != 0) continue;
            idx = i;
            break;
        }
        if (idx != -1) {
            return new String(bytes, 0, idx, StandardCharsets.US_ASCII);
        }
        return new String(bytes, StandardCharsets.US_ASCII);
    }

    public static int[] realloc(int[] data, int size) {
        if (data.length >= size) {
            return data;
        }
        int[] tmp = new int[size];
        System.arraycopy(data, 0, tmp, 0, data.length);
        return tmp;
    }

    public static long[] realloc(long[] data, int size) {
        if (data == null) {
            return new long[size];
        }
        if (data.length >= size) {
            return data;
        }
        long[] tmp = new long[size];
        System.arraycopy(data, 0, tmp, 0, data.length);
        return tmp;
    }
}

