/*
 * Decompiled with CFR 0.152.
 */
package com.github.mreutegg.laszip4j.laszip;

import com.github.mreutegg.laszip4j.laszip.ArithmeticEncoder;
import com.github.mreutegg.laszip4j.laszip.ByteStreamOut;
import com.github.mreutegg.laszip4j.laszip.IntegerCompressor;
import com.github.mreutegg.laszip4j.laszip.LASitem;
import com.github.mreutegg.laszip4j.laszip.LASwriteItem;
import com.github.mreutegg.laszip4j.laszip.LASwriteItemCompressed;
import com.github.mreutegg.laszip4j.laszip.LASwriteItemCompressed_BYTE14_v3;
import com.github.mreutegg.laszip4j.laszip.LASwriteItemCompressed_BYTE14_v4;
import com.github.mreutegg.laszip4j.laszip.LASwriteItemCompressed_BYTE_v1;
import com.github.mreutegg.laszip4j.laszip.LASwriteItemCompressed_BYTE_v2;
import com.github.mreutegg.laszip4j.laszip.LASwriteItemCompressed_GPSTIME11_v1;
import com.github.mreutegg.laszip4j.laszip.LASwriteItemCompressed_GPSTIME11_v2;
import com.github.mreutegg.laszip4j.laszip.LASwriteItemCompressed_POINT10_v1;
import com.github.mreutegg.laszip4j.laszip.LASwriteItemCompressed_POINT10_v2;
import com.github.mreutegg.laszip4j.laszip.LASwriteItemCompressed_POINT14_v3;
import com.github.mreutegg.laszip4j.laszip.LASwriteItemCompressed_POINT14_v4;
import com.github.mreutegg.laszip4j.laszip.LASwriteItemCompressed_RGB12_v1;
import com.github.mreutegg.laszip4j.laszip.LASwriteItemCompressed_RGB12_v2;
import com.github.mreutegg.laszip4j.laszip.LASwriteItemCompressed_RGB14_v3;
import com.github.mreutegg.laszip4j.laszip.LASwriteItemCompressed_RGB14_v4;
import com.github.mreutegg.laszip4j.laszip.LASwriteItemCompressed_RGBNIR14_v3;
import com.github.mreutegg.laszip4j.laszip.LASwriteItemCompressed_RGBNIR14_v4;
import com.github.mreutegg.laszip4j.laszip.LASwriteItemCompressed_WAVEPACKET13_v1;
import com.github.mreutegg.laszip4j.laszip.LASwriteItemCompressed_WAVEPACKET14_v3;
import com.github.mreutegg.laszip4j.laszip.LASwriteItemCompressed_WAVEPACKET14_v4;
import com.github.mreutegg.laszip4j.laszip.LASwriteItemRaw;
import com.github.mreutegg.laszip4j.laszip.LASwriteItemRaw_BYTE;
import com.github.mreutegg.laszip4j.laszip.LASwriteItemRaw_GPSTIME11;
import com.github.mreutegg.laszip4j.laszip.LASwriteItemRaw_POINT10;
import com.github.mreutegg.laszip4j.laszip.LASwriteItemRaw_POINT14;
import com.github.mreutegg.laszip4j.laszip.LASwriteItemRaw_RGB12;
import com.github.mreutegg.laszip4j.laszip.LASwriteItemRaw_RGBNIR14;
import com.github.mreutegg.laszip4j.laszip.LASwriteItemRaw_WAVEPACKET13;
import com.github.mreutegg.laszip4j.laszip.LASzip;
import com.github.mreutegg.laszip4j.laszip.PointDataRecord;

public class LASwritePoint {
    private ByteStreamOut outstream;
    private int num_writers;
    private LASwriteItem[] writers;
    private LASwriteItemRaw[] writers_raw;
    private LASwriteItemCompressed[] writers_compressed;
    private ArithmeticEncoder enc;
    private boolean layered_las14_compression;
    private int chunk_size;
    private int chunk_count;
    private int number_chunks;
    private int alloced_chunks;
    private int[] chunk_sizes;
    private int[] chunk_bytes;
    private long chunk_start_position;
    private long chunk_table_start_position;

    private boolean add_chunk_to_table() {
        if (this.number_chunks == this.alloced_chunks) {
            if (this.chunk_bytes == null) {
                this.alloced_chunks = 1024;
                if (this.chunk_size == -1) {
                    this.chunk_sizes = new int[this.alloced_chunks];
                }
                this.chunk_bytes = new int[this.alloced_chunks];
            } else {
                this.alloced_chunks *= 2;
                if (this.chunk_size == -1) {
                    this.chunk_sizes = new int[this.alloced_chunks];
                }
                this.chunk_bytes = new int[this.alloced_chunks];
            }
        }
        long position = this.outstream.tell();
        if (this.chunk_size == -1) {
            this.chunk_sizes[this.number_chunks] = this.chunk_count;
        }
        this.chunk_bytes[this.number_chunks] = (int)(position - this.chunk_start_position);
        this.chunk_start_position = position;
        ++this.number_chunks;
        return Boolean.TRUE;
    }

    private boolean write_chunk_table() {
        int version;
        long position = this.outstream.tell();
        if (this.chunk_table_start_position != -1L) {
            if (!this.outstream.seek(this.chunk_table_start_position)) {
                return Boolean.FALSE;
            }
            if (!this.outstream.put64bitsLE(position)) {
                return Boolean.FALSE;
            }
            if (!this.outstream.seek(position)) {
                return Boolean.FALSE;
            }
        }
        if (!this.outstream.put32bitsLE(version = 0)) {
            return Boolean.FALSE;
        }
        if (!this.outstream.put32bitsLE(this.number_chunks)) {
            return Boolean.FALSE;
        }
        if (this.number_chunks > 0) {
            this.enc.init(this.outstream);
            IntegerCompressor ic = new IntegerCompressor(this.enc, 32, 2);
            ic.initCompressor();
            int i = 0;
            while (Integer.compareUnsigned(i, this.number_chunks) < 0) {
                if (this.chunk_size == -1) {
                    ic.compress(i != 0 ? this.chunk_sizes[i - 1] : 0, this.chunk_sizes[i], 0);
                }
                ic.compress(i != 0 ? this.chunk_bytes[i - 1] : 0, this.chunk_bytes[i], 1);
                ++i;
            }
            this.enc.done();
        }
        if (this.chunk_table_start_position == -1L && !this.outstream.put64bitsLE(position)) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public boolean setup(int num_items, LASitem[] items) {
        return this.setup(num_items, items, null);
    }

    public boolean setup(int num_items, LASitem[] items, LASzip laszip) {
        if (laszip != null) {
            if (num_items == 0) {
                return Boolean.FALSE;
            }
            if (items == null) {
                return Boolean.FALSE;
            }
            if (num_items != laszip.num_items) {
                return Boolean.FALSE;
            }
            if (items != laszip.items) {
                return Boolean.FALSE;
            }
        }
        this.enc = null;
        if (laszip != null && laszip.compressor != '\u0000') {
            switch (laszip.coder) {
                case '\u0000': {
                    this.enc = new ArithmeticEncoder();
                    break;
                }
                default: {
                    return Boolean.FALSE;
                }
            }
            this.layered_las14_compression = laszip.compressor == '\u0003';
        }
        this.writers = null;
        this.num_writers = num_items;
        this.chunk_size = -1;
        this.writers_raw = new LASwriteItemRaw[this.num_writers];
        int i = 0;
        while (Integer.compareUnsigned(i, this.num_writers) < 0) {
            switch (items[i].type) {
                case POINT10: {
                    this.writers_raw[i] = new LASwriteItemRaw_POINT10();
                    break;
                }
                case GPSTIME11: {
                    this.writers_raw[i] = new LASwriteItemRaw_GPSTIME11();
                    break;
                }
                case RGB12: 
                case RGB14: {
                    this.writers_raw[i] = new LASwriteItemRaw_RGB12();
                    break;
                }
                case BYTE: 
                case BYTE14: {
                    this.writers_raw[i] = new LASwriteItemRaw_BYTE(items[i].size);
                    break;
                }
                case POINT14: {
                    this.writers_raw[i] = new LASwriteItemRaw_POINT14();
                    break;
                }
                case RGBNIR14: {
                    this.writers_raw[i] = new LASwriteItemRaw_RGBNIR14();
                    break;
                }
                case WAVEPACKET13: 
                case WAVEPACKET14: {
                    this.writers_raw[i] = new LASwriteItemRaw_WAVEPACKET13();
                    break;
                }
                default: {
                    return Boolean.FALSE;
                }
            }
            ++i;
        }
        if (this.enc != null) {
            this.writers_compressed = new LASwriteItemCompressed[this.num_writers];
            block25: for (i = 0; i < this.num_writers; ++i) {
                switch (items[i].type) {
                    case POINT10: {
                        if (items[i].version == '\u0001') {
                            this.writers_compressed[i] = new LASwriteItemCompressed_POINT10_v1(this.enc);
                            continue block25;
                        }
                        if (items[i].version == '\u0002') {
                            this.writers_compressed[i] = new LASwriteItemCompressed_POINT10_v2(this.enc);
                            continue block25;
                        }
                        return Boolean.FALSE;
                    }
                    case GPSTIME11: {
                        if (items[i].version == '\u0001') {
                            this.writers_compressed[i] = new LASwriteItemCompressed_GPSTIME11_v1(this.enc);
                            continue block25;
                        }
                        if (items[i].version == '\u0002') {
                            this.writers_compressed[i] = new LASwriteItemCompressed_GPSTIME11_v2(this.enc);
                            continue block25;
                        }
                        return Boolean.FALSE;
                    }
                    case RGB12: {
                        if (items[i].version == '\u0001') {
                            this.writers_compressed[i] = new LASwriteItemCompressed_RGB12_v1(this.enc);
                            continue block25;
                        }
                        if (items[i].version == '\u0002') {
                            this.writers_compressed[i] = new LASwriteItemCompressed_RGB12_v2(this.enc);
                            continue block25;
                        }
                        return Boolean.FALSE;
                    }
                    case BYTE: {
                        if (items[i].version == '\u0001') {
                            this.writers_compressed[i] = new LASwriteItemCompressed_BYTE_v1(this.enc, items[i].size);
                            continue block25;
                        }
                        if (items[i].version == '\u0002') {
                            this.writers_compressed[i] = new LASwriteItemCompressed_BYTE_v2(this.enc, items[i].size);
                            continue block25;
                        }
                        return Boolean.FALSE;
                    }
                    case POINT14: {
                        if (items[i].version == '\u0003') {
                            this.writers_compressed[i] = new LASwriteItemCompressed_POINT14_v3(this.enc);
                            continue block25;
                        }
                        if (items[i].version == '\u0004') {
                            this.writers_compressed[i] = new LASwriteItemCompressed_POINT14_v4(this.enc);
                            continue block25;
                        }
                        return Boolean.FALSE;
                    }
                    case RGB14: {
                        if (items[i].version == '\u0003') {
                            this.writers_compressed[i] = new LASwriteItemCompressed_RGB14_v3(this.enc);
                            continue block25;
                        }
                        if (items[i].version == '\u0004') {
                            this.writers_compressed[i] = new LASwriteItemCompressed_RGB14_v4(this.enc);
                            continue block25;
                        }
                        return Boolean.FALSE;
                    }
                    case RGBNIR14: {
                        if (items[i].version == '\u0003') {
                            this.writers_compressed[i] = new LASwriteItemCompressed_RGBNIR14_v3(this.enc);
                            continue block25;
                        }
                        if (items[i].version == '\u0004') {
                            this.writers_compressed[i] = new LASwriteItemCompressed_RGBNIR14_v4(this.enc);
                            continue block25;
                        }
                        return Boolean.FALSE;
                    }
                    case BYTE14: {
                        if (items[i].version == '\u0003') {
                            this.writers_compressed[i] = new LASwriteItemCompressed_BYTE14_v3(this.enc, items[i].size);
                            continue block25;
                        }
                        if (items[i].version == '\u0004') {
                            this.writers_compressed[i] = new LASwriteItemCompressed_BYTE14_v4(this.enc, items[i].size);
                            continue block25;
                        }
                        return Boolean.FALSE;
                    }
                    case WAVEPACKET13: {
                        if (items[i].version == '\u0001') {
                            this.writers_compressed[i] = new LASwriteItemCompressed_WAVEPACKET13_v1(this.enc);
                            continue block25;
                        }
                        return Boolean.FALSE;
                    }
                    case WAVEPACKET14: {
                        if (items[i].version == '\u0003') {
                            this.writers_compressed[i] = new LASwriteItemCompressed_WAVEPACKET14_v3(this.enc);
                            continue block25;
                        }
                        if (items[i].version == '\u0004') {
                            this.writers_compressed[i] = new LASwriteItemCompressed_WAVEPACKET14_v4(this.enc);
                            continue block25;
                        }
                        return Boolean.FALSE;
                    }
                    default: {
                        return Boolean.FALSE;
                    }
                }
            }
            if (laszip.compressor != '\u0001') {
                if (laszip.chunk_size != 0) {
                    this.chunk_size = laszip.chunk_size;
                }
                this.chunk_count = 0;
                this.number_chunks = -1;
            }
        }
        return Boolean.TRUE;
    }

    public boolean init(ByteStreamOut outstream) {
        if (outstream == null) {
            return Boolean.FALSE;
        }
        this.outstream = outstream;
        if (this.number_chunks == -1) {
            this.number_chunks = 0;
            this.chunk_table_start_position = outstream.isSeekable() ? outstream.tell() : -1L;
            outstream.put64bitsLE(this.chunk_table_start_position);
            this.chunk_start_position = outstream.tell();
        }
        int i = 0;
        while (Integer.compareUnsigned(i, this.num_writers) < 0) {
            this.writers_raw[i].init(outstream);
            ++i;
        }
        this.writers = this.enc != null ? null : this.writers_raw;
        return Boolean.TRUE;
    }

    public boolean write(PointDataRecord[] pointRecords) {
        int i;
        int context = 0;
        if (this.chunk_count == this.chunk_size) {
            if (this.enc != null) {
                if (this.layered_las14_compression) {
                    this.outstream.put32bitsLE(this.chunk_count);
                    for (i = 0; i < this.num_writers; ++i) {
                        ((LASwriteItemCompressed)this.writers[i]).chunk_sizes();
                    }
                    for (i = 0; i < this.num_writers; ++i) {
                        ((LASwriteItemCompressed)this.writers[i]).chunk_bytes();
                    }
                } else {
                    this.enc.done();
                }
                this.add_chunk_to_table();
                this.init(this.outstream);
            } else assert (this.chunk_size == -1);
            this.chunk_count = 0;
        }
        ++this.chunk_count;
        if (this.writers != null) {
            for (i = 0; i < this.num_writers; ++i) {
                if (this.writers[i].write(pointRecords[i], context)) continue;
                return Boolean.FALSE;
            }
        } else {
            for (i = 0; i < this.num_writers; ++i) {
                if (!this.writers_raw[i].write(pointRecords[i], context)) {
                    return Boolean.FALSE;
                }
                this.writers_compressed[i].init(pointRecords[i], context);
            }
            this.writers = this.writers_compressed;
            assert (this.enc != null);
            this.enc.init(this.outstream);
        }
        return Boolean.TRUE;
    }

    public boolean chunk() {
        if (this.chunk_start_position == 0L || this.chunk_size != -1) {
            return Boolean.FALSE;
        }
        if (this.layered_las14_compression) {
            this.outstream.put32bitsLE(this.chunk_count);
            int i = 0;
            while (Integer.compareUnsigned(i, this.num_writers) < 0) {
                ((LASwriteItemCompressed)this.writers[i]).chunk_sizes();
                ++i;
            }
            for (i = 0; i < this.num_writers; ++i) {
                ((LASwriteItemCompressed)this.writers[i]).chunk_bytes();
            }
        } else {
            this.enc.done();
        }
        this.add_chunk_to_table();
        this.init(this.outstream);
        this.chunk_count = 0;
        return Boolean.TRUE;
    }

    public boolean done() {
        if (this.writers == this.writers_compressed) {
            if (this.layered_las14_compression) {
                int i;
                this.outstream.put32bitsLE(this.chunk_count);
                for (i = 0; i < this.num_writers; ++i) {
                    ((LASwriteItemCompressed)this.writers[i]).chunk_sizes();
                }
                for (i = 0; i < this.num_writers; ++i) {
                    ((LASwriteItemCompressed)this.writers[i]).chunk_bytes();
                }
            } else {
                this.enc.done();
            }
            if (this.chunk_start_position != 0L) {
                if (this.chunk_count != 0) {
                    this.add_chunk_to_table();
                }
                return this.write_chunk_table();
            }
        } else if (this.writers == null && this.chunk_start_position != 0L) {
            return this.write_chunk_table();
        }
        return Boolean.TRUE;
    }
}

