/*
 * Decompiled with CFR 0.152.
 */
package com.github.mreutegg.laszip4j.laszip;

import com.github.mreutegg.laszip4j.laszip.ArithmeticDecoder;
import com.github.mreutegg.laszip4j.laszip.ByteStreamIn;
import com.github.mreutegg.laszip4j.laszip.ByteStreamInArray;
import com.github.mreutegg.laszip4j.laszip.IByteStreamInProvider;
import com.github.mreutegg.laszip4j.laszip.IntegerCompressor;
import com.github.mreutegg.laszip4j.laszip.LAScontextWAVEPACKET14;
import com.github.mreutegg.laszip4j.laszip.LASreadItemCompressed;
import com.github.mreutegg.laszip4j.laszip.PointDataRecord;
import com.github.mreutegg.laszip4j.laszip.PointDataRecordWavepacket;

public class LASreadItemCompressed_WAVEPACKET14_v3
extends LASreadItemCompressed {
    private IByteStreamInProvider instreamProvider;
    private ByteStreamInArray instream_wavepacket;
    private ArithmeticDecoder dec_wavepacket;
    boolean changed_wavepacket;
    int num_bytes_wavepacket;
    boolean requested_wavepacket;
    int current_context;
    private LAScontextWAVEPACKET14[] contexts = new LAScontextWAVEPACKET14[4];

    public LASreadItemCompressed_WAVEPACKET14_v3(IByteStreamInProvider instreamProvider, int decompress_selective) {
        assert (instreamProvider != null);
        this.instreamProvider = instreamProvider;
        this.instream_wavepacket = null;
        this.dec_wavepacket = null;
        this.num_bytes_wavepacket = 0;
        this.changed_wavepacket = false;
        this.requested_wavepacket = (decompress_selective & 0x400) != 0;
        for (int c = 0; c < this.contexts.length; ++c) {
            this.contexts[c] = new LAScontextWAVEPACKET14();
            this.contexts[c].m_packet_index = null;
        }
        this.current_context = 0;
    }

    @Override
    public void init(PointDataRecord seedItem, int context) {
        ByteStreamIn instream = this.instreamProvider.getByteStreamIn();
        if (this.instream_wavepacket == null) {
            this.instream_wavepacket = new ByteStreamInArray();
            this.dec_wavepacket = new ArithmeticDecoder();
        }
        if (this.requested_wavepacket) {
            if (this.num_bytes_wavepacket != 0) {
                byte[] bytes = new byte[this.num_bytes_wavepacket];
                instream.getBytes(bytes, this.num_bytes_wavepacket);
                this.instream_wavepacket.init(bytes, this.num_bytes_wavepacket);
                this.dec_wavepacket.init(this.instream_wavepacket);
                this.changed_wavepacket = true;
            } else {
                this.instream_wavepacket.init(null, 0L);
                this.changed_wavepacket = false;
            }
        } else {
            if (this.num_bytes_wavepacket != 0) {
                instream.skipBytes(this.num_bytes_wavepacket);
            }
            this.changed_wavepacket = false;
        }
        for (int c = 0; c < 4; ++c) {
            this.contexts[c].unused = true;
        }
        this.current_context = context;
        this.createAndInitModelsAndDecompressors(this.current_context, (PointDataRecordWavepacket)seedItem);
    }

    @Override
    public boolean chunk_sizes() {
        ByteStreamIn instream = this.instreamProvider.getByteStreamIn();
        this.num_bytes_wavepacket = instream.get32bitsLE();
        return true;
    }

    @Override
    public PointDataRecord read(int context) {
        PointDataRecordWavepacket last_item = this.contexts[this.current_context].last_item;
        if (this.current_context != context) {
            this.current_context = context;
            if (this.contexts[this.current_context].unused) {
                this.createAndInitModelsAndDecompressors(this.current_context, last_item);
            }
            last_item = this.contexts[this.current_context].last_item;
        }
        PointDataRecordWavepacket result = new PointDataRecordWavepacket();
        if (this.changed_wavepacket) {
            result.DescriptorIndex = (byte)this.dec_wavepacket.decodeSymbol(this.contexts[this.current_context].m_packet_index);
            this.contexts[this.current_context].sym_last_offset_diff = this.dec_wavepacket.decodeSymbol(this.contexts[this.current_context].m_offset_diff[this.contexts[this.current_context].sym_last_offset_diff]);
            if (this.contexts[this.current_context].sym_last_offset_diff == 0) {
                result.OffsetToWaveformData = last_item.OffsetToWaveformData;
            } else if (this.contexts[this.current_context].sym_last_offset_diff == 1) {
                result.OffsetToWaveformData = last_item.OffsetToWaveformData + last_item.PacketSize;
            } else if (this.contexts[this.current_context].sym_last_offset_diff == 2) {
                this.contexts[this.current_context].last_diff_32 = this.contexts[this.current_context].ic_offset_diff.decompress(this.contexts[this.current_context].last_diff_32);
                result.OffsetToWaveformData = last_item.OffsetToWaveformData + (long)this.contexts[this.current_context].last_diff_32;
            } else {
                result.OffsetToWaveformData = this.dec_wavepacket.readInt64();
            }
            result.PacketSize = this.contexts[this.current_context].ic_packet_size.decompress((int)last_item.PacketSize);
            result.setReturnPointWaveformLocation(this.contexts[this.current_context].ic_return_point.decompress(last_item.getReturnPointWaveformLocationAsInt()));
            result.setDx(this.contexts[this.current_context].ic_xyz.decompress(last_item.getDxAsInt(), 0));
            result.setDy(this.contexts[this.current_context].ic_xyz.decompress(last_item.getDyAsInt(), 1));
            result.setDz(this.contexts[this.current_context].ic_xyz.decompress(last_item.getDzAsInt(), 2));
            last_item = new PointDataRecordWavepacket(result);
        }
        return result;
    }

    private boolean createAndInitModelsAndDecompressors(int context, PointDataRecordWavepacket seedItem) {
        assert (this.contexts[context].unused);
        if (this.requested_wavepacket) {
            if (this.contexts[context].m_packet_index == null) {
                this.contexts[context].m_packet_index = this.dec_wavepacket.createSymbolModel(256);
                this.contexts[context].m_offset_diff[0] = this.dec_wavepacket.createSymbolModel(4);
                this.contexts[context].m_offset_diff[1] = this.dec_wavepacket.createSymbolModel(4);
                this.contexts[context].m_offset_diff[2] = this.dec_wavepacket.createSymbolModel(4);
                this.contexts[context].m_offset_diff[3] = this.dec_wavepacket.createSymbolModel(4);
                this.contexts[context].ic_offset_diff = new IntegerCompressor(this.dec_wavepacket, 32);
                this.contexts[context].ic_packet_size = new IntegerCompressor(this.dec_wavepacket, 32);
                this.contexts[context].ic_return_point = new IntegerCompressor(this.dec_wavepacket, 32);
                this.contexts[context].ic_xyz = new IntegerCompressor(this.dec_wavepacket, 32, 3);
            }
            this.dec_wavepacket.initSymbolModel(this.contexts[context].m_packet_index);
            this.dec_wavepacket.initSymbolModel(this.contexts[context].m_offset_diff[0]);
            this.dec_wavepacket.initSymbolModel(this.contexts[context].m_offset_diff[1]);
            this.dec_wavepacket.initSymbolModel(this.contexts[context].m_offset_diff[2]);
            this.dec_wavepacket.initSymbolModel(this.contexts[context].m_offset_diff[3]);
            this.contexts[context].ic_offset_diff.initDecompressor();
            this.contexts[context].ic_packet_size.initDecompressor();
            this.contexts[context].ic_return_point.initDecompressor();
            this.contexts[context].ic_xyz.initDecompressor();
        }
        this.contexts[context].last_diff_32 = 0;
        this.contexts[context].sym_last_offset_diff = 0;
        this.contexts[context].last_item = new PointDataRecordWavepacket(seedItem);
        this.contexts[context].unused = false;
        return true;
    }
}

