/*
 * Decompiled with CFR 0.152.
 */
package com.github.mreutegg.laszip4j.laszip;

import com.github.mreutegg.laszip4j.laszip.ArithmeticDecoder;
import com.github.mreutegg.laszip4j.laszip.ArithmeticModel;
import com.github.mreutegg.laszip4j.laszip.IntegerCompressor;
import com.github.mreutegg.laszip4j.laszip.LASreadItemCompressed;
import com.github.mreutegg.laszip4j.laszip.PointDataRecord;
import com.github.mreutegg.laszip4j.laszip.PointDataRecordWavepacket;

public class LASreadItemCompressed_WAVEPACKET13_v1
extends LASreadItemCompressed {
    private ArithmeticDecoder dec;
    private PointDataRecordWavepacket last_item;
    private int last_diff_32;
    private int sym_last_offset_diff;
    private ArithmeticModel m_packet_index;
    private ArithmeticModel[] m_offset_diff = new ArithmeticModel[4];
    private IntegerCompressor ic_offset_diff;
    private IntegerCompressor ic_packet_size;
    private IntegerCompressor ic_return_point;
    private IntegerCompressor ic_xyz;

    public LASreadItemCompressed_WAVEPACKET13_v1(ArithmeticDecoder dec) {
        assert (dec != null);
        this.dec = dec;
        this.m_packet_index = dec.createSymbolModel(256);
        this.m_offset_diff[0] = dec.createSymbolModel(4);
        this.m_offset_diff[1] = dec.createSymbolModel(4);
        this.m_offset_diff[2] = dec.createSymbolModel(4);
        this.m_offset_diff[3] = dec.createSymbolModel(4);
        this.ic_offset_diff = new IntegerCompressor(dec, 32);
        this.ic_packet_size = new IntegerCompressor(dec, 32);
        this.ic_return_point = new IntegerCompressor(dec, 32);
        this.ic_xyz = new IntegerCompressor(dec, 32, 3);
        this.last_item = null;
    }

    @Override
    public void init(PointDataRecord seedItem, int notUsed) {
        this.last_diff_32 = 0;
        this.sym_last_offset_diff = 0;
        this.dec.initSymbolModel(this.m_packet_index);
        this.dec.initSymbolModel(this.m_offset_diff[0]);
        this.dec.initSymbolModel(this.m_offset_diff[1]);
        this.dec.initSymbolModel(this.m_offset_diff[2]);
        this.dec.initSymbolModel(this.m_offset_diff[3]);
        this.ic_offset_diff.initDecompressor();
        this.ic_packet_size.initDecompressor();
        this.ic_return_point.initDecompressor();
        this.ic_xyz.initDecompressor();
        this.last_item = new PointDataRecordWavepacket((PointDataRecordWavepacket)seedItem);
    }

    @Override
    public PointDataRecord read(int notUsed) {
        PointDataRecordWavepacket result = new PointDataRecordWavepacket();
        result.DescriptorIndex = (short)this.dec.decodeSymbol(this.m_packet_index);
        this.sym_last_offset_diff = this.dec.decodeSymbol(this.m_offset_diff[this.sym_last_offset_diff]);
        if (this.sym_last_offset_diff == 0) {
            result.OffsetToWaveformData = this.last_item.OffsetToWaveformData;
        } else if (this.sym_last_offset_diff == 1) {
            result.OffsetToWaveformData = this.last_item.OffsetToWaveformData + this.last_item.PacketSize;
        } else if (this.sym_last_offset_diff == 2) {
            this.last_diff_32 = this.ic_offset_diff.decompress(this.last_diff_32);
            result.OffsetToWaveformData = this.last_item.OffsetToWaveformData + (long)this.last_diff_32;
        } else {
            result.OffsetToWaveformData = this.dec.readInt64();
        }
        result.PacketSize = this.ic_packet_size.decompress((int)this.last_item.PacketSize);
        result.setReturnPointWaveformLocation(this.ic_return_point.decompress(this.last_item.getReturnPointWaveformLocationAsInt()));
        result.setDx(this.ic_xyz.decompress(this.last_item.getDxAsInt(), 0));
        result.setDy(this.ic_xyz.decompress(this.last_item.getDyAsInt(), 1));
        result.setDz(this.ic_xyz.decompress(this.last_item.getDzAsInt(), 2));
        this.last_item = new PointDataRecordWavepacket(result);
        return result;
    }

    @Override
    public boolean chunk_sizes() {
        return false;
    }
}

