/*
 * Decompiled with CFR 0.152.
 */
package com.github.mreutegg.laszip4j.laszip;

import com.github.mreutegg.laszip4j.laszip.ArithmeticDecoder;
import com.github.mreutegg.laszip4j.laszip.ArithmeticModel;
import com.github.mreutegg.laszip4j.laszip.Common_v2;
import com.github.mreutegg.laszip4j.laszip.IntegerCompressor;
import com.github.mreutegg.laszip4j.laszip.LASreadItemCompressed;
import com.github.mreutegg.laszip4j.laszip.MyDefs;
import com.github.mreutegg.laszip4j.laszip.PointDataRecord;
import com.github.mreutegg.laszip4j.laszip.PointDataRecordPoint10;
import com.github.mreutegg.laszip4j.laszip.ScanFlag;
import com.github.mreutegg.laszip4j.laszip.StreamingMedian5;

public class LASreadItemCompressed_POINT10_v2
extends LASreadItemCompressed {
    private ArithmeticDecoder dec;
    private PointDataRecordPoint10 last_item = null;
    private int[] last_intensity = new int[16];
    private StreamingMedian5[] last_x_diff_median5 = StreamingMedian5.newStreamingMedian5(16);
    private StreamingMedian5[] last_y_diff_median5 = StreamingMedian5.newStreamingMedian5(16);
    private long[] last_height = new long[8];
    private ArithmeticModel m_changed_values;
    private IntegerCompressor ic_intensity;
    private ArithmeticModel[] m_scan_angle_rank = new ArithmeticModel[2];
    private IntegerCompressor ic_point_source_ID;
    private ArithmeticModel[] m_bit_byte = new ArithmeticModel[256];
    private ArithmeticModel[] m_classification = new ArithmeticModel[256];
    private ArithmeticModel[] m_user_data = new ArithmeticModel[256];
    private IntegerCompressor ic_dx;
    private IntegerCompressor ic_dy;
    private IntegerCompressor ic_z;

    public LASreadItemCompressed_POINT10_v2(ArithmeticDecoder dec) {
        assert (dec != null);
        this.dec = dec;
        this.m_changed_values = dec.createSymbolModel(64);
        this.ic_intensity = new IntegerCompressor(dec, 16, 4);
        this.m_scan_angle_rank[0] = dec.createSymbolModel(256);
        this.m_scan_angle_rank[1] = dec.createSymbolModel(256);
        this.ic_point_source_ID = new IntegerCompressor(dec, 16);
        for (int i = 0; i < 256; ++i) {
            this.m_bit_byte[i] = null;
            this.m_classification[i] = null;
            this.m_user_data[i] = null;
        }
        this.ic_dx = new IntegerCompressor(dec, 32, 2);
        this.ic_dy = new IntegerCompressor(dec, 32, 22);
        this.ic_z = new IntegerCompressor(dec, 32, 20);
    }

    @Override
    public void init(PointDataRecord seedItem, int notUsed) {
        int i;
        for (i = 0; i < 16; ++i) {
            this.last_x_diff_median5[i].init();
            this.last_y_diff_median5[i].init();
            this.last_intensity[i] = 0;
            this.last_height[i / 2] = 0L;
        }
        this.dec.initSymbolModel(this.m_changed_values);
        this.ic_intensity.initDecompressor();
        this.dec.initSymbolModel(this.m_scan_angle_rank[0]);
        this.dec.initSymbolModel(this.m_scan_angle_rank[1]);
        this.ic_point_source_ID.initDecompressor();
        for (i = 0; i < 256; ++i) {
            if (this.m_bit_byte[i] != null) {
                this.dec.initSymbolModel(this.m_bit_byte[i]);
            }
            if (this.m_classification[i] != null) {
                this.dec.initSymbolModel(this.m_classification[i]);
            }
            if (this.m_user_data[i] == null) continue;
            this.dec.initSymbolModel(this.m_user_data[i]);
        }
        this.ic_dx.initDecompressor();
        this.ic_dy.initDecompressor();
        this.ic_z.initDecompressor();
        this.last_item = new PointDataRecordPoint10((PointDataRecordPoint10)seedItem);
        this.last_item.Intensity = '\u0000';
    }

    @Override
    public PointDataRecord read(int notUsed) {
        byte l;
        int m;
        byte n;
        int changed_values = this.dec.decodeSymbol(this.m_changed_values);
        if (changed_values != 0) {
            if ((changed_values & 0x20) != 0) {
                int idx = Byte.toUnsignedInt(this.last_item.Flags);
                if (this.m_bit_byte[idx] == null) {
                    this.m_bit_byte[idx] = this.dec.createSymbolModel(256);
                    this.dec.initSymbolModel(this.m_bit_byte[idx]);
                }
                this.last_item.Flags = (byte)this.dec.decodeSymbol(this.m_bit_byte[idx]);
            }
            byte r = this.last_item.getReturnNumber();
            n = this.last_item.getNumberOfReturns();
            m = Common_v2.number_return_map[n][r];
            l = Common_v2.number_return_level[n][r];
            if ((changed_values & 0x10) != 0) {
                this.last_item.Intensity = (char)this.ic_intensity.decompress(this.last_intensity[m], m < 3 ? m : 3);
                this.last_intensity[m] = this.last_item.Intensity;
            } else {
                this.last_item.Intensity = (char)this.last_intensity[m];
            }
            if ((changed_values & 8) != 0) {
                if (this.m_classification[this.last_item.Classification] == null) {
                    this.m_classification[this.last_item.Classification] = this.dec.createSymbolModel(256);
                    this.dec.initSymbolModel(this.m_classification[this.last_item.Classification]);
                }
                this.last_item.Classification = (short)this.dec.decodeSymbol(this.m_classification[this.last_item.Classification]);
            }
            if ((changed_values & 4) != 0) {
                int val = this.dec.decodeSymbol(this.m_scan_angle_rank[this.last_item.hasScanFlag(ScanFlag.ScanDirection) ? 1 : 0]);
                this.last_item.ScanAngleRank = MyDefs.U8_FOLD(val + this.last_item.ScanAngleRank);
            }
            if ((changed_values & 2) != 0) {
                if (this.m_user_data[this.last_item.UserData] == null) {
                    this.m_user_data[this.last_item.UserData] = this.dec.createSymbolModel(256);
                    this.dec.initSymbolModel(this.m_user_data[this.last_item.UserData]);
                }
                this.last_item.UserData = (short)this.dec.decodeSymbol(this.m_user_data[this.last_item.UserData]);
            }
            if ((changed_values & 1) != 0) {
                this.last_item.PointSourceID = (char)this.ic_point_source_ID.decompress(this.last_item.PointSourceID);
            }
        } else {
            byte r = this.last_item.getReturnNumber();
            n = this.last_item.getNumberOfReturns();
            m = Common_v2.number_return_map[n][r];
            l = Common_v2.number_return_level[n][r];
        }
        int median = this.last_x_diff_median5[m].get();
        int diff = this.ic_dx.decompress(median, n == 1 ? 1 : 0);
        this.last_item.X += diff;
        this.last_x_diff_median5[m].add(diff);
        median = this.last_y_diff_median5[m].get();
        int k_bits = this.ic_dx.getK();
        diff = this.ic_dy.decompress(median, (n == 1 ? 1 : 0) + (k_bits < 20 ? MyDefs.U32_ZERO_BIT_0(k_bits) : 20));
        this.last_item.Y += diff;
        this.last_y_diff_median5[m].add(diff);
        k_bits = (this.ic_dx.getK() + this.ic_dy.getK()) / 2;
        this.last_item.Z = this.ic_z.decompress((int)this.last_height[l], (n == 1 ? 1 : 0) + (k_bits < 18 ? MyDefs.U32_ZERO_BIT_0(k_bits) : 18));
        this.last_height[l] = this.last_item.Z;
        PointDataRecordPoint10 result = new PointDataRecordPoint10(this.last_item);
        return result;
    }

    @Override
    public boolean chunk_sizes() {
        return false;
    }
}

