/*
 * Decompiled with CFR 0.152.
 */
package com.github.mreutegg.laszip4j.laszip;

import com.github.mreutegg.laszip4j.laszip.ArithmeticDecoder;
import com.github.mreutegg.laszip4j.laszip.ArithmeticModel;
import com.github.mreutegg.laszip4j.laszip.LASreadItemCompressed;
import com.github.mreutegg.laszip4j.laszip.MyDefs;
import com.github.mreutegg.laszip4j.laszip.PointDataRecord;
import com.github.mreutegg.laszip4j.laszip.PointDataRecordBytes;

public class LASreadItemCompressed_BYTE_v2
extends LASreadItemCompressed {
    private ArithmeticDecoder dec;
    private int number;
    private PointDataRecordBytes last_item;
    private ArithmeticModel[] m_byte;

    public LASreadItemCompressed_BYTE_v2(ArithmeticDecoder dec, int number) {
        assert (dec != null);
        this.dec = dec;
        assert (number != 0);
        this.number = number;
        this.m_byte = new ArithmeticModel[number];
        for (int i = 0; i < number; ++i) {
            this.m_byte[i] = dec.createSymbolModel(256);
        }
    }

    @Override
    public void init(PointDataRecord seedItem, int notUsed) {
        for (int i = 0; i < this.number; ++i) {
            this.dec.initSymbolModel(this.m_byte[i]);
        }
        this.last_item = new PointDataRecordBytes((PointDataRecordBytes)seedItem);
    }

    @Override
    public PointDataRecord read(int notUsed) {
        PointDataRecordBytes result = new PointDataRecordBytes(this.number);
        for (int i = 0; i < this.number; ++i) {
            int value = this.last_item.Bytes[i] + this.dec.decodeSymbol(this.m_byte[i]);
            result.Bytes[i] = MyDefs.U8_FOLD(value);
        }
        return result;
    }

    @Override
    public boolean chunk_sizes() {
        return false;
    }
}

