/*
 * Decompiled with CFR 0.152.
 */
package com.github.mreutegg.laszip4j.laszip;

public class LASquantizer {
    public double x_scale_factor;
    public double y_scale_factor;
    public double z_scale_factor;
    public double x_offset;
    public double y_offset;
    public double z_offset;

    public double get_x(int X) {
        return this.x_scale_factor * (double)X + this.x_offset;
    }

    public double get_y(int Y) {
        return this.y_scale_factor * (double)Y + this.y_offset;
    }

    public double get_z(int Z) {
        return this.z_scale_factor * (double)Z + this.z_offset;
    }

    public int get_X(double x) {
        if (x >= this.x_offset) {
            return (int)((x - this.x_offset) / this.x_scale_factor + 0.5);
        }
        return (int)((x - this.x_offset) / this.x_scale_factor - 0.5);
    }

    public int get_Y(double y) {
        if (y >= this.y_offset) {
            return (int)((y - this.y_offset) / this.y_scale_factor + 0.5);
        }
        return (int)((y - this.y_offset) / this.y_scale_factor - 0.5);
    }

    public int get_Z(double z) {
        if (z >= this.z_offset) {
            return (int)((z - this.z_offset) / this.z_scale_factor + 0.5);
        }
        return (int)((z - this.z_offset) / this.z_scale_factor - 0.5);
    }

    public LASquantizer() {
        this.x_scale_factor = 0.01;
        this.y_scale_factor = 0.01;
        this.z_scale_factor = 0.01;
        this.x_offset = 0.0;
        this.y_offset = 0.0;
        this.z_offset = 0.0;
    }

    LASquantizer(LASquantizer other) {
        this.x_scale_factor = other.x_scale_factor;
        this.y_scale_factor = other.y_scale_factor;
        this.z_scale_factor = other.z_scale_factor;
        this.x_offset = other.x_offset;
        this.y_offset = other.y_offset;
        this.z_offset = other.z_offset;
    }
}

