/*
 * Decompiled with CFR 0.152.
 */
package com.github.mreutegg.laszip4j.laszip;

public class LASitem {
    public Type type;
    public char size;
    public char version;

    public LASitem() {
    }

    public LASitem(Type type, int size, int version) {
        this.type = type;
        this.size = (char)size;
        this.version = (char)version;
    }

    public static LASitem Point10(int ver) {
        return new LASitem(Type.POINT10, 20, ver);
    }

    public static LASitem GpsTime11(int ver) {
        return new LASitem(Type.GPSTIME11, 8, ver);
    }

    public static LASitem Rgb12(int ver) {
        return new LASitem(Type.RGB12, 6, ver);
    }

    public static LASitem WavePacket13(int ver) {
        return new LASitem(Type.WAVEPACKET13, 29, ver);
    }

    public static LASitem Point14(int ver) {
        return new LASitem(Type.POINT14, 30, ver);
    }

    public static LASitem RgbNIR14(int ver) {
        return new LASitem(Type.RGBNIR14, 8, ver);
    }

    public static LASitem ExtraBytes(int size, int ver) {
        return new LASitem(Type.BYTE, size, ver);
    }

    public static LASitem Rgb14(int ver) {
        return new LASitem(Type.RGB14, 6, ver);
    }

    public static LASitem WavePacket14(int ver) {
        return new LASitem(Type.WAVEPACKET14, 29, ver);
    }

    public static LASitem ExtraBytes14(int size, int ver) {
        return new LASitem(Type.BYTE14, size, ver);
    }

    boolean is_type(Type t) {
        if (t != this.type) {
            return false;
        }
        switch (t) {
            case POINT10: {
                if (this.size == '\u0014') break;
                return false;
            }
            case POINT14: {
                if (this.size == '\u001e') break;
                return false;
            }
            case GPSTIME11: {
                if (this.size == '\b') break;
                return false;
            }
            case RGB12: 
            case RGB14: {
                if (this.size == '\u0006') break;
                return false;
            }
            case RGBNIR14: {
                if (this.size == '\b') break;
                return false;
            }
            case WAVEPACKET13: 
            case WAVEPACKET14: {
                if (this.size == '\u001d') break;
                return false;
            }
            case BYTE: 
            case BYTE14: {
                if (this.size >= '\u0001') break;
                return false;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    String get_name() {
        switch (this.type) {
            case POINT10: {
                return "POINT10";
            }
            case POINT14: {
                return "POINT14";
            }
            case GPSTIME11: {
                return "GPSTIME11";
            }
            case RGB12: {
                return "RGB12";
            }
            case BYTE: {
                return "BYTE";
            }
            case RGB14: {
                return "RGB14";
            }
            case RGBNIR14: {
                return "RGBNIR14";
            }
            case BYTE14: {
                return "BYTE14";
            }
            case WAVEPACKET13: {
                return "WAVEPACKET13";
            }
            case WAVEPACKET14: {
                return "WAVEPACKET14";
            }
        }
        return null;
    }

    public static enum Type {
        BYTE,
        SHORT,
        INT,
        LONG,
        FLOAT,
        DOUBLE,
        POINT10,
        GPSTIME11,
        RGB12,
        WAVEPACKET13,
        POINT14,
        RGB14,
        RGBNIR14,
        WAVEPACKET14,
        BYTE14;

        private static final Type[] TYPES;

        public static Type fromOrdinal(int i) {
            return TYPES[i];
        }

        static {
            TYPES = Type.values();
        }
    }
}

