/*
 * Decompiled with CFR 0.152.
 */
package com.github.mreutegg.laszip4j.laszip;

import com.github.mreutegg.laszip4j.clib.Cstdio;
import com.github.mreutegg.laszip4j.clib.Cstring;
import com.github.mreutegg.laszip4j.laszip.ByteStreamIn;
import com.github.mreutegg.laszip4j.laszip.ByteStreamOut;
import com.github.mreutegg.laszip4j.laszip.LASintervalCell;
import com.github.mreutegg.laszip4j.laszip.LASintervalStartCell;
import com.github.mreutegg.laszip4j.laszip.MyDefs;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.IntStream;

public class LASinterval {
    private static final PrintStream stderr = System.err;
    public int index;
    public int start;
    public int end;
    public int full;
    public int total;
    private SortedMap<Integer, LASintervalStartCell> cells = new TreeMap<Integer, LASintervalStartCell>();
    private Set<LASintervalCell> cells_to_merge = null;
    private int threshold;
    private int number_intervals;
    private int last_index;
    private LASintervalStartCell last_cell;
    private LASintervalCell current_cell;
    private LASintervalStartCell merged_cells;
    private boolean merged_cells_temporary;

    public LASinterval() {
        this(1000);
    }

    boolean add(int p_index, int c_index) {
        if (this.last_cell == null || this.last_index != c_index) {
            this.last_index = c_index;
            LASintervalStartCell value = (LASintervalStartCell)this.cells.get(c_index);
            if (value == null) {
                this.last_cell = new LASintervalStartCell(p_index);
                this.cells.put(c_index, this.last_cell);
                ++this.number_intervals;
                return Boolean.TRUE;
            }
            this.last_cell = value;
        }
        if (this.last_cell.add(p_index, this.threshold)) {
            ++this.number_intervals;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    int get_number_cells() {
        return this.cells.size();
    }

    int get_number_intervals() {
        return this.number_intervals;
    }

    boolean merge_cells(int num_indices, int[] indices, int new_index) {
        if (num_indices == 1) {
            LASintervalStartCell value = (LASintervalStartCell)this.cells.get(indices[0]);
            if (value == null) {
                return Boolean.FALSE;
            }
            this.cells.put(new_index, value);
            this.cells.remove(indices[0]);
        } else {
            if (this.cells_to_merge != null) {
                this.cells_to_merge.clear();
            }
            for (int i = 0; i < num_indices; ++i) {
                this.add_cell_to_merge_cell_set(indices[i], Boolean.TRUE);
            }
            if (!this.merge(Boolean.TRUE)) {
                return Boolean.FALSE;
            }
            this.cells.put(new_index, this.merged_cells);
            this.merged_cells = null;
        }
        return Boolean.TRUE;
    }

    void merge_intervals(int maximum_intervals, boolean verbose) {
        int diff;
        LASintervalCell cell;
        maximum_intervals = maximum_intervals < this.get_number_cells() ? 0 : (maximum_intervals -= this.get_number_cells());
        TreeMap<Integer, List<LASintervalCell>> map = new TreeMap<Integer, List<LASintervalCell>>();
        Iterator<LASintervalStartCell> iterator = this.cells.values().iterator();
        while (iterator.hasNext()) {
            LASintervalCell c2;
            cell = c2 = (LASintervalCell)iterator.next();
            while (cell.next != null) {
                diff = cell.next.start - cell.end - 1;
                LASinterval.insert(map, diff, cell);
                cell = cell.next;
            }
        }
        diff = (Integer)map.firstKey();
        int size = LASinterval.size(map);
        if (size <= maximum_intervals) {
            if (verbose) {
                Cstdio.fprintf(stderr, "next largest interval gap is %d\n", diff);
            }
            return;
        }
        while (size > maximum_intervals) {
            Map.Entry map_element = map.entrySet().iterator().next();
            diff = (Integer)map_element.getKey();
            cell = (LASintervalCell)((List)map_element.getValue()).remove(0);
            if (((List)map_element.getValue()).isEmpty()) {
                map.remove(diff);
            }
            if (cell.start == 1 && cell.end == 0) {
                --this.number_intervals;
                continue;
            }
            LASintervalCell delete_cell = cell.next;
            cell.end = delete_cell.end;
            cell.next = delete_cell.next;
            if (cell.next != null) {
                LASinterval.insert(map, cell.next.start - cell.end - 1, cell);
                delete_cell.start = 1;
                delete_cell.end = 0;
            } else {
                --this.number_intervals;
            }
            --size;
        }
        map.values().stream().flatMap(Collection::stream).forEach(c -> {
            if (c.start == 1 && c.end == 0) {
                --this.number_intervals;
            }
        });
        Cstdio.fprintf(stderr, "largest interval gap increased to %d\n", diff);
        Iterator<LASintervalStartCell> iterator2 = this.cells.values().iterator();
        while (iterator2.hasNext()) {
            LASintervalStartCell c3;
            LASintervalStartCell start_cell = c3 = iterator2.next();
            start_cell.total = 0;
            cell = start_cell;
            while (cell != null) {
                start_cell.total += cell.end - cell.start + 1;
                cell = cell.next;
            }
        }
    }

    void get_cells() {
        this.last_index = Integer.MIN_VALUE;
        this.current_cell = null;
    }

    boolean has_cells() {
        Iterator<Map.Entry<Integer, LASintervalStartCell>> hash_element;
        if (this.last_index == Integer.MIN_VALUE) {
            hash_element = this.cells.entrySet().iterator();
        } else {
            hash_element = this.cells.tailMap(this.last_index).entrySet().iterator();
            if (hash_element.hasNext()) {
                hash_element.next();
            }
        }
        if (!hash_element.hasNext()) {
            this.last_index = Integer.MIN_VALUE;
            this.current_cell = null;
            return Boolean.FALSE;
        }
        Map.Entry<Integer, LASintervalStartCell> entry = hash_element.next();
        this.last_index = entry.getKey();
        this.index = entry.getKey();
        this.full = entry.getValue().full;
        this.total = entry.getValue().total;
        this.current_cell = entry.getValue();
        return Boolean.TRUE;
    }

    boolean get_cell(int c_index) {
        LASintervalStartCell value = (LASintervalStartCell)this.cells.get(c_index);
        if (value == null) {
            this.current_cell = null;
            return Boolean.FALSE;
        }
        this.index = c_index;
        this.full = value.full;
        this.total = value.total;
        this.current_cell = value;
        return Boolean.TRUE;
    }

    boolean add_current_cell_to_merge_cell_set() {
        if (this.current_cell == null) {
            return Boolean.FALSE;
        }
        if (this.cells_to_merge == null) {
            this.cells_to_merge = new HashSet<LASintervalCell>();
        }
        this.cells_to_merge.add(this.current_cell);
        return Boolean.TRUE;
    }

    boolean add_cell_to_merge_cell_set(int c_index, boolean erase) {
        LASintervalStartCell value = (LASintervalStartCell)this.cells.get(c_index);
        if (value == null) {
            return Boolean.FALSE;
        }
        if (this.cells_to_merge == null) {
            this.cells_to_merge = new HashSet<LASintervalCell>();
        }
        this.cells_to_merge.add(value);
        if (erase) {
            this.cells.remove(c_index);
        }
        return Boolean.TRUE;
    }

    boolean merge() {
        return this.merge(false);
    }

    boolean merge(boolean erase) {
        if (this.merged_cells != null) {
            if (this.merged_cells_temporary) {
                LASintervalCell next = this.merged_cells.next;
                while (next != null) {
                    LASintervalCell next_next;
                    next = next_next = next.next;
                }
            }
            this.merged_cells = null;
        }
        if (this.cells_to_merge == null) {
            return Boolean.FALSE;
        }
        if (this.cells_to_merge.size() == 0) {
            return Boolean.FALSE;
        }
        if (this.cells_to_merge.size() == 1) {
            this.merged_cells_temporary = Boolean.FALSE;
            this.merged_cells = (LASintervalStartCell)this.cells_to_merge.iterator().next();
        } else {
            LASintervalCell cell;
            this.merged_cells_temporary = Boolean.TRUE;
            this.merged_cells = new LASintervalStartCell();
            TreeMap<Integer, List<LASintervalCell>> map = new TreeMap<Integer, List<LASintervalCell>>();
            Iterator<LASintervalCell> iterator = this.cells_to_merge.iterator();
            while (iterator.hasNext()) {
                LASintervalCell c;
                cell = c = iterator.next();
                this.merged_cells.full += ((LASintervalStartCell)cell).full;
                while (cell != null) {
                    LASinterval.insert(map, cell.start, cell);
                    cell = cell.next;
                }
            }
            List list = (List)map.values().iterator().next();
            cell = (LASintervalCell)list.remove(0);
            if (list.isEmpty()) {
                map.remove(map.firstKey());
            }
            this.merged_cells.start = cell.start;
            this.merged_cells.end = cell.end;
            this.merged_cells.total = cell.end - cell.start + 1;
            LASintervalCell last_cell = this.merged_cells;
            while (!map.isEmpty()) {
                int diff;
                list = (List)map.values().iterator().next();
                cell = (LASintervalCell)list.remove(0);
                if (list.isEmpty()) {
                    map.remove(map.firstKey());
                }
                if ((diff = cell.start - last_cell.end) > this.threshold) {
                    last_cell.next = new LASintervalCell(cell);
                    last_cell = last_cell.next;
                    this.merged_cells.total += cell.end - cell.start + 1;
                    continue;
                }
                diff = cell.end - last_cell.end;
                if (diff > 0) {
                    last_cell.end = cell.end;
                    this.merged_cells.total += diff;
                }
                --this.number_intervals;
            }
        }
        this.current_cell = this.merged_cells;
        this.full = this.merged_cells.full;
        this.total = this.merged_cells.total;
        return Boolean.TRUE;
    }

    void clear_merge_cell_set() {
        if (this.cells_to_merge != null) {
            this.cells_to_merge.clear();
        }
    }

    boolean get_merged_cell() {
        if (this.merged_cells != null) {
            this.full = this.merged_cells.full;
            this.total = this.merged_cells.total;
            this.current_cell = this.merged_cells;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    boolean has_intervals() {
        if (this.current_cell != null) {
            this.start = this.current_cell.start;
            this.end = this.current_cell.end;
            this.current_cell = this.current_cell.next;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    LASinterval(int threshold) {
        this.threshold = threshold;
        this.number_intervals = 0;
        this.last_index = Integer.MIN_VALUE;
        this.last_cell = null;
        this.current_cell = null;
        this.merged_cells = null;
        this.merged_cells_temporary = Boolean.FALSE;
    }

    boolean read(ByteStreamIn stream) {
        byte[] signature = new byte[4];
        try {
            stream.getBytes(signature, 4);
        }
        catch (Exception e) {
            Cstdio.fprintf(stderr, "ERROR (LASinterval): reading signature\n", new Object[0]);
            return Boolean.FALSE;
        }
        if (Cstring.strncmp(MyDefs.stringFromByteArray(signature), "LASV", 4) != 0) {
            Cstdio.fprintf(stderr, "ERROR (LASinterval): wrong signature %4s instead of 'LASV'\n", MyDefs.stringFromByteArray(signature));
            return Boolean.FALSE;
        }
        try {
            int version = stream.get32bitsLE();
        }
        catch (Exception e) {
            Cstdio.fprintf(stderr, "ERROR (LASinterval): reading version\n", new Object[0]);
            return Boolean.FALSE;
        }
        try {
        }
        catch (Exception e) {
            Cstdio.fprintf(stderr, "ERROR (LASinterval): reading number of cells\n", new Object[0]);
            return Boolean.FALSE;
        }
        for (int number_cells = stream.get32bitsLE(); number_cells != 0; --number_cells) {
            int number_points;
            int number_intervals;
            int cell_index;
            try {
                cell_index = stream.get32bitsLE();
            }
            catch (Exception e) {
                Cstdio.fprintf(stderr, "ERROR (LASinterval): reading cell index\n", new Object[0]);
                return Boolean.FALSE;
            }
            LASintervalStartCell start_cell = new LASintervalStartCell();
            this.cells.put(cell_index, start_cell);
            LASintervalCell cell = start_cell;
            try {
                number_intervals = stream.get32bitsLE();
            }
            catch (Exception e) {
                Cstdio.fprintf(stderr, "ERROR (LASinterval): reading number of intervals in cell\n", new Object[0]);
                return Boolean.FALSE;
            }
            try {
                number_points = stream.get32bitsLE();
            }
            catch (Exception e) {
                Cstdio.fprintf(stderr, "ERROR (LASinterval): reading number of points in cell\n", new Object[0]);
                return Boolean.FALSE;
            }
            start_cell.full = number_points;
            start_cell.total = 0;
            while (number_intervals != 0) {
                try {
                    cell.start = stream.get32bitsLE();
                }
                catch (Exception e) {
                    Cstdio.fprintf(stderr, "ERROR (LASinterval): reading start %d of interval\n", cell.start);
                    return Boolean.FALSE;
                }
                try {
                    cell.end = stream.get32bitsLE();
                }
                catch (Exception e) {
                    Cstdio.fprintf(stderr, "ERROR (LASinterval): reading end %d of interval\n", cell.end);
                    return Boolean.FALSE;
                }
                start_cell.total += cell.end - cell.start + 1;
                if (--number_intervals == 0) continue;
                cell.next = new LASintervalCell();
                cell = cell.next;
            }
        }
        return Boolean.TRUE;
    }

    boolean write(ByteStreamOut stream) {
        if (!stream.putBytes(MyDefs.asByteArray("LASV"), 4)) {
            Cstdio.fprintf(stderr, "ERROR (LASinterval): writing signature\n", new Object[0]);
            return Boolean.FALSE;
        }
        int version = 0;
        if (!stream.put32bitsLE(version)) {
            Cstdio.fprintf(stderr, "ERROR (LASinterval): writing version\n", new Object[0]);
            return Boolean.FALSE;
        }
        int number_cells = this.cells.size();
        if (!stream.put32bitsLE(number_cells)) {
            Cstdio.fprintf(stderr, "ERROR (LASinterval): writing number of cells %d\n", number_cells);
            return Boolean.FALSE;
        }
        for (Map.Entry<Integer, LASintervalStartCell> entry : this.cells.entrySet()) {
            LASintervalCell cell = entry.getValue();
            int number_intervals = 0;
            int number_points = ((LASintervalStartCell)cell).full;
            while (cell != null) {
                ++number_intervals;
                cell = cell.next;
            }
            int cell_index = entry.getKey();
            if (!stream.put32bitsLE(cell_index)) {
                Cstdio.fprintf(stderr, "ERROR (LASinterval): writing cell index %d\n", cell_index);
                return Boolean.FALSE;
            }
            if (!stream.put32bitsLE(number_intervals)) {
                Cstdio.fprintf(stderr, "ERROR (LASinterval): writing number of intervals %d in cell\n", number_intervals);
                return Boolean.FALSE;
            }
            if (!stream.put32bitsLE(number_points)) {
                Cstdio.fprintf(stderr, "ERROR (LASinterval): writing number of points %d in cell\n", number_points);
                return Boolean.FALSE;
            }
            cell = entry.getValue();
            while (cell != null) {
                if (!stream.put32bitsLE(cell.start)) {
                    Cstdio.fprintf(stderr, "ERROR (LASinterval): writing start %d of interval\n", cell.start);
                    return Boolean.FALSE;
                }
                if (!stream.put32bitsLE(cell.end)) {
                    Cstdio.fprintf(stderr, "ERROR (LASinterval): writing end %d of interval\n", cell.end);
                    return Boolean.FALSE;
                }
                cell = cell.next;
            }
        }
        return Boolean.TRUE;
    }

    private static int size(SortedMap<Integer, List<LASintervalCell>> map) {
        return map.values().stream().flatMapToInt(objects -> IntStream.of(objects.size())).sum();
    }

    private static void insert(SortedMap<Integer, List<LASintervalCell>> map, Integer key, LASintervalCell value) {
        ArrayList<LASintervalCell> cells = (ArrayList<LASintervalCell>)map.get(key);
        if (cells == null) {
            cells = new ArrayList<LASintervalCell>();
            map.put(key, cells);
        }
        cells.add(value);
    }
}

