/*
 * Decompiled with CFR 0.152.
 */
package com.github.mreutegg.laszip4j.laszip;

import com.github.mreutegg.laszip4j.laszip.ByteStreamInDataInput;
import java.io.DataInput;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UncheckedIOException;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;

public class ByteStreamInFile
extends ByteStreamInDataInput {
    private final RandomAccessFile file;
    private final RandomAccessDataInput in;

    public ByteStreamInFile(RandomAccessFile file) {
        super(ByteStreamInFile.createRandomAccessDataInput(file));
        this.file = file;
        this.in = (RandomAccessDataInput)this.dataIn;
    }

    private static RandomAccessDataInput createRandomAccessDataInput(RandomAccessFile file) {
        long length;
        try {
            length = file.length();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        if (length > Integer.MAX_VALUE) {
            return new RandomAccessFileDataInput(file);
        }
        return new MMappedDataInput(file);
    }

    @Override
    public boolean isSeekable() {
        return true;
    }

    @Override
    public long tell() {
        return this.in.position();
    }

    @Override
    public boolean seek(long position) {
        this.in.position(position);
        return true;
    }

    @Override
    public boolean seekEnd(long distance) {
        try {
            long len = this.file.length();
            if (0L <= distance && distance <= len) {
                this.in.position(len - distance);
                return true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public void close() throws IOException {
        this.file.close();
    }

    private static class RandomAccessFileDataInput
    extends RandomAccessDataInput {
        private final RandomAccessFile file;

        RandomAccessFileDataInput(RandomAccessFile file) {
            this.file = file;
        }

        @Override
        public void readFully(byte[] b, int off, int len) throws IOException {
            this.file.readFully(b, off, len);
        }

        @Override
        public int skipBytes(int n) throws IOException {
            long pos = this.file.getFilePointer();
            long remaining = this.file.length() - pos;
            long skip = Math.min(remaining, (long)n);
            this.position(pos + skip);
            return (int)skip;
        }

        @Override
        public byte readByte() throws IOException {
            return this.file.readByte();
        }

        @Override
        public long position() {
            try {
                return this.file.getFilePointer();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        @Override
        public void position(long position) {
            try {
                this.file.seek(position);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    private static class MMappedDataInput
    extends RandomAccessDataInput {
        private final MappedByteBuffer buffer;

        MMappedDataInput(RandomAccessFile file) {
            try {
                this.buffer = file.getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, file.length());
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        @Override
        public void readFully(byte[] b, int off, int len) {
            this.buffer.get(b, off, len);
        }

        @Override
        public int skipBytes(int n) {
            int skip = Math.min(this.buffer.remaining(), n);
            this.buffer.position(this.buffer.position() + skip);
            return skip;
        }

        @Override
        public byte readByte() {
            return this.buffer.get();
        }

        @Override
        public long position() {
            return this.buffer.position();
        }

        @Override
        public void position(long position) {
            if (position > Integer.MAX_VALUE) {
                throw new IllegalArgumentException("position > 2147483647: " + position);
            }
            this.buffer.position((int)position);
        }
    }

    private static abstract class RandomAccessDataInput
    implements DataInput {
        private RandomAccessDataInput() {
        }

        @Override
        public void readFully(byte[] b) throws IOException {
            this.readFully(b, 0, b.length);
        }

        @Override
        public boolean readBoolean() throws IOException {
            return this.readByte() != 0;
        }

        @Override
        public float readFloat() {
            throw new UnsupportedOperationException();
        }

        @Override
        public double readDouble() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String readLine() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String readUTF() {
            throw new UnsupportedOperationException();
        }

        @Override
        public short readShort() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int readUnsignedShort() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int readUnsignedByte() throws IOException {
            return Byte.toUnsignedInt(this.readByte());
        }

        @Override
        public char readChar() throws IOException {
            int ch1 = this.readUnsignedByte();
            int ch2 = this.readUnsignedByte();
            return (char)((ch1 << 8) + ch2);
        }

        @Override
        public int readInt() throws IOException {
            int ch1 = this.readUnsignedByte();
            int ch2 = this.readUnsignedByte();
            int ch3 = this.readUnsignedByte();
            int ch4 = this.readUnsignedByte();
            return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + ch4;
        }

        @Override
        public long readLong() throws IOException {
            return ((long)this.readInt() << 32) + ((long)this.readInt() & 0xFFFFFFFFL);
        }

        abstract long position();

        abstract void position(long var1);
    }
}

