/*
 * Decompiled with CFR 0.152.
 */
package com.github.mreutegg.laszip4j.laslib;

import com.github.mreutegg.laszip4j.clib.Cstdio;
import com.github.mreutegg.laszip4j.clib.Cstring;
import com.github.mreutegg.laszip4j.laslib.LASevlr;
import com.github.mreutegg.laszip4j.laslib.LASheader;
import com.github.mreutegg.laszip4j.laslib.LASwriter;
import com.github.mreutegg.laszip4j.laszip.ByteStreamOut;
import com.github.mreutegg.laszip4j.laszip.ByteStreamOutArray;
import com.github.mreutegg.laszip4j.laszip.ByteStreamOutFile;
import com.github.mreutegg.laszip4j.laszip.ByteStreamOutOstream;
import com.github.mreutegg.laszip4j.laszip.LASattributer;
import com.github.mreutegg.laszip4j.laszip.LASpoint;
import com.github.mreutegg.laszip4j.laszip.LASwritePoint;
import com.github.mreutegg.laszip4j.laszip.LASzip;
import com.github.mreutegg.laszip4j.laszip.MyDefs;
import java.io.IOException;
import java.io.PrintStream;
import java.io.RandomAccessFile;

public class LASwriterLAS
extends LASwriter {
    private static final PrintStream stderr = System.err;
    private RandomAccessFile file = null;
    private ByteStreamOut stream = null;
    private boolean delete_stream = Boolean.TRUE;
    private LASwritePoint writer = null;
    private long header_start_position;
    private boolean writing_las_1_4 = Boolean.FALSE;
    private boolean writing_new_point_type = Boolean.FALSE;
    private long start_of_first_extended_variable_length_record = 0L;
    private int number_of_extended_variable_length_records = 0;
    private LASevlr[] evlrs = null;

    @Override
    public boolean write_point(LASpoint point) {
        ++this.p_count;
        return this.writer.write(point.PointRecords);
    }

    @Override
    public boolean chunk() {
        return this.writer.chunk();
    }

    @Override
    public boolean update_header(LASheader header, boolean use_inventory, boolean update_extra_bytes) {
        int i;
        int number;
        if (header == null) {
            Cstdio.fprintf(stderr, "ERROR: header pointer is zero\n", new Object[0]);
            return Boolean.FALSE;
        }
        if (this.stream == null) {
            Cstdio.fprintf(stderr, "ERROR: stream pointer is zero\n", new Object[0]);
            return Boolean.FALSE;
        }
        if (!this.stream.isSeekable()) {
            Cstdio.fprintf(stderr, "WARNING: stream not seekable. cannot update header.\n", new Object[0]);
            return Boolean.FALSE;
        }
        if (use_inventory) {
            this.stream.seek(this.header_start_position + 107L);
            if (header.point_data_format >= 6) {
                number = 0;
            } else if (this.inventory.extended_number_of_point_records > Integer.toUnsignedLong(-1)) {
                if (header.version_minor >= 4) {
                    number = 0;
                } else {
                    Cstdio.fprintf(stderr, "WARNING: too many points in LAS %d.%d file. limit is %d.\n", header.version_major, header.version_minor, Integer.toUnsignedLong(-1));
                    number = -1;
                }
            } else {
                number = (int)this.inventory.extended_number_of_point_records;
            }
            if (!this.stream.put32bitsLE(number)) {
                Cstdio.fprintf(stderr, "ERROR: updating inventory.number_of_point_records\n", new Object[0]);
                return Boolean.FALSE;
            }
            this.npoints = this.inventory.extended_number_of_point_records;
            for (i = 0; i < 5; ++i) {
                number = header.point_data_format >= 6 ? 0 : (this.inventory.extended_number_of_points_by_return[i + 1] > Integer.toUnsignedLong(-1) ? (header.version_minor >= 4 ? 0 : -1) : (int)this.inventory.extended_number_of_points_by_return[i + 1]);
                if (this.stream.put32bitsLE(number)) continue;
                Cstdio.fprintf(stderr, "ERROR: updating inventory.number_of_points_by_return[%d]\n", i);
                return Boolean.FALSE;
            }
            this.stream.seek(this.header_start_position + 179L);
            double value = this.quantizer.get_x(this.inventory.max_X);
            if (!this.stream.put64bitsLE(Double.doubleToLongBits(value))) {
                Cstdio.fprintf(stderr, "ERROR: updating inventory.max_X\n", new Object[0]);
                return Boolean.FALSE;
            }
            value = this.quantizer.get_x(this.inventory.min_X);
            if (!this.stream.put64bitsLE(Double.doubleToLongBits(value))) {
                Cstdio.fprintf(stderr, "ERROR: updating inventory.min_X\n", new Object[0]);
                return Boolean.FALSE;
            }
            value = this.quantizer.get_y(this.inventory.max_Y);
            if (!this.stream.put64bitsLE(Double.doubleToLongBits(value))) {
                Cstdio.fprintf(stderr, "ERROR: updating inventory.max_Y\n", new Object[0]);
                return Boolean.FALSE;
            }
            value = this.quantizer.get_y(this.inventory.min_Y);
            if (!this.stream.put64bitsLE(Double.doubleToLongBits(value))) {
                Cstdio.fprintf(stderr, "ERROR: updating inventory.min_Y\n", new Object[0]);
                return Boolean.FALSE;
            }
            value = this.quantizer.get_z(this.inventory.max_Z);
            if (!this.stream.put64bitsLE(Double.doubleToLongBits(value))) {
                Cstdio.fprintf(stderr, "ERROR: updating inventory.max_Z\n", new Object[0]);
                return Boolean.FALSE;
            }
            value = this.quantizer.get_z(this.inventory.min_Z);
            if (!this.stream.put64bitsLE(Double.doubleToLongBits(value))) {
                Cstdio.fprintf(stderr, "ERROR: updating inventory.min_Z\n", new Object[0]);
                return Boolean.FALSE;
            }
            if (header.version_minor >= 4) {
                this.stream.seek(this.header_start_position + 247L);
                if (!this.stream.put64bitsLE(this.inventory.extended_number_of_point_records)) {
                    Cstdio.fprintf(stderr, "ERROR: updating header->extended_number_of_point_records\n", new Object[0]);
                    return Boolean.FALSE;
                }
                for (i = 0; i < 15; ++i) {
                    if (this.stream.put64bitsLE(this.inventory.extended_number_of_points_by_return[i + 1])) continue;
                    Cstdio.fprintf(stderr, "ERROR: updating header->extended_number_of_points_by_return[%d]\n", i);
                    return Boolean.FALSE;
                }
            }
        } else {
            this.stream.seek(this.header_start_position + 107L);
            number = header.point_data_format >= 6 ? 0 : header.number_of_point_records;
            if (!this.stream.put32bitsLE(number)) {
                Cstdio.fprintf(stderr, "ERROR: updating header->number_of_point_records\n", new Object[0]);
                return Boolean.FALSE;
            }
            this.npoints = header.number_of_point_records;
            for (i = 0; i < 5; ++i) {
                number = header.point_data_format >= 6 ? 0 : header.number_of_points_by_return[i];
                if (this.stream.put32bitsLE(number)) continue;
                Cstdio.fprintf(stderr, "ERROR: updating header->number_of_points_by_return[%d]\n", i);
                return Boolean.FALSE;
            }
            this.stream.seek(this.header_start_position + 179L);
            if (!this.stream.put64bitsLE(Double.doubleToLongBits(header.max_x))) {
                Cstdio.fprintf(stderr, "ERROR: updating header->max_x\n", new Object[0]);
                return Boolean.FALSE;
            }
            if (!this.stream.put64bitsLE(Double.doubleToLongBits(header.min_x))) {
                Cstdio.fprintf(stderr, "ERROR: updating header->min_x\n", new Object[0]);
                return Boolean.FALSE;
            }
            if (!this.stream.put64bitsLE(Double.doubleToLongBits(header.max_y))) {
                Cstdio.fprintf(stderr, "ERROR: updating header->max_y\n", new Object[0]);
                return Boolean.FALSE;
            }
            if (!this.stream.put64bitsLE(Double.doubleToLongBits(header.min_y))) {
                Cstdio.fprintf(stderr, "ERROR: updating header->min_y\n", new Object[0]);
                return Boolean.FALSE;
            }
            if (!this.stream.put64bitsLE(Double.doubleToLongBits(header.max_z))) {
                Cstdio.fprintf(stderr, "ERROR: updating header->max_z\n", new Object[0]);
                return Boolean.FALSE;
            }
            if (!this.stream.put64bitsLE(Double.doubleToLongBits(header.min_z))) {
                Cstdio.fprintf(stderr, "ERROR: updating header->min_z\n", new Object[0]);
                return Boolean.FALSE;
            }
            if (header.version_minor >= 3) {
                if (header.start_of_waveform_data_packet_record != 0L) {
                    Cstdio.fprintf(stderr, "WARNING: header->start_of_waveform_data_packet_record is %d. writing 0 instead.\n", header.start_of_waveform_data_packet_record);
                    long start_of_waveform_data_packet_record = 0L;
                    if (!this.stream.put64bitsLE(start_of_waveform_data_packet_record)) {
                        Cstdio.fprintf(stderr, "ERROR: updating start_of_waveform_data_packet_record\n", new Object[0]);
                        return Boolean.FALSE;
                    }
                } else if (!this.stream.put64bitsLE(header.start_of_waveform_data_packet_record)) {
                    Cstdio.fprintf(stderr, "ERROR: updating header->start_of_waveform_data_packet_record\n", new Object[0]);
                    return Boolean.FALSE;
                }
            }
            if (header.version_minor >= 4) {
                this.stream.seek(this.header_start_position + 235L);
                if (!this.stream.put64bitsLE(header.start_of_first_extended_variable_length_record)) {
                    Cstdio.fprintf(stderr, "ERROR: updating header->start_of_first_extended_variable_length_record\n", new Object[0]);
                    return Boolean.FALSE;
                }
                if (!this.stream.put32bitsLE(header.number_of_extended_variable_length_records)) {
                    Cstdio.fprintf(stderr, "ERROR: updating header->number_of_extended_variable_length_records\n", new Object[0]);
                    return Boolean.FALSE;
                }
                long value = header.number_of_point_records != 0 ? (long)header.number_of_point_records : header.extended_number_of_point_records;
                if (!this.stream.put64bitsLE(value)) {
                    Cstdio.fprintf(stderr, "ERROR: updating header->extended_number_of_point_records\n", new Object[0]);
                    return Boolean.FALSE;
                }
                for (i = 0; i < 15; ++i) {
                    value = i < 5 && header.number_of_points_by_return[i] != 0 ? (long)header.number_of_points_by_return[i] : header.extended_number_of_points_by_return[i];
                    if (this.stream.put64bitsLE(value)) continue;
                    Cstdio.fprintf(stderr, "ERROR: updating header->extended_number_of_points_by_return[%d]\n", i);
                    return Boolean.FALSE;
                }
            }
        }
        this.stream.seekEnd();
        if (update_extra_bytes) {
            if (header == null) {
                Cstdio.fprintf(stderr, "ERROR: header pointer is zero\n", new Object[0]);
                return Boolean.FALSE;
            }
            if (header.number_attributes != 0) {
                long start = this.header_start_position + (long)header.header_size;
                for (i = 0; i < header.number_of_variable_length_records; ++i) {
                    start += 54L;
                    if (header.vlrs[i].record_id == '\u0004' && Cstring.strcmp(header.vlrs[i].user_id, "LASF_Spec") == 0) break;
                    start += (long)header.vlrs[i].record_length_after_header;
                }
                if (i == header.number_of_variable_length_records) {
                    Cstdio.fprintf(stderr, "WARNING: could not find extra bytes VLR for update\n", new Object[0]);
                } else {
                    this.stream.seek(start);
                    if (!this.stream.putBytes(header.vlrs[i].data, header.vlrs[i].record_length_after_header)) {
                        Cstdio.fprintf(stderr, "ERROR: writing %d bytes of data from header->vlrs[%d].data\n", Character.valueOf(header.vlrs[i].record_length_after_header), i);
                        return Boolean.FALSE;
                    }
                }
            }
            this.stream.seekEnd();
        }
        return Boolean.TRUE;
    }

    @Override
    public long close(boolean update_npoints) {
        long bytes = 0L;
        if (!(this.p_count == this.npoints || this.npoints == 0L && update_npoints)) {
            Cstdio.fprintf(stderr, "WARNING: written %lld points but expected %d points\n", this.p_count, this.npoints);
        }
        if (this.writer != null) {
            this.writer.done();
            this.writer = null;
        }
        if (this.writing_las_1_4 && this.number_of_extended_variable_length_records != 0) {
            long real_start_of_first_extended_variable_length_record = this.stream.tell();
            for (int i = 0; i < this.number_of_extended_variable_length_records; ++i) {
                if (this.evlrs[i].reserved != '\uaabb') {
                    // empty if block
                }
                if (!this.stream.put16bitsLE(this.evlrs[i].reserved)) {
                    Cstdio.fprintf(stderr, "ERROR: writing evlrs[%d].reserved\n", i);
                    return 0L;
                }
                if (!this.stream.putBytes(this.evlrs[i].user_id, 16)) {
                    Cstdio.fprintf(stderr, "ERROR: writing evlrs[%d].user_id\n", i);
                    return 0L;
                }
                if (!this.stream.put16bitsLE(this.evlrs[i].record_id)) {
                    Cstdio.fprintf(stderr, "ERROR: writing evlrs[%d].record_id\n", i);
                    return 0L;
                }
                if (!this.stream.put64bitsLE(this.evlrs[i].record_length_after_header)) {
                    Cstdio.fprintf(stderr, "ERROR: writing evlrs[%d].record_length_after_header\n", i);
                    return 0L;
                }
                if (!this.stream.putBytes(this.evlrs[i].description, 32)) {
                    Cstdio.fprintf(stderr, "ERROR: writing evlrs[%d].description\n", i);
                    return 0L;
                }
                if (this.evlrs[i].record_length_after_header == 0L) continue;
                if (this.evlrs[i].data != null) {
                    if (this.stream.putBytes(this.evlrs[i].data, (int)this.evlrs[i].record_length_after_header)) continue;
                    Cstdio.fprintf(stderr, "ERROR: writing %d bytes of data from evlrs[%d].data\n", this.evlrs[i].record_length_after_header, i);
                    return 0L;
                }
                Cstdio.fprintf(stderr, "ERROR: there should be %d bytes of data in evlrs[%d].data\n", this.evlrs[i].record_length_after_header, i);
                return 0L;
            }
            if (real_start_of_first_extended_variable_length_record != this.start_of_first_extended_variable_length_record) {
                this.stream.seek(this.header_start_position + 235L);
                this.stream.put64bitsLE(real_start_of_first_extended_variable_length_record);
                this.stream.seekEnd();
            }
        }
        if (this.stream != null) {
            if (update_npoints && this.p_count != this.npoints) {
                if (!this.stream.isSeekable()) {
                    Cstdio.fprintf(stderr, "WARNING: stream not seekable. cannot update header from %d to %d points.\n", this.npoints, this.p_count);
                } else {
                    int number = this.writing_new_point_type ? 0 : (this.p_count > Integer.toUnsignedLong(-1) ? (this.writing_las_1_4 ? 0 : -1) : (int)this.p_count);
                    this.stream.seek(this.header_start_position + 107L);
                    this.stream.put32bitsLE(number);
                    if (this.writing_las_1_4) {
                        this.stream.seek(this.header_start_position + 235L + 12L);
                        this.stream.put64bitsLE(this.p_count);
                    }
                    this.stream.seekEnd();
                }
            }
            bytes = this.stream.tell() - this.header_start_position;
            if (this.delete_stream) {
                try {
                    this.stream.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            this.stream = null;
        }
        if (this.file != null) {
            Cstdio.fclose(this.file);
            this.file = null;
        }
        this.npoints = this.p_count;
        this.p_count = 0L;
        return bytes;
    }

    public boolean open(LASheader header, char compressor, int requested_version, int chunk_size) {
        ByteStreamOutArray out = new ByteStreamOutArray();
        return this.open(out, header, compressor, requested_version, chunk_size);
    }

    public boolean open(String file_name, LASheader header, char compressor, int requested_version, int chunk_size, int io_buffer_size) {
        if (file_name == null) {
            Cstdio.fprintf(stderr, "ERROR: file name is null\n", new Object[0]);
            return Boolean.FALSE;
        }
        this.file = Cstdio.fopenRAF(file_name.toCharArray(), "rwb");
        if (this.file == null) {
            Cstdio.fprintf(stderr, "ERROR: cannot open file '%s' for write\n", file_name);
            return Boolean.FALSE;
        }
        return this.open(this.file, header, compressor, requested_version, chunk_size);
    }

    public boolean open(RandomAccessFile file, LASheader header, char compressor, int requested_version, int chunk_size) {
        ByteStreamOutFile out = new ByteStreamOutFile(file);
        return this.open(out, header, compressor, requested_version, chunk_size);
    }

    public boolean open(PrintStream stdout, LASheader header, char compressor, int requested_version, int chunk_size) {
        ByteStreamOutOstream out = new ByteStreamOutOstream(stdout);
        return this.open(out, header, compressor, requested_version, chunk_size);
    }

    public boolean open(ByteStreamOut stream, LASheader header, char compressor, int requested_version, int chunk_size) {
        byte[] description;
        char record_length_after_header;
        byte[] user_id;
        int i;
        if (stream == null) {
            Cstdio.fprintf(stderr, "ERROR: ByteStreamOut pointer is zero\n", new Object[0]);
            return Boolean.FALSE;
        }
        this.stream = stream;
        if (header == null) {
            Cstdio.fprintf(stderr, "ERROR: LASheader pointer is zero\n", new Object[0]);
            return Boolean.FALSE;
        }
        if (!header.check()) {
            return Boolean.FALSE;
        }
        this.quantizer.x_scale_factor = header.x_scale_factor;
        this.quantizer.y_scale_factor = header.y_scale_factor;
        this.quantizer.z_scale_factor = header.z_scale_factor;
        this.quantizer.x_offset = header.x_offset;
        this.quantizer.y_offset = header.y_offset;
        this.quantizer.z_offset = header.z_offset;
        LASpoint point = new LASpoint();
        byte[] point_data_format = new byte[1];
        char[] point_data_record_length = new char[1];
        boolean point_is_standard = Boolean.TRUE;
        if (header.laszip != null) {
            if (!point.init(this.quantizer, header.laszip.num_items, header.laszip.items, (LASattributer)header)) {
                return Boolean.FALSE;
            }
            point_is_standard = header.laszip.is_standard(point_data_format, point_data_record_length);
        } else {
            if (!point.init(this.quantizer, header.point_data_format, header.point_data_record_length, (LASattributer)header)) {
                return Boolean.FALSE;
            }
            point_data_format[0] = header.point_data_format;
            point_data_record_length[0] = header.point_data_record_length;
        }
        if (compressor != '\u0000' && point_data_format[0] > 5 && compressor != '\u0003') {
            Cstdio.fprintf(stderr, "ERROR: point type %d requires using \"native LAS 1.4 extension\" of LASzip\n", point_data_format[0]);
            return Boolean.FALSE;
        }
        LASzip laszip = null;
        int laszip_vlr_data_size = 0;
        if (compressor != '\u0000' || point_is_standard == Boolean.FALSE) {
            laszip = new LASzip();
            laszip.setup(point.num_items, point.items, compressor);
            if (chunk_size > -1) {
                laszip.set_chunk_size(chunk_size);
            }
            if (compressor == '\u0000') {
                laszip.request_version('\u0000');
            } else {
                if (chunk_size == 0 && point_data_format[0] <= 5) {
                    Cstdio.fprintf(stderr, "ERROR: adaptive chunking is depricated for point type %d.\n       only available for new LAS 1.4 point types 6 or higher.\n", point_data_format[0]);
                    return Boolean.FALSE;
                }
                if (requested_version != 0) {
                    laszip.request_version((char)requested_version);
                } else {
                    laszip.request_version('\u0002');
                }
            }
            laszip_vlr_data_size = 34 + 6 * laszip.num_items;
        }
        this.writer = new LASwritePoint();
        if (laszip != null) {
            if (!this.writer.setup(laszip.num_items, laszip.items, laszip)) {
                Cstdio.fprintf(stderr, "ERROR: point type %d of size %d not supported (with LASzip)\n", header.point_data_format, Character.valueOf(header.point_data_record_length));
                return Boolean.FALSE;
            }
        } else if (!this.writer.setup(point.num_items, point.items)) {
            Cstdio.fprintf(stderr, "ERROR: point type %d of size %d not supported\n", header.point_data_format, Character.valueOf(header.point_data_record_length));
            return Boolean.FALSE;
        }
        this.header_start_position = stream.tell();
        if (!stream.putBytes(header.file_signature, 4)) {
            Cstdio.fprintf(stderr, "ERROR: writing header->file_signature\n", new Object[0]);
            return Boolean.FALSE;
        }
        if (!stream.put16bitsLE(header.file_source_ID)) {
            Cstdio.fprintf(stderr, "ERROR: writing header->file_source_ID\n", new Object[0]);
            return Boolean.FALSE;
        }
        if (!stream.put16bitsLE(header.global_encoding)) {
            Cstdio.fprintf(stderr, "ERROR: writing header->global_encoding\n", new Object[0]);
            return Boolean.FALSE;
        }
        if (!stream.put32bitsLE(header.project_ID_GUID_data_1)) {
            Cstdio.fprintf(stderr, "ERROR: writing header->project_ID_GUID_data_1\n", new Object[0]);
            return Boolean.FALSE;
        }
        if (!stream.put16bitsLE(header.project_ID_GUID_data_2)) {
            Cstdio.fprintf(stderr, "ERROR: writing header->project_ID_GUID_data_2\n", new Object[0]);
            return Boolean.FALSE;
        }
        if (!stream.put16bitsLE(header.project_ID_GUID_data_3)) {
            Cstdio.fprintf(stderr, "ERROR: writing header->project_ID_GUID_data_3\n", new Object[0]);
            return Boolean.FALSE;
        }
        if (!stream.putBytes(header.project_ID_GUID_data_4, 8)) {
            Cstdio.fprintf(stderr, "ERROR: writing header->project_ID_GUID_data_4\n", new Object[0]);
            return Boolean.FALSE;
        }
        byte version_major = header.version_major;
        if (header.version_major != 1) {
            Cstdio.fprintf(stderr, "WARNING: header->version_major is %d. writing 1 instead.\n", header.version_major);
            version_major = 1;
        }
        if (!stream.putByte(version_major)) {
            Cstdio.fprintf(stderr, "ERROR: writing header->version_major\n", new Object[0]);
            return Boolean.FALSE;
        }
        int version_minor = header.version_minor;
        if (version_minor > 4) {
            Cstdio.fprintf(stderr, "WARNING: header->version_minor is %d. writing 4 instead.\n", (byte)version_minor);
            version_minor = 4;
        }
        if (!stream.putByte((byte)version_minor)) {
            Cstdio.fprintf(stderr, "ERROR: writing header->version_minor\n", new Object[0]);
            return Boolean.FALSE;
        }
        if (!stream.putBytes(header.system_identifier, 32)) {
            Cstdio.fprintf(stderr, "ERROR: writing header->system_identifier\n", new Object[0]);
            return Boolean.FALSE;
        }
        if (!stream.putBytes(header.generating_software, 32)) {
            Cstdio.fprintf(stderr, "ERROR: writing header->generating_software\n", new Object[0]);
            return Boolean.FALSE;
        }
        if (!stream.put16bitsLE(header.file_creation_day)) {
            Cstdio.fprintf(stderr, "ERROR: writing header->file_creation_day\n", new Object[0]);
            return Boolean.FALSE;
        }
        if (!stream.put16bitsLE(header.file_creation_year)) {
            Cstdio.fprintf(stderr, "ERROR: writing header->file_creation_year\n", new Object[0]);
            return Boolean.FALSE;
        }
        if (!stream.put16bitsLE(header.header_size)) {
            Cstdio.fprintf(stderr, "ERROR: writing header->header_size\n", new Object[0]);
            return Boolean.FALSE;
        }
        int offset_to_point_data = header.offset_to_point_data;
        if (laszip != null) {
            offset_to_point_data += 54 + laszip_vlr_data_size;
        }
        if (header.vlr_lastiling != null) {
            offset_to_point_data += 82;
        }
        if (header.vlr_lasoriginal != null) {
            offset_to_point_data += 230;
        }
        if (!stream.put32bitsLE(offset_to_point_data)) {
            Cstdio.fprintf(stderr, "ERROR: writing header->offset_to_point_data\n", new Object[0]);
            return Boolean.FALSE;
        }
        int number_of_variable_length_records = header.number_of_variable_length_records;
        if (laszip != null) {
            ++number_of_variable_length_records;
        }
        if (header.vlr_lastiling != null) {
            ++number_of_variable_length_records;
        }
        if (header.vlr_lasoriginal != null) {
            ++number_of_variable_length_records;
        }
        if (!stream.put32bitsLE(number_of_variable_length_records)) {
            Cstdio.fprintf(stderr, "ERROR: writing header->number_of_variable_length_records\n", new Object[0]);
            return Boolean.FALSE;
        }
        if (compressor != '\u0000') {
            point_data_format[0] = (byte)(point_data_format[0] | 0x80);
        }
        if (!stream.putByte(point_data_format[0])) {
            Cstdio.fprintf(stderr, "ERROR: writing header->point_data_format\n", new Object[0]);
            return Boolean.FALSE;
        }
        if (!stream.put16bitsLE(header.point_data_record_length)) {
            Cstdio.fprintf(stderr, "ERROR: writing header->point_data_record_length\n", new Object[0]);
            return Boolean.FALSE;
        }
        if (!stream.put32bitsLE(header.number_of_point_records)) {
            Cstdio.fprintf(stderr, "ERROR: writing header->number_of_point_records\n", new Object[0]);
            return Boolean.FALSE;
        }
        for (i = 0; i < 5; ++i) {
            if (stream.put32bitsLE(header.number_of_points_by_return[i])) continue;
            Cstdio.fprintf(stderr, "ERROR: writing header->number_of_points_by_return[%d]\n", i);
            return Boolean.FALSE;
        }
        if (!stream.put64bitsLE(Double.doubleToLongBits(header.x_scale_factor))) {
            Cstdio.fprintf(stderr, "ERROR: writing header->x_scale_factor\n", new Object[0]);
            return Boolean.FALSE;
        }
        if (!stream.put64bitsLE(Double.doubleToLongBits(header.y_scale_factor))) {
            Cstdio.fprintf(stderr, "ERROR: writing header->y_scale_factor\n", new Object[0]);
            return Boolean.FALSE;
        }
        if (!stream.put64bitsLE(Double.doubleToLongBits(header.z_scale_factor))) {
            Cstdio.fprintf(stderr, "ERROR: writing header->z_scale_factor\n", new Object[0]);
            return Boolean.FALSE;
        }
        if (!stream.put64bitsLE(Double.doubleToLongBits(header.x_offset))) {
            Cstdio.fprintf(stderr, "ERROR: writing header->x_offset\n", new Object[0]);
            return Boolean.FALSE;
        }
        if (!stream.put64bitsLE(Double.doubleToLongBits(header.y_offset))) {
            Cstdio.fprintf(stderr, "ERROR: writing header->y_offset\n", new Object[0]);
            return Boolean.FALSE;
        }
        if (!stream.put64bitsLE(Double.doubleToLongBits(header.z_offset))) {
            Cstdio.fprintf(stderr, "ERROR: writing header->z_offset\n", new Object[0]);
            return Boolean.FALSE;
        }
        if (!stream.put64bitsLE(Double.doubleToLongBits(header.max_x))) {
            Cstdio.fprintf(stderr, "ERROR: writing header->max_x\n", new Object[0]);
            return Boolean.FALSE;
        }
        if (!stream.put64bitsLE(Double.doubleToLongBits(header.min_x))) {
            Cstdio.fprintf(stderr, "ERROR: writing header->min_x\n", new Object[0]);
            return Boolean.FALSE;
        }
        if (!stream.put64bitsLE(Double.doubleToLongBits(header.max_y))) {
            Cstdio.fprintf(stderr, "ERROR: writing header->max_y\n", new Object[0]);
            return Boolean.FALSE;
        }
        if (!stream.put64bitsLE(Double.doubleToLongBits(header.min_y))) {
            Cstdio.fprintf(stderr, "ERROR: writing header->min_y\n", new Object[0]);
            return Boolean.FALSE;
        }
        if (!stream.put64bitsLE(Double.doubleToLongBits(header.max_z))) {
            Cstdio.fprintf(stderr, "ERROR: writing header->max_z\n", new Object[0]);
            return Boolean.FALSE;
        }
        if (!stream.put64bitsLE(Double.doubleToLongBits(header.min_z))) {
            Cstdio.fprintf(stderr, "ERROR: writing header->min_z\n", new Object[0]);
            return Boolean.FALSE;
        }
        if (version_minor >= 3) {
            long start_of_waveform_data_packet_record = header.start_of_waveform_data_packet_record;
            if (start_of_waveform_data_packet_record != 0L) {
                Cstdio.fprintf(stderr, "WARNING: header->start_of_waveform_data_packet_record is %d. writing 0 instead.\n", start_of_waveform_data_packet_record);
                start_of_waveform_data_packet_record = 0L;
            }
            if (!stream.put64bitsLE(start_of_waveform_data_packet_record)) {
                Cstdio.fprintf(stderr, "ERROR: writing start_of_waveform_data_packet_record\n", new Object[0]);
                return Boolean.FALSE;
            }
        }
        if (version_minor >= 4) {
            this.writing_las_1_4 = Boolean.TRUE;
            this.writing_new_point_type = header.point_data_format >= 6 ? Boolean.TRUE.booleanValue() : Boolean.FALSE.booleanValue();
            this.start_of_first_extended_variable_length_record = header.start_of_first_extended_variable_length_record;
            if (!stream.put64bitsLE(this.start_of_first_extended_variable_length_record)) {
                Cstdio.fprintf(stderr, "ERROR: writing header->start_of_first_extended_variable_length_record\n", new Object[0]);
                return Boolean.FALSE;
            }
            this.number_of_extended_variable_length_records = header.number_of_extended_variable_length_records;
            if (!stream.put32bitsLE(this.number_of_extended_variable_length_records)) {
                Cstdio.fprintf(stderr, "ERROR: writing header->number_of_extended_variable_length_records\n", new Object[0]);
                return Boolean.FALSE;
            }
            this.evlrs = header.evlrs;
            long extended_number_of_point_records = header.number_of_point_records != 0 ? (long)header.number_of_point_records : header.extended_number_of_point_records;
            if (!stream.put64bitsLE(extended_number_of_point_records)) {
                Cstdio.fprintf(stderr, "ERROR: writing header->extended_number_of_point_records\n", new Object[0]);
                return Boolean.FALSE;
            }
            for (i = 0; i < 15; ++i) {
                long extended_number_of_points_by_return = i < 5 && header.number_of_points_by_return[i] != 0 ? (long)header.number_of_points_by_return[i] : header.extended_number_of_points_by_return[i];
                if (stream.put64bitsLE(extended_number_of_points_by_return)) continue;
                Cstdio.fprintf(stderr, "ERROR: writing header->extended_number_of_points_by_return[%d]\n", i);
                return Boolean.FALSE;
            }
        } else {
            this.writing_las_1_4 = Boolean.FALSE;
            this.writing_new_point_type = Boolean.FALSE;
        }
        if (header.user_data_in_header_size != 0) {
            if (header.user_data_in_header != null) {
                if (!stream.putBytes(header.user_data_in_header, header.user_data_in_header_size)) {
                    Cstdio.fprintf(stderr, "ERROR: writing %d bytes of data from header->user_data_in_header\n", header.user_data_in_header_size);
                    return Boolean.FALSE;
                }
            } else {
                Cstdio.fprintf(stderr, "ERROR: there should be %d bytes of data in header->user_data_in_header\n", header.user_data_in_header_size);
                return Boolean.FALSE;
            }
        }
        for (i = 0; i < header.number_of_variable_length_records; ++i) {
            if (header.vlrs[i].reserved != '\uaabb') {
                // empty if block
            }
            if (!stream.put16bitsLE(header.vlrs[i].reserved)) {
                Cstdio.fprintf(stderr, "ERROR: writing header->vlrs[%d].reserved\n", i);
                return Boolean.FALSE;
            }
            if (!stream.putBytes(header.vlrs[i].user_id, 16)) {
                Cstdio.fprintf(stderr, "ERROR: writing header->vlrs[%d].user_id\n", i);
                return Boolean.FALSE;
            }
            if (!stream.put16bitsLE(header.vlrs[i].record_id)) {
                Cstdio.fprintf(stderr, "ERROR: writing header->vlrs[%d].record_id\n", i);
                return Boolean.FALSE;
            }
            if (!stream.put16bitsLE(header.vlrs[i].record_length_after_header)) {
                Cstdio.fprintf(stderr, "ERROR: writing header->vlrs[%d].record_length_after_header\n", i);
                return Boolean.FALSE;
            }
            if (!stream.putBytes(header.vlrs[i].description, 32)) {
                Cstdio.fprintf(stderr, "ERROR: writing header->vlrs[%d].description\n", i);
                return Boolean.FALSE;
            }
            if (header.vlrs[i].record_length_after_header == '\u0000') continue;
            if (header.vlrs[i].data != null) {
                if (stream.putBytes(header.vlrs[i].data, header.vlrs[i].record_length_after_header)) continue;
                Cstdio.fprintf(stderr, "ERROR: writing %d bytes of data from header->vlrs[%d].data\n", Character.valueOf(header.vlrs[i].record_length_after_header), i);
                return Boolean.FALSE;
            }
            Cstdio.fprintf(stderr, "ERROR: there should be %d bytes of data in header->vlrs[%d].data\n", Character.valueOf(header.vlrs[i].record_length_after_header), i);
            return Boolean.FALSE;
        }
        if (laszip != null) {
            char reserved = '\uaabb';
            if (!stream.put16bitsLE(reserved)) {
                Cstdio.fprintf(stderr, "ERROR: writing reserved %d\n", reserved);
                return Boolean.FALSE;
            }
            user_id = new byte[16];
            Cstdio.sprintf(user_id, "laszip encoded", new Object[0]);
            if (!stream.putBytes(user_id, 16)) {
                Cstdio.fprintf(stderr, "ERROR: writing user_id %s\n", MyDefs.stringFromByteArray(user_id));
                return Boolean.FALSE;
            }
            char record_id = '\u56bc';
            if (!stream.put16bitsLE(record_id)) {
                Cstdio.fprintf(stderr, "ERROR: writing record_id %d\n", record_id);
                return Boolean.FALSE;
            }
            record_length_after_header = (char)laszip_vlr_data_size;
            if (!stream.put16bitsLE(record_length_after_header)) {
                Cstdio.fprintf(stderr, "ERROR: writing record_length_after_header %d\n", record_length_after_header);
                return Boolean.FALSE;
            }
            description = new byte[32];
            Cstdio.sprintf(description, "by laszip of LAStools (%d)", 220310);
            if (!stream.putBytes(description, 32)) {
                Cstdio.fprintf(stderr, "ERROR: writing description %s\n", MyDefs.stringFromByteArray(description));
                return Boolean.FALSE;
            }
            if (!stream.put16bitsLE(laszip.compressor)) {
                Cstdio.fprintf(stderr, "ERROR: writing compressor %d\n", compressor);
                return Boolean.FALSE;
            }
            if (!stream.put16bitsLE(laszip.coder)) {
                Cstdio.fprintf(stderr, "ERROR: writing coder %d\n", laszip.coder);
                return Boolean.FALSE;
            }
            if (!stream.putByte(laszip.version_major)) {
                Cstdio.fprintf(stderr, "ERROR: writing version_major %d\n", laszip.version_major);
                return Boolean.FALSE;
            }
            if (!stream.putByte(laszip.version_minor)) {
                Cstdio.fprintf(stderr, "ERROR: writing version_minor %d\n", laszip.version_minor);
                return Boolean.FALSE;
            }
            if (!stream.put16bitsLE(laszip.version_revision)) {
                Cstdio.fprintf(stderr, "ERROR: writing version_revision %d\n", Character.valueOf(laszip.version_revision));
                return Boolean.FALSE;
            }
            if (!stream.put32bitsLE(laszip.options)) {
                Cstdio.fprintf(stderr, "ERROR: writing options %d\n", laszip.options);
                return Boolean.FALSE;
            }
            if (!stream.put32bitsLE(laszip.chunk_size)) {
                Cstdio.fprintf(stderr, "ERROR: writing chunk_size %d\n", laszip.chunk_size);
                return Boolean.FALSE;
            }
            if (!stream.put64bitsLE(laszip.number_of_special_evlrs)) {
                Cstdio.fprintf(stderr, "ERROR: writing number_of_special_evlrs %d\n", (int)laszip.number_of_special_evlrs);
                return Boolean.FALSE;
            }
            if (!stream.put64bitsLE(laszip.offset_to_special_evlrs)) {
                Cstdio.fprintf(stderr, "ERROR: writing offset_to_special_evlrs %d\n", laszip.offset_to_special_evlrs);
                return Boolean.FALSE;
            }
            if (!stream.put16bitsLE(laszip.num_items)) {
                Cstdio.fprintf(stderr, "ERROR: writing num_items %d\n", Character.valueOf(laszip.num_items));
                return Boolean.FALSE;
            }
            for (i = 0; i < laszip.num_items; ++i) {
                if (!stream.put16bitsLE((char)laszip.items[i].type.ordinal())) {
                    Cstdio.fprintf(stderr, "ERROR: writing type %d of item %d\n", laszip.items[i].type.ordinal(), i);
                    return Boolean.FALSE;
                }
                if (!stream.put16bitsLE(laszip.items[i].size)) {
                    Cstdio.fprintf(stderr, "ERROR: writing size %d of item %d\n", Character.valueOf(laszip.items[i].size), i);
                    return Boolean.FALSE;
                }
                if (stream.put16bitsLE(laszip.items[i].version)) continue;
                Cstdio.fprintf(stderr, "ERROR: writing version %d of item %d\n", Character.valueOf(laszip.items[i].version), i);
                return Boolean.FALSE;
            }
            laszip = null;
        }
        if (header.vlr_lastiling != null) {
            char reserved = '\uaabb';
            if (!stream.put16bitsLE(reserved)) {
                Cstdio.fprintf(stderr, "ERROR: writing reserved %d\n", reserved);
                return Boolean.FALSE;
            }
            user_id = new byte[16];
            Cstdio.sprintf(user_id, "LAStools", new Object[0]);
            if (!stream.putBytes(user_id, 16)) {
                Cstdio.fprintf(stderr, "ERROR: writing user_id %s\n", MyDefs.stringFromByteArray(user_id));
                return Boolean.FALSE;
            }
            char record_id = '\n';
            if (!stream.put16bitsLE(record_id)) {
                Cstdio.fprintf(stderr, "ERROR: writing record_id %d\n", record_id);
                return Boolean.FALSE;
            }
            record_length_after_header = '\u001c';
            if (!stream.put16bitsLE(record_length_after_header)) {
                Cstdio.fprintf(stderr, "ERROR: writing record_length_after_header %d\n", record_length_after_header);
                return Boolean.FALSE;
            }
            description = new byte[32];
            Cstdio.sprintf(description, "tile %s buffer %s", header.vlr_lastiling.buffer != 0 ? "with" : "without", header.vlr_lastiling.reversible != 0 ? ", reversible" : "");
            if (!stream.putBytes(description, 32)) {
                Cstdio.fprintf(stderr, "ERROR: writing description %s\n", MyDefs.stringFromByteArray(description));
                return Boolean.FALSE;
            }
            if (!stream.put32bitsLE(header.vlr_lastiling.level)) {
                Cstdio.fprintf(stderr, "ERROR: writing header->vlr_lastiling->level %u\n", header.vlr_lastiling.level);
                return Boolean.FALSE;
            }
            if (!stream.put32bitsLE(header.vlr_lastiling.level_index)) {
                Cstdio.fprintf(stderr, "ERROR: writing header->vlr_lastiling->level_index %u\n", header.vlr_lastiling.level_index);
                return Boolean.FALSE;
            }
            if (!stream.put32bitsLE(header.vlr_lastiling.implicit_levels)) {
                Cstdio.fprintf(stderr, "ERROR: writing header->vlr_lastiling->implicit_levels %u\n", header.vlr_lastiling.implicit_levels);
                return Boolean.FALSE;
            }
            if (!stream.put32bitsLE(Float.floatToIntBits(header.vlr_lastiling.min_x))) {
                Cstdio.fprintf(stderr, "ERROR: writing header->vlr_lastiling->min_x %g\n", Float.valueOf(header.vlr_lastiling.min_x));
                return Boolean.FALSE;
            }
            if (!stream.put32bitsLE(Float.floatToIntBits(header.vlr_lastiling.max_x))) {
                Cstdio.fprintf(stderr, "ERROR: writing header->vlr_lastiling->max_x %g\n", Float.valueOf(header.vlr_lastiling.max_x));
                return Boolean.FALSE;
            }
            if (!stream.put32bitsLE(Float.floatToIntBits(header.vlr_lastiling.min_y))) {
                Cstdio.fprintf(stderr, "ERROR: writing header->vlr_lastiling->min_y %g\n", Float.valueOf(header.vlr_lastiling.min_y));
                return Boolean.FALSE;
            }
            if (!stream.put32bitsLE(Float.floatToIntBits(header.vlr_lastiling.max_y))) {
                Cstdio.fprintf(stderr, "ERROR: writing header->vlr_lastiling->max_y %g\n", Float.valueOf(header.vlr_lastiling.max_y));
                return Boolean.FALSE;
            }
        }
        if (header.vlr_lasoriginal != null) {
            char reserved = '\uaabb';
            if (!stream.put16bitsLE(reserved)) {
                Cstdio.fprintf(stderr, "ERROR: writing reserved %d\n", reserved);
                return Boolean.FALSE;
            }
            user_id = new byte[16];
            Cstdio.sprintf(user_id, "LAStools", new Object[0]);
            if (!stream.putBytes(user_id, 16)) {
                Cstdio.fprintf(stderr, "ERROR: writing user_id %s\n", MyDefs.stringFromByteArray(user_id));
                return Boolean.FALSE;
            }
            char record_id = '\u0014';
            if (!stream.put16bitsLE(record_id)) {
                Cstdio.fprintf(stderr, "ERROR: writing record_id %d\n", record_id);
                return Boolean.FALSE;
            }
            record_length_after_header = '\u00b0';
            if (!stream.put16bitsLE(record_length_after_header)) {
                Cstdio.fprintf(stderr, "ERROR: writing record_length_after_header %d\n", record_length_after_header);
                return Boolean.FALSE;
            }
            description = new byte[32];
            Cstdio.sprintf(description, "counters and bbox of original", new Object[0]);
            if (!stream.putBytes(description, 32)) {
                Cstdio.fprintf(stderr, "ERROR: writing description %s\n", MyDefs.stringFromByteArray(description));
                return Boolean.FALSE;
            }
            header.vlr_lasoriginal.position = stream.tell();
            if (!stream.put64bitsLE(header.vlr_lasoriginal.number_of_point_records)) {
                Cstdio.fprintf(stderr, "ERROR: writing header->vlr_lasoriginal->number_of_point_records %d\n", header.vlr_lasoriginal.number_of_point_records);
                return Boolean.FALSE;
            }
            for (int j = 0; j < 15; ++j) {
                if (stream.put64bitsLE(header.vlr_lasoriginal.number_of_points_by_return[j])) continue;
                Cstdio.fprintf(stderr, "ERROR: writing header->vlr_lasoriginal->number_of_points_by_return[%u] %d\n", j, header.vlr_lasoriginal.number_of_points_by_return[j]);
                return Boolean.FALSE;
            }
            if (!stream.put64bitsLE(Double.doubleToLongBits(header.vlr_lasoriginal.min_x))) {
                Cstdio.fprintf(stderr, "ERROR: writing header->vlr_lasoriginal->min_x %g\n", header.vlr_lasoriginal.min_x);
                return Boolean.FALSE;
            }
            if (!stream.put64bitsLE(Double.doubleToLongBits(header.vlr_lasoriginal.max_x))) {
                Cstdio.fprintf(stderr, "ERROR: writing header->vlr_lasoriginal->max_x %g\n", header.vlr_lasoriginal.max_x);
                return Boolean.FALSE;
            }
            if (!stream.put64bitsLE(Double.doubleToLongBits(header.vlr_lasoriginal.min_y))) {
                Cstdio.fprintf(stderr, "ERROR: writing header->vlr_lasoriginal->min_y %g\n", header.vlr_lasoriginal.min_y);
                return Boolean.FALSE;
            }
            if (!stream.put64bitsLE(Double.doubleToLongBits(header.vlr_lasoriginal.max_y))) {
                Cstdio.fprintf(stderr, "ERROR: writing header->vlr_lasoriginal->max_y %g\n", header.vlr_lasoriginal.max_y);
                return Boolean.FALSE;
            }
            if (!stream.put64bitsLE(Double.doubleToLongBits(header.vlr_lasoriginal.min_z))) {
                Cstdio.fprintf(stderr, "ERROR: writing header->vlr_lasoriginal->min_z %g\n", header.vlr_lasoriginal.min_z);
                return Boolean.FALSE;
            }
            if (!stream.put64bitsLE(Double.doubleToLongBits(header.vlr_lasoriginal.max_z))) {
                Cstdio.fprintf(stderr, "ERROR: writing header->vlr_lasoriginal->max_z %g\n", header.vlr_lasoriginal.max_z);
                return Boolean.FALSE;
            }
        }
        if (header.user_data_after_header_size != 0) {
            if (header.user_data_after_header != null) {
                if (!stream.putBytes(header.user_data_after_header, header.user_data_after_header_size)) {
                    Cstdio.fprintf(stderr, "ERROR: writing %d bytes of data from header->user_data_after_header\n", header.user_data_after_header_size);
                    return Boolean.FALSE;
                }
            } else {
                Cstdio.fprintf(stderr, "ERROR: there should be %d bytes of data in header->user_data_after_header\n", header.user_data_after_header_size);
                return Boolean.FALSE;
            }
        }
        if (!this.writer.init(stream)) {
            return Boolean.FALSE;
        }
        this.npoints = header.number_of_point_records != 0 ? (long)header.number_of_point_records : header.extended_number_of_point_records;
        this.p_count = 0L;
        return Boolean.TRUE;
    }
}

