/*
 * Decompiled with CFR 0.152.
 */
package com.github.mreutegg.laszip4j.laslib;

import com.github.mreutegg.laszip4j.clib.Cstring;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class LASvlr_wave_packet_descr {
    private ByteBuffer data = ByteBuffer.allocate(26).order(ByteOrder.LITTLE_ENDIAN);

    LASvlr_wave_packet_descr() {
        this.clean();
    }

    void clean() {
        Cstring.memset(this.data, (byte)0, 26);
    }

    public byte getBitsPerSample() {
        return this.data.get(0);
    }

    public byte getCompressionType() {
        return this.data.get(1);
    }

    public int getNumberOfSamples() {
        return this.data.getInt(2);
    }

    public int getTemporalSpacing() {
        return this.data.getInt(6);
    }

    public double getDigitizerGain() {
        return this.data.getDouble(10);
    }

    public double getDigitizerOffset() {
        return this.data.getDouble(18);
    }

    public void setBitsPerSample(byte bps) {
        this.data.put(0, bps);
    }

    public void setCompressionType(byte compression) {
        this.data.put(1, compression);
    }

    public void setNumberOfSamples(int samples) {
        this.data.putInt(2, samples);
    }

    public void setTemporalSpacing(int spacing) {
        this.data.putInt(6, spacing);
    }

    public void setDigitizerGain(double gain) {
        this.data.putDouble(10, gain);
    }

    public void setDigitizerOffset(double offset) {
        this.data.putDouble(18, offset);
    }

    public static LASvlr_wave_packet_descr fromByteArray(byte[] data) {
        LASvlr_wave_packet_descr descr = new LASvlr_wave_packet_descr();
        descr.data.put(data);
        return descr;
    }
}

