/*
 * Decompiled with CFR 0.152.
 */
package com.github.mreutegg.laszip4j.laslib;

import com.github.mreutegg.laszip4j.clib.Cstdio;
import com.github.mreutegg.laszip4j.laslib.LAScriterion;
import com.github.mreutegg.laszip4j.laszip.LASpoint;

class LAScriterionKeepPointSourceBetween
extends LAScriterion {
    private char below_point_source_id;
    private char above_point_source_id;

    @Override
    public String name() {
        return "keep_point_source_between";
    }

    @Override
    public int get_command(StringBuilder string) {
        return Cstdio.sprintf(string, "-%s %d %d ", this.name(), Character.valueOf(this.below_point_source_id), Character.valueOf(this.above_point_source_id));
    }

    @Override
    public int get_decompress_selective() {
        return 64;
    }

    @Override
    public boolean filter(LASpoint point) {
        return point.getPoint_source_ID() < this.below_point_source_id || this.above_point_source_id < point.getPoint_source_ID();
    }

    LAScriterionKeepPointSourceBetween(char below_point_source_id, char above_point_source_id) {
        this.below_point_source_id = below_point_source_id;
        this.above_point_source_id = above_point_source_id;
    }
}

