/*
 * Decompiled with CFR 0.152.
 */
package com.github.mreutegg.laszip4j;

import com.github.mreutegg.laszip4j.laslib.LASvlr;
import com.github.mreutegg.laszip4j.laszip.MyDefs;
import java.nio.ByteBuffer;

public class LASVariableLengthRecord {
    private final LASvlr vlr;

    LASVariableLengthRecord(LASvlr vlr) {
        this.vlr = vlr;
    }

    public char getReserved() {
        return this.vlr.reserved;
    }

    public String getUserID() {
        return MyDefs.stringFromByteArray(this.vlr.user_id);
    }

    public char getRecordID() {
        return this.vlr.record_id;
    }

    public char getRecordLength() {
        return this.vlr.record_length_after_header;
    }

    public String getDescription() {
        return MyDefs.stringFromByteArray(this.vlr.description);
    }

    public ByteBuffer getData() {
        return ByteBuffer.wrap(this.vlr.data).asReadOnlyBuffer();
    }

    public String getDataAsString() {
        return MyDefs.stringFromByteArray(this.vlr.data);
    }
}

