/*
 * Decompiled with CFR 0.152.
 */
package com.github.mreutegg.laszip4j;

import com.github.mreutegg.laszip4j.laslib.LASevlr;
import com.github.mreutegg.laszip4j.laszip.MyDefs;
import java.nio.ByteBuffer;

public class LASExtendedVariableLengthRecord {
    private final LASevlr evlr;

    LASExtendedVariableLengthRecord(LASevlr evlr) {
        this.evlr = evlr;
    }

    public char getReserved() {
        return this.evlr.reserved;
    }

    public String getUserID() {
        return MyDefs.stringFromByteArray(this.evlr.user_id);
    }

    public char getRecordID() {
        return this.evlr.record_id;
    }

    public long getRecordLength() {
        return this.evlr.record_length_after_header;
    }

    public String getDescription() {
        return MyDefs.stringFromByteArray(this.evlr.description);
    }

    public ByteBuffer getData() {
        return ByteBuffer.wrap(this.evlr.data).asReadOnlyBuffer();
    }

    public String getDataAsString() {
        return MyDefs.stringFromByteArray(this.evlr.data);
    }
}

