/*
 * Decompiled with CFR 0.152.
 */
package com.baggonius.gson.optional;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

abstract class OptionalTypeAdapter<E, T>
extends TypeAdapter<E> {
    private final TypeAdapter<T> elementAdapter;

    OptionalTypeAdapter(TypeAdapter<T> elementAdapter) {
        this.elementAdapter = elementAdapter;
    }

    protected abstract boolean isPresent(E var1);

    protected abstract T getValue(E var1);

    protected abstract E presentOptional(T var1);

    protected abstract E emptyOptional();

    public void write(JsonWriter out, E value) throws IOException {
        if (value == null || !this.isPresent(value)) {
            out.nullValue();
            return;
        }
        this.elementAdapter.write(out, this.getValue(value));
    }

    public E read(JsonReader in) throws IOException {
        if (in.peek() == JsonToken.NULL) {
            in.nextNull();
            return this.emptyOptional();
        }
        return this.presentOptional(this.elementAdapter.read(in));
    }
}

