/*
 * Decompiled with CFR 0.152.
 */
package com.baggonius.gson.immutable;

import com.baggonius.gson.common.ImmutableDeserializerException;
import com.baggonius.gson.immutable.Types;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Map;

abstract class BaseMapDeserializer<E>
implements JsonDeserializer<E> {
    BaseMapDeserializer() {
    }

    protected abstract E buildFrom(Map<?, ?> var1);

    public E deserialize(JsonElement json, Type type, JsonDeserializationContext context) {
        try {
            Type[] typeArguments = ((ParameterizedType)type).getActualTypeArguments();
            Type parameterizedType = Types.hashMapOf(typeArguments[0], typeArguments[1]).getType();
            Map map = (Map)context.deserialize(json, parameterizedType);
            return this.buildFrom(map);
        }
        catch (Exception e) {
            throw new ImmutableDeserializerException(e);
        }
    }
}

