/*
 * Decompiled with CFR 0.152.
 */
package com.baggonius.gson.immutable;

import com.baggonius.gson.common.ImmutableDeserializerException;
import com.baggonius.gson.immutable.Types;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;

abstract class BaseCollectionDeserializer<E>
implements JsonDeserializer<E> {
    BaseCollectionDeserializer() {
    }

    protected abstract E buildFrom(Collection<?> var1);

    public E deserialize(JsonElement json, Type type, JsonDeserializationContext context) {
        try {
            Type[] typeArguments = ((ParameterizedType)type).getActualTypeArguments();
            Type parameterizedType = Types.collectionOf(typeArguments[0]).getType();
            Collection collection = (Collection)context.deserialize(json, parameterizedType);
            return this.buildFrom(collection);
        }
        catch (Exception e) {
            throw new ImmutableDeserializerException(e);
        }
    }
}

